/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf4j.core.sink;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.sink.QuadSink;

public class RDF4JSink
implements QuadSink {
    public static final String RDF_HANDLER_PROPERTY = "http://semarglproject.org/sesame/properties/rdf-handler";
    public static final String VALUE_FACTORY_PROPERTY = "http://semarglproject.org/sesame/properties/value-factory";
    protected RDFHandler handler;
    protected ValueFactory valueFactory = SimpleValueFactory.getInstance();

    protected RDF4JSink(RDFHandler handler) {
        this.handler = handler;
    }

    public static QuadSink connect(RDFHandler handler) {
        return new RDF4JSink(handler);
    }

    private Resource convertNonLiteral(String arg) {
        if (arg.startsWith("_:")) {
            return this.valueFactory.createBNode(arg.substring(2));
        }
        return this.valueFactory.createIRI(arg);
    }

    public final void addNonLiteral(String subj, String pred, String obj) {
        this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createIRI(pred), (Value)this.convertNonLiteral(obj));
    }

    public final void addPlainLiteral(String subj, String pred, String content, String lang) {
        if (lang == null) {
            this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createIRI(pred), (Value)this.valueFactory.createLiteral(content));
        } else {
            this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createIRI(pred), (Value)this.valueFactory.createLiteral(content, lang));
        }
    }

    public final void addTypedLiteral(String subj, String pred, String content, String type) {
        Literal literal = this.valueFactory.createLiteral(content, this.valueFactory.createIRI(type));
        this.addTriple(this.convertNonLiteral(subj), this.valueFactory.createIRI(pred), (Value)literal);
    }

    protected void addTriple(Resource subject, IRI predicate, Value object) {
        try {
            this.handler.handleStatement(this.valueFactory.createStatement(subject, predicate, object));
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public final void addNonLiteral(String subj, String pred, String obj, String graph) {
        if (graph == null) {
            this.addNonLiteral(subj, pred, obj);
        } else {
            this.addQuad(this.convertNonLiteral(subj), this.valueFactory.createIRI(pred), (Value)this.convertNonLiteral(obj), this.convertNonLiteral(graph));
        }
    }

    public final void addPlainLiteral(String subj, String pred, String content, String lang, String graph) {
        if (graph == null) {
            this.addPlainLiteral(subj, pred, content, lang);
        } else if (lang == null) {
            this.addQuad(this.convertNonLiteral(subj), this.valueFactory.createIRI(pred), (Value)this.valueFactory.createLiteral(content), this.convertNonLiteral(graph));
        } else {
            this.addQuad(this.convertNonLiteral(subj), this.valueFactory.createIRI(pred), (Value)this.valueFactory.createLiteral(content, lang), this.convertNonLiteral(graph));
        }
    }

    public final void addTypedLiteral(String subj, String pred, String content, String type, String graph) {
        if (graph == null) {
            this.addTypedLiteral(subj, pred, content, type);
        } else {
            Literal literal = this.valueFactory.createLiteral(content, this.valueFactory.createIRI(type));
            this.addQuad(this.convertNonLiteral(subj), this.valueFactory.createIRI(pred), (Value)literal, this.convertNonLiteral(graph));
        }
    }

    protected void addQuad(Resource subject, IRI predicate, Value object, Resource graph) {
        try {
            this.handler.handleStatement(this.valueFactory.createStatement(subject, predicate, object, graph));
        }
        catch (RDFHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    public void startStream() throws ParseException {
        try {
            this.handler.startRDF();
        }
        catch (RDFHandlerException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public void endStream() throws ParseException {
        try {
            this.handler.endRDF();
        }
        catch (RDFHandlerException e) {
            throw new ParseException((Throwable)e);
        }
    }

    public boolean setProperty(String key, Object value) {
        if (RDF_HANDLER_PROPERTY.equals(key) && value instanceof RDFHandler) {
            this.handler = (RDFHandler)value;
        } else if (VALUE_FACTORY_PROPERTY.equals(key) && value instanceof ValueFactory) {
            this.valueFactory = (ValueFactory)value;
        } else {
            return false;
        }
        return true;
    }

    public void setBaseUri(String baseUri) {
    }
}

