/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf4j.rdf.rdfa;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.ParseErrorListener;
import org.eclipse.rdf4j.rio.ParseLocationListener;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.RDFaParserSettings;
import org.eclipse.rdf4j.rio.helpers.RDFaVersion;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.ProcessorGraphHandler;
import org.semarglproject.rdf.rdfa.RdfaParser;
import org.semarglproject.rdf4j.core.sink.RDF4JSink;
import org.semarglproject.rdf4j.rdf.rdfa.SemarglParserSettings;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.source.StreamProcessor;
import org.xml.sax.XMLReader;

public final class RDF4JRDFaParser
implements RDFParser,
ProcessorGraphHandler {
    private ParserConfig parserConfig;
    private final StreamProcessor streamProcessor = new StreamProcessor((DataSink)RdfaParser.connect((TripleSink)RDF4JSink.connect(null)));
    private ParseErrorListener parseErrorListener;

    public RDF4JRDFaParser() {
        this.streamProcessor.setProperty("http://semarglproject.org/core/properties/processor-graph-handler", (Object)this);
        this.setParserConfig(new ParserConfig());
        this.setPreserveBNodeIDs(true);
        this.parseErrorListener = null;
    }

    public RDF4JRDFaParser(XMLReader xmlReader) {
        this();
        this.setXmlReader(xmlReader);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.RDFA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream in, String baseURI) throws RDFParseException, RDFHandlerException {
        InputStreamReader reader = new InputStreamReader(in, Charset.forName("UTF-8"));
        try {
            this.parse(reader, baseURI);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void parse(Reader reader, String baseURI) throws RDFParseException, RDFHandlerException {
        this.refreshSettings();
        try {
            this.streamProcessor.process(reader, baseURI);
        }
        catch (ParseException e) {
            throw new RDFParseException((Throwable)e);
        }
    }

    public RDFParser setValueFactory(ValueFactory valueFactory) {
        this.streamProcessor.setProperty("http://semarglproject.org/sesame/properties/value-factory", (Object)valueFactory);
        return this;
    }

    public RDFParser setRDFHandler(RDFHandler handler) {
        this.streamProcessor.setProperty("http://semarglproject.org/sesame/properties/rdf-handler", (Object)handler);
        return this;
    }

    public RDFParser setParseErrorListener(ParseErrorListener el) {
        this.parseErrorListener = el;
        return this;
    }

    public RDFParser setParseLocationListener(ParseLocationListener ll) {
        return this;
    }

    public RDFParser setParserConfig(ParserConfig config) {
        this.parserConfig = config;
        this.refreshSettings();
        return this;
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        ArrayList result = new ArrayList(5);
        result.add(BasicParserSettings.PRESERVE_BNODE_IDS);
        result.add(SemarglParserSettings.PROCESSOR_GRAPH_ENABLED);
        result.add(RDFaParserSettings.VOCAB_EXPANSION_ENABLED);
        result.add(RDFaParserSettings.RDFA_COMPATIBILITY);
        result.add(SemarglParserSettings.CUSTOM_XML_READER);
        return result;
    }

    public <T> RDFParser set(RioSetting<T> setting, T value) {
        this.parserConfig.set(setting, value);
        return this;
    }

    public void setVerifyData(boolean verifyData) {
    }

    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.parserConfig.set(BasicParserSettings.PRESERVE_BNODE_IDS, (Object)preserveBNodeIDs);
        this.refreshSettings();
    }

    public void setStopAtFirstError(boolean stopAtFirstError) {
    }

    public void setDatatypeHandling(RDFParser.DatatypeHandling datatypeHandling) {
    }

    public void setProcessorGraphEnabled(boolean processorGraphEnabled) {
        this.parserConfig.set(SemarglParserSettings.PROCESSOR_GRAPH_ENABLED, (Object)processorGraphEnabled);
        this.refreshSettings();
    }

    public void setVocabExpansionEnabled(boolean vocabExpansionEnabled) {
        this.parserConfig.set(RDFaParserSettings.VOCAB_EXPANSION_ENABLED, (Object)vocabExpansionEnabled);
        this.refreshSettings();
    }

    public void setRdfaCompatibility(short rdfaCompatibility) {
        RDFaVersion version = RDFaVersion.RDFA_1_1;
        if (rdfaCompatibility == 1) {
            version = RDFaVersion.RDFA_1_0;
        } else if (rdfaCompatibility == 2) {
            version = RDFaVersion.RDFA_1_1;
        }
        this.setRdfaCompatibility(version);
    }

    public void setRdfaCompatibility(RDFaVersion version) {
        this.parserConfig.set(RDFaParserSettings.RDFA_COMPATIBILITY, (Object)version);
        this.refreshSettings();
    }

    public void setXmlReader(XMLReader reader) {
        this.parserConfig.set(SemarglParserSettings.CUSTOM_XML_READER, (Object)reader);
        this.refreshSettings();
    }

    private void refreshSettings() {
        short rdfaCompatibility = 2;
        RDFaVersion version = (RDFaVersion)this.parserConfig.get(RDFaParserSettings.RDFA_COMPATIBILITY);
        if (version == RDFaVersion.RDFA_1_0) {
            rdfaCompatibility = 1;
        } else if (version == RDFaVersion.RDFA_1_1) {
            rdfaCompatibility = 2;
        }
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/version", (Object)rdfaCompatibility);
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-vocab-expansion", this.parserConfig.get(RDFaParserSettings.VOCAB_EXPANSION_ENABLED));
        this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-processor-graph", this.parserConfig.get(SemarglParserSettings.PROCESSOR_GRAPH_ENABLED));
        this.streamProcessor.setProperty("http://semarglproject.org/core/properties/xml-parser", this.parserConfig.get(SemarglParserSettings.CUSTOM_XML_READER));
    }

    public void info(String infoClass, String message) {
    }

    public void warning(String warningClass, String message) {
        if (this.parseErrorListener != null) {
            this.parseErrorListener.warning(message, -1L, -1L);
        }
    }

    public void error(String errorClass, String message) {
        if (this.parseErrorListener != null) {
            this.parseErrorListener.error(message, -1L, -1L);
        }
    }
}

