/**
 * Copyright 2012-2013 Lev Khomich
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.semarglproject.vocab;

/**
 * Defines URIs for the XSD primitive datatypes.
 */
public final class XSD {

    public static final String NS = "http://www.w3.org/2001/XMLSchema#";

    public static final String ANY_URI = NS + "anyURI";
    public static final String BASE64_BINARY = NS + "base64Binary";
    public static final String DATE = NS + "date";
    public static final String DATE_TIME = NS + "dateTime";
    public static final String DECIMAL = NS + "decimal";
    public static final String DURATION = NS + "duration";
    public static final String ENTITIES = NS + "ENTITIES";
    public static final String ENTITY = NS + "ENTITY";
    public static final String G_DAY = NS + "gDay";
    public static final String G_MONTH = NS + "gMonth";
    public static final String G_MONTH_DAY = NS + "gMonthDay";
    public static final String G_YEAR = NS + "gYear";
    public static final String G_YEAR_MONTH = NS + "gYearMonth";
    public static final String HEX_BINARY = NS + "hexBinary";
    public static final String ID = NS + "ID";
    public static final String IDREF = NS + "IDREF";
    public static final String IDREFS = NS + "IDREFS";
    public static final String INTEGER = NS + "integer";
    public static final String LANGUAGE = NS + "language";
    public static final String NAME = NS + "Name";
    public static final String NC_NAME = NS + "NCName";
    public static final String NEGATIVE_INTEGER = NS + "negativeInteger";
    public static final String NMTOKEN = NS + "NMTOKEN";
    public static final String NMTOKENS = NS + "NMTOKENS";
    public static final String NON_NEGATIVE_INTEGER = NS + "nonNegativeInteger";
    public static final String NON_POSITIVE_INTEGER = NS + "nonPositiveInteger";
    public static final String NORMALIZED_STRING = NS + "normalizedString";
    public static final String NOTATION = NS + "NOTATION";
    public static final String POSITIVE_INTEGER = NS + "positiveInteger";
    public static final String QNAME = NS + "QName";
    public static final String TIME = NS + "time";
    public static final String TOKEN = NS + "token";
    public static final String UNSIGNED_BYTE = NS + "unsignedByte";
    public static final String UNSIGNED_INT = NS + "unsignedInt";
    public static final String UNSIGNED_LONG = NS + "unsignedLong";
    public static final String UNSIGNED_SHORT = NS + "unsignedShort";
    public static final String BOOLEAN = NS + "boolean";
    public static final String BYTE = NS + "byte";
    public static final String DOUBLE = NS + "double";
    public static final String FLOAT = NS + "float";
    public static final String INT = NS + "int";
    public static final String LONG = NS + "long";
    public static final String SHORT = NS + "short";
    public static final String STRING = NS + "string";

    private XSD() {
    }
}
