/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf.rdfa;

import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryExecution;
import com.hp.hpl.jena.query.QueryExecutionFactory;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QuerySolution;
import com.hp.hpl.jena.query.ResultSet;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.semarglproject.rdf.ParseException;
import org.testng.Assert;

public final class RdfaTestBundle {
    private static final String FAILURES_DIR = "target/failed/";
    private static final String RDFA_TESTSUITE_ROOT = "http://rdfa.info/test-suite/test-cases/";
    private static final String RDFA_TESTSUITE_MANIFEST_URI = "http://rdfa.info/test-suite/test-cases/manifest.ttl";

    private static String fixTestFilePath(String input, String pathDelta, String actualExt) {
        int pos = input.lastIndexOf(47);
        String path = input.substring(0, pos + 1);
        String filename = input.substring(pos + 1);
        return path + pathDelta + filename.replaceAll("\\.\\w+$", "." + actualExt);
    }

    public static Collection<TestCase> getTestCases(String rdfaVersion, String docFormat) {
        ArrayList<TestCase> testCases = new ArrayList<TestCase>();
        String docExt = docFormat.replaceAll("[0-9]", "");
        String queryStr = null;
        Model graph = ModelFactory.createDefaultModel();
        try {
            graph.read(RdfaTestBundle.openStreamForResource(RDFA_TESTSUITE_MANIFEST_URI), RDFA_TESTSUITE_MANIFEST_URI, "TTL");
            queryStr = IOUtils.toString((InputStream)RdfaTestBundle.openStreamForResource("rdfa-testsuite/fetch_tests.sparql"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        queryStr = queryStr.replace("!rdfa_version", "\"" + rdfaVersion + "\"").replace("!host_lang", "\"" + docFormat + "\"");
        Query query = QueryFactory.create((String)queryStr, (String)RDFA_TESTSUITE_MANIFEST_URI);
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)graph);
        ResultSet rs = qe.execSelect();
        HashSet<String> addedCases = new HashSet<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.next();
            String caseName = qs.getResource("test_case").getURI();
            if (addedCases.contains(caseName)) continue;
            addedCases.add(caseName);
            boolean expectedResult = true;
            if (qs.getLiteral("exp_result") != null) {
                expectedResult = qs.getLiteral("exp_result").getBoolean();
            }
            String pathDelta = rdfaVersion + "/" + docFormat + "/";
            String input = qs.getResource("input").getURI();
            input = RdfaTestBundle.fixTestFilePath(input, pathDelta, docExt);
            String result = qs.getResource("result").getURI();
            result = RdfaTestBundle.fixTestFilePath(result, pathDelta, "sparql");
            try {
                int testNum = Integer.parseInt(caseName.substring(caseName.lastIndexOf("/") + 1));
                if (testNum == 294 && rdfaVersion.equals("rdfa1.0") && docFormat.equals("svg") || testNum >= 321 && testNum <= 324) {
                    continue;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            testCases.add(new TestCase(caseName, input, result, expectedResult));
        }
        qe.close();
        return testCases;
    }

    public static void prepareTestDir() {
        try {
            File testDir = new File(FAILURES_DIR);
            testDir.mkdirs();
            FileUtils.cleanDirectory((File)testDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void downloadAllTests(int parallelism) throws InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(parallelism);
        executorService.execute(new TestDownloadWorker("rdfa1.0", "xhtml1"));
        executorService.execute(new TestDownloadWorker("rdfa1.0", "svg"));
        executorService.execute(new TestDownloadWorker("rdfa1.1", "html4"));
        executorService.execute(new TestDownloadWorker("rdfa1.1", "xhtml1"));
        executorService.execute(new TestDownloadWorker("rdfa1.1", "html5"));
        executorService.execute(new TestDownloadWorker("rdfa1.1", "xml"));
        executorService.execute(new TestDownloadWorker("rdfa1.1", "svg"));
        executorService.shutdown();
        executorService.awaitTermination(10L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTestBundle(TestCase testCase, SaveToFileCallback callback, short rdfaVersion) {
        String inputUri = testCase.getInput();
        String resultFilePath = RdfaTestBundle.getOutputPath(inputUri);
        new File(resultFilePath).getParentFile().mkdirs();
        try {
            try {
                InputStreamReader input = new InputStreamReader(RdfaTestBundle.openStreamForResource(inputUri), "UTF-8");
                OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFilePath), "UTF-8");
                try {
                    callback.run(input, inputUri, output, rdfaVersion);
                }
                finally {
                    IOUtils.closeQuietly((Reader)input);
                    IOUtils.closeQuietly((Writer)output);
                }
            }
            catch (ParseException e) {
                // empty catch block
            }
            Model resultModel = RdfaTestBundle.createModelFromFile(resultFilePath, inputUri);
            String queryStr = IOUtils.toString((InputStream)RdfaTestBundle.openStreamForResource(testCase.getResult()), (String)"UTF-8");
            Assert.assertEquals((boolean)RdfaTestBundle.askModel(resultModel, queryStr), (boolean)testCase.getExpectedResult());
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    private static void downloadMissingTest(String testUrl) throws IOException {
        File inputFile = new File(testUrl.replace(RDFA_TESTSUITE_ROOT, "src/test/resources/rdfa-testsuite/"));
        if (!inputFile.exists()) {
            FileUtils.copyURLToFile((URL)new URL(testUrl), (File)inputFile);
        }
    }

    private static boolean askModel(Model model, String queryStr) throws IOException {
        Query query = QueryFactory.create((String)queryStr);
        QueryExecution qe = QueryExecutionFactory.create((Query)query, (Model)model);
        boolean result = qe.execAsk();
        qe.close();
        return result;
    }

    private static String getOutputPath(String uri) {
        if (uri == null) {
            return null;
        }
        String result = uri;
        if (uri.startsWith(RDFA_TESTSUITE_ROOT)) {
            result = uri.replace(RDFA_TESTSUITE_ROOT, FAILURES_DIR);
        }
        return result + ".out.ttl";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Model createModelFromFile(String filename, String baseUri) throws FileNotFoundException {
        String fileFormat = RdfaTestBundle.detectFileFormat(filename);
        Model result = ModelFactory.createDefaultModel();
        InputStream inputStream = RdfaTestBundle.openStreamForResource(filename);
        try {
            result.read(inputStream, baseUri, fileFormat);
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
        return result;
    }

    private static String detectFileFormat(String filename) {
        String fileFormat;
        if (filename.endsWith(".nt")) {
            fileFormat = "N-TRIPLE";
        } else if (filename.endsWith(".ttl")) {
            fileFormat = "TURTLE";
        } else if (filename.endsWith(".rdf")) {
            fileFormat = "RDF/XML";
        } else {
            throw new IllegalArgumentException("Unknown file format");
        }
        return fileFormat;
    }

    private static InputStream openStreamForResource(String uri) throws FileNotFoundException {
        File file;
        String result = uri;
        if (uri.startsWith(RDFA_TESTSUITE_ROOT)) {
            result = uri.replace(RDFA_TESTSUITE_ROOT, "rdfa-testsuite/");
        }
        if ((file = new File(result)).exists()) {
            return new FileInputStream(file);
        }
        result = RdfaTestBundle.class.getClassLoader().getResource(result).getFile();
        if (result.contains(".jar!/")) {
            try {
                return new URL("jar:" + result).openStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return new FileInputStream(result);
    }

    private static final class TestDownloadWorker
    implements Runnable {
        private final Collection<TestCase> tests;

        private TestDownloadWorker(String rdfaVersion, String docFormat) {
            this.tests = RdfaTestBundle.getTestCases(rdfaVersion, docFormat);
        }

        @Override
        public void run() {
            for (TestCase test : this.tests) {
                try {
                    RdfaTestBundle.downloadMissingTest(test.getInput());
                    RdfaTestBundle.downloadMissingTest(test.getResult());
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static final class TestCase {
        private final String name;
        private final String input;
        private final String result;
        private final boolean expectedResult;

        public TestCase(String name, String input, String result, boolean expectedResult) {
            this.name = name;
            this.input = input;
            this.result = result;
            this.expectedResult = expectedResult;
        }

        public String getInput() {
            return this.input;
        }

        public String getResult() {
            return this.result;
        }

        public boolean getExpectedResult() {
            return this.expectedResult;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface SaveToFileCallback {
        public void run(Reader var1, String var2, Writer var3, short var4) throws ParseException;
    }
}

