/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf.rdfa;

import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.rdf.TurtleSerializer;
import org.semarglproject.rdf.rdfa.RdfaParser;
import org.semarglproject.rdf.rdfa.RdfaTestSuiteHelper;
import org.semarglproject.sink.CharOutputSink;
import org.semarglproject.sink.CharSink;
import org.semarglproject.sink.DataSink;
import org.semarglproject.sink.TripleSink;
import org.semarglproject.source.StreamProcessor;
import org.semarglproject.test.TestNGHelper;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public final class RdfaParserTest {
    private CharOutputSink charOutputSink;
    private StreamProcessor streamProcessor;
    private RdfaTestSuiteHelper.SaveToFileCallback semarglTurtleCallback = new RdfaTestSuiteHelper.SaveToFileCallback(){

        @Override
        public void run(Reader input, String inputUri, Writer output, short rdfaVersion) throws ParseException {
            RdfaParserTest.this.charOutputSink.connect(output);
            RdfaParserTest.this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/version", (Object)rdfaVersion);
            RdfaParserTest.this.streamProcessor.setProperty("http://semarglproject.org/rdfa/properties/enable-vocab-expansion", (Object)true);
            RdfaParserTest.this.streamProcessor.process(input, inputUri);
        }

        @Override
        public String getOutputFileExt() {
            return "ttl";
        }
    };

    @BeforeClass
    public void init() throws SAXException, InterruptedException {
        this.charOutputSink = new CharOutputSink("UTF-8");
        this.streamProcessor = new StreamProcessor((DataSink)RdfaParser.connect((TripleSink)TurtleSerializer.connect((CharSink)this.charOutputSink)));
    }

    @DataProvider
    public static Object[][] getTestSuite(Method method) {
        String methodName = method.getName();
        String rdfaVersion = "rdfa1.0";
        if (methodName.startsWith("runRdfa11")) {
            rdfaVersion = "rdfa1.1";
        }
        String fileFormat = methodName.substring(9, methodName.indexOf("Tests")).toLowerCase();
        return TestNGHelper.toArray(RdfaTestSuiteHelper.getTestSuite(rdfaVersion, fileFormat));
    }

    @Test(dataProvider="getTestSuite")
    public void runRdfa10Xhtml1Tests(RdfaTestSuiteHelper.TestCase testCase) {
        RdfaTestSuiteHelper.runTestBundle(testCase, this.semarglTurtleCallback, (short)1);
    }

    @Test(dataProvider="getTestSuite")
    public void runRdfa10SvgTests(RdfaTestSuiteHelper.TestCase testCase) {
        RdfaTestSuiteHelper.runTestBundle(testCase, this.semarglTurtleCallback, (short)1);
    }

    @Test(dataProvider="getTestSuite")
    public void runRdfa10XmlTests(RdfaTestSuiteHelper.TestCase testCase) {
        if (!testCase.name.contains("212")) {
            RdfaTestSuiteHelper.runTestBundle(testCase, this.semarglTurtleCallback, (short)1);
        }
    }

    @Test(dataProvider="getTestSuite")
    public void runRdfa11Html4Tests(RdfaTestSuiteHelper.TestCase testCase) {
        RdfaTestSuiteHelper.runTestBundle(testCase, this.semarglTurtleCallback, (short)2);
    }

    @Test(dataProvider="getTestSuite")
    public void runRdfa11Xhtml1Tests(RdfaTestSuiteHelper.TestCase testCase) {
        RdfaTestSuiteHelper.runTestBundle(testCase, this.semarglTurtleCallback, (short)2);
    }

    @Test(dataProvider="getTestSuite")
    public void runRdfa11Html5Tests(RdfaTestSuiteHelper.TestCase testCase) {
        RdfaTestSuiteHelper.runTestBundle(testCase, this.semarglTurtleCallback, (short)2);
    }

    @Test(dataProvider="getTestSuite")
    public void runRdfa11XmlTests(RdfaTestSuiteHelper.TestCase testCase) {
        RdfaTestSuiteHelper.runTestBundle(testCase, this.semarglTurtleCallback, (short)2);
    }

    @Test(dataProvider="getTestSuite")
    public void runRdfa11SvgTests(RdfaTestSuiteHelper.TestCase testCase) {
        RdfaTestSuiteHelper.runTestBundle(testCase, this.semarglTurtleCallback, (short)2);
    }
}

