/*
 * Decompiled with CFR 0.152.
 */
package org.semarglproject.rdf.rdfa;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.semarglproject.rdf.ParseException;
import org.semarglproject.test.SesameTestHelper;
import org.testng.Assert;

public final class RdfaTestSuiteHelper {
    private static final String TEST_OUTPUT_DIR = "target/rdfa-output/";
    static final String RDFA_TESTSUITE_ROOT = "http://rdfa.info/test-suite/test-cases/";
    private static final String RDFA_TESTSUITE_MANIFEST_URI = "http://rdfa.info/test-suite/test-cases/manifest.ttl";
    private static final Map<String, String> LOCAL_MIRRORS = new HashMap<String, String>(){
        {
            this.put(RdfaTestSuiteHelper.RDFA_TESTSUITE_ROOT, "rdfa-testsuite/");
        }
    };
    private static final SesameTestHelper sth = new SesameTestHelper("target/rdfa-output/", LOCAL_MIRRORS);
    private static final String FETCH_RDFA_TESTS_SPARQL = "http://rdfa.info/test-suite/test-cases/fetch_tests.sparql";

    private static String fixTestFilePath(String input, String pathDelta, String actualExt) {
        int pos = input.lastIndexOf(47);
        String path = input.substring(0, pos + 1);
        String filename = input.substring(pos + 1);
        return path + pathDelta + filename.replaceAll("\\.\\w+$", "." + actualExt);
    }

    public static Collection<TestCase> getTestSuite(String rdfaVersion, String docFormat) {
        String docExt = docFormat.replaceAll("[0-9]", "");
        String pathDelta = rdfaVersion + "/" + docFormat + "/";
        String queryStr = null;
        try {
            queryStr = IOUtils.toString((InputStream)sth.openStreamForResource(FETCH_RDFA_TESTS_SPARQL));
        }
        catch (IOException e) {
            return null;
        }
        queryStr = queryStr.replace("!rdfa_version", "\"" + rdfaVersion + "\"").replace("!host_lang", "\"" + docFormat + "\"");
        List testCases = sth.getTestCases(RDFA_TESTSUITE_MANIFEST_URI, queryStr, TestCase.class);
        for (TestCase testCase : testCases) {
            testCase.input = RdfaTestSuiteHelper.fixTestFilePath(testCase.input, pathDelta, docExt);
            testCase.result = RdfaTestSuiteHelper.fixTestFilePath(testCase.result, pathDelta, "sparql");
        }
        return testCases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runTestBundle(TestCase testCase, SaveToFileCallback callback, short rdfaVersion) {
        String resultFilePath = sth.getOutputPath(testCase.input, callback.getOutputFileExt());
        new File(resultFilePath).getParentFile().mkdirs();
        try {
            try {
                InputStreamReader input = new InputStreamReader(sth.openStreamForResource(testCase.input), "UTF-8");
                OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(resultFilePath), "UTF-8");
                try {
                    callback.run(input, testCase.input, output, rdfaVersion);
                }
                finally {
                    IOUtils.closeQuietly((Reader)input);
                    IOUtils.closeQuietly((Writer)output);
                }
            }
            catch (ParseException input) {
                // empty catch block
            }
            String queryStr = IOUtils.toString((InputStream)sth.openStreamForResource(testCase.result), (String)"UTF-8");
            boolean expectedResult = testCase.expectedResult == null || Boolean.parseBoolean(testCase.expectedResult);
            boolean actualResult = sth.askModel(resultFilePath, queryStr, testCase.input, expectedResult);
            Assert.assertEquals((boolean)actualResult, (boolean)expectedResult, (String)testCase.input);
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    public static final class TestCase {
        public String name;
        public String input;
        public String result;
        public String expectedResult;

        public String toString() {
            return this.input;
        }
    }

    public static interface SaveToFileCallback {
        public void run(Reader var1, String var2, Writer var3, short var4) throws ParseException;

        public String getOutputFileExt();
    }
}

