package org.sentrysoftware.ipmi.core.api.sol;

/*-
 * ╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲
 * IPMI Java Client
 * ჻჻჻჻჻჻
 * Copyright 2023 Verax Systems, Sentry Software
 * ჻჻჻჻჻჻
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱
 */

import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;

import java.util.List;

/**
 * Interface for {@link CipherSuite} selection handler to choose among available {@link CipherSuite}s returned by the server.
 */
public interface CipherSuiteSelectionHandler {

    /**
     * Chooses one {@link CipherSuite} among list of available {@link CipherSuite}s, to be used during IPMI connection.
     *
     * @param availableCipherSuites
     *          {@link CipherSuite}s returned by the server as avaialble to use.
     * @return chosen cipher suite
     */
    CipherSuite choose(List<CipherSuite> availableCipherSuites);

}
