package org.sentrysoftware.ipmi.core.coding.commands.sdr.record;

/*-
 * ╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲
 * IPMI Java Client
 * ჻჻჻჻჻჻
 * Copyright 2023 Verax Systems, Sentry Software
 * ჻჻჻჻჻჻
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱╲╱
 */

public enum InstanceModifierType {
    Numeric(InstanceModifierType.NUMERIC),
    Alpha(InstanceModifierType.ALPHA),
    ;
    private static final int NUMERIC = 0;
    private static final int ALPHA = 1;

    private int code;

    InstanceModifierType(int code) {
        this.code = code;
    }
    public int getCode() {
        return code;
    }
    public static InstanceModifierType parseInt(int value) {
        switch(value) {
        case NUMERIC:
            return Numeric;
        case ALPHA:
            return Alpha;
        default:
            throw new IllegalArgumentException("Invalid value: " + value);
        }
    }
}
