/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.api.async;

import java.util.List;
import java.util.Set;
import org.sentrysoftware.ipmi.core.api.async.ConnectionHandle;
import org.sentrysoftware.ipmi.core.api.async.InboundMessageListener;
import org.sentrysoftware.ipmi.core.api.sol.SolEventListener;
import org.sentrysoftware.ipmi.core.api.sync.IpmiConnector;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolAckState;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolInboundMessage;
import org.sentrysoftware.ipmi.core.coding.payload.sol.SolStatus;
import org.sentrysoftware.ipmi.core.coding.sol.SolCoder;
import org.sentrysoftware.ipmi.core.common.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InboundSolMessageListener
implements InboundMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(InboundSolMessageListener.class);
    static final int BUFFER_CAPACITY = 2048;
    private final ByteBuffer buffer = new ByteBuffer(2048);
    private final IpmiConnector connector;
    private final ConnectionHandle connectionHandle;
    private final List<SolEventListener> eventListeners;
    private SolInboundMessage waitingMessage;

    public InboundSolMessageListener(IpmiConnector connector, ConnectionHandle connectionHandle, List<SolEventListener> eventListeners) {
        this.connector = connector;
        this.connectionHandle = connectionHandle;
        this.eventListeners = eventListeners;
    }

    @Override
    public boolean isPayloadSupported(IpmiPayload payload) {
        return payload instanceof SolInboundMessage;
    }

    @Override
    public void notify(IpmiPayload payload) {
        if (this.isPayloadSupported(payload)) {
            Set<SolStatus> statuses;
            SolInboundMessage solPayload = (SolInboundMessage)payload;
            byte[] characterData = solPayload.getData();
            if (this.messageHasCharacterData(characterData)) {
                this.processCharacterData(solPayload, characterData);
            }
            if (this.messageHasStatuses(statuses = solPayload.getStatusField().getStatuses())) {
                this.processStatuses(statuses);
            }
        }
    }

    private void processCharacterData(SolInboundMessage solPayload, byte[] characterData) {
        if (this.noSpaceForDataInBuffer(characterData)) {
            this.sendNack(solPayload);
        } else {
            this.buffer.write(characterData);
            this.sendAck(solPayload, characterData);
        }
    }

    private void processStatuses(Set<SolStatus> statuses) {
        for (SolEventListener listener : this.eventListeners) {
            listener.processRequestEvent(statuses);
        }
    }

    private boolean noSpaceForDataInBuffer(byte[] characterData) {
        return characterData.length > this.buffer.remainingSpace();
    }

    private boolean messageHasCharacterData(byte[] characterData) {
        return characterData != null && characterData.length > 0;
    }

    private boolean messageHasStatuses(Set<SolStatus> statuses) {
        return statuses != null && !statuses.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNack(SolInboundMessage solPayload) {
        if (solPayload.getSequenceNumber() != 0) {
            try {
                SolCoder solNack = new SolCoder(solPayload.getSequenceNumber(), 0, SolAckState.NACK, this.connectionHandle.getCipherSuite());
                this.connector.sendOneWayMessage(this.connectionHandle, solNack);
                ByteBuffer byteBuffer = this.buffer;
                synchronized (byteBuffer) {
                    this.waitingMessage = solPayload;
                }
            }
            catch (Exception e) {
                logger.error("Could not send NACK for packet " + solPayload.getSequenceNumber(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendAck(SolInboundMessage solPayload, byte[] characterData) {
        if (solPayload.getSequenceNumber() != 0) {
            try {
                SolCoder solAck = new SolCoder(solPayload.getSequenceNumber(), (byte)characterData.length, SolAckState.ACK, this.connectionHandle.getCipherSuite());
                this.connector.sendOneWayMessage(this.connectionHandle, solAck);
                ByteBuffer byteBuffer = this.buffer;
                synchronized (byteBuffer) {
                    this.waitingMessage = null;
                }
            }
            catch (Exception e) {
                logger.error("Could not send ACK for packet " + solPayload.getSequenceNumber(), (Throwable)e);
            }
        }
    }

    private void sendResumeAck(SolInboundMessage solPayload) {
        try {
            SolCoder solResumeAck = new SolCoder(solPayload.getSequenceNumber(), 0, SolAckState.ACK, this.connectionHandle.getCipherSuite());
            this.connector.sendOneWayMessage(this.connectionHandle, solResumeAck);
        }
        catch (Exception e) {
            logger.error("Could not send Resume ACK for packet " + solPayload.getSequenceNumber(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int numberOfBytes) {
        byte[] result = this.buffer.read(numberOfBytes);
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            if (this.waitingMessage != null && this.waitingMessage.getData().length <= this.buffer.remainingSpace()) {
                this.sendResumeAck(this.waitingMessage);
            }
        }
        return result;
    }

    public int getAvailableBytesCount() {
        return this.buffer.size();
    }
}

