/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.api.sync;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Random;
import org.sentrysoftware.ipmi.core.api.async.ConnectionHandle;
import org.sentrysoftware.ipmi.core.api.async.InboundMessageListener;
import org.sentrysoftware.ipmi.core.api.async.IpmiAsyncConnector;
import org.sentrysoftware.ipmi.core.api.sync.MessageListener;
import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.PropertiesManager;
import org.sentrysoftware.ipmi.core.connection.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpmiConnector {
    private static Logger logger = LoggerFactory.getLogger(IpmiConnector.class);
    private IpmiAsyncConnector asyncConnector;
    private int retries;
    private int idleTime;
    private Random random = new Random(System.currentTimeMillis());

    public IpmiConnector(int port) throws IOException {
        this.asyncConnector = new IpmiAsyncConnector(port);
        this.loadProperties();
    }

    public IpmiConnector(int port, InetAddress address) throws IOException {
        this.asyncConnector = new IpmiAsyncConnector(port, address);
        this.loadProperties();
    }

    private void loadProperties() {
        PropertiesManager manager = PropertiesManager.getInstance();
        this.retries = Integer.parseInt(manager.getProperty("retries"));
        this.idleTime = Integer.parseInt(manager.getProperty("idleTime"));
    }

    public ConnectionHandle createConnection(InetAddress address) throws IOException {
        return this.createConnection(address, 623);
    }

    public ConnectionHandle createConnection(InetAddress address, int port) throws IOException {
        return this.asyncConnector.createConnection(address, port);
    }

    public ConnectionHandle createConnection(InetAddress address, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel) throws IOException {
        return this.createConnection(address, 623, cipherSuite, privilegeLevel);
    }

    public ConnectionHandle createConnection(InetAddress address, int port, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel) throws IOException {
        return this.asyncConnector.createConnection(address, port, cipherSuite, privilegeLevel);
    }

    public List<CipherSuite> getAvailableCipherSuites(ConnectionHandle connectionHandle) throws Exception {
        return this.asyncConnector.getAvailableCipherSuites(connectionHandle);
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(ConnectionHandle connectionHandle, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws Exception {
        return this.asyncConnector.getChannelAuthenticationCapabilities(connectionHandle, cipherSuite, requestedPrivilegeLevel);
    }

    public Session openSession(ConnectionHandle connectionHandle, String username, String password, byte[] bmcKey) throws Exception {
        return this.asyncConnector.openSession(connectionHandle, username, password, bmcKey);
    }

    public Session getExistingSessionForCriteria(InetAddress remoteAddress, int remotePort, String user) {
        return this.asyncConnector.getExistingSessionForCriteria(remoteAddress, remotePort, user);
    }

    public void closeSession(ConnectionHandle connectionHandle) throws Exception {
        this.asyncConnector.closeSession(connectionHandle);
    }

    public ResponseData sendMessage(ConnectionHandle connectionHandle, PayloadCoder request) throws Exception {
        return this.sendMessage(connectionHandle, request, true);
    }

    public void sendOneWayMessage(ConnectionHandle connectionHandle, PayloadCoder request) throws Exception {
        this.sendMessage(connectionHandle, request, false);
    }

    public ResponseData retryMessage(ConnectionHandle connectionHandle, byte tag, PayloadType messagePayloadType) throws Exception {
        MessageListener listener = new MessageListener(connectionHandle);
        this.asyncConnector.registerListener(listener);
        int retryResult = this.asyncConnector.retry(connectionHandle, tag, messagePayloadType);
        ResponseData data = retryResult != -1 ? listener.waitForAnswer(tag) : null;
        this.asyncConnector.unregisterListener(listener);
        return data;
    }

    private ResponseData sendMessage(ConnectionHandle connectionHandle, PayloadCoder request, boolean waitForResponse) throws Exception {
        MessageListener listener = new MessageListener(connectionHandle);
        if (waitForResponse) {
            this.asyncConnector.registerListener(listener);
        }
        ResponseData data = this.sendThroughAsyncConnector(request, connectionHandle, listener, waitForResponse);
        if (waitForResponse) {
            this.asyncConnector.unregisterListener(listener);
        }
        return data;
    }

    private ResponseData sendThroughAsyncConnector(PayloadCoder request, ConnectionHandle connectionHandle, MessageListener listener, boolean waitForResponse) throws Exception {
        ResponseData responseData = null;
        int tries = 0;
        int tag = -1;
        boolean messageSent = false;
        while (!messageSent) {
            try {
                ++tries;
                if (tag >= 0) {
                    tag = this.asyncConnector.retry(connectionHandle, tag, request.getSupportedPayloadType());
                }
                if (tag < 0) {
                    tag = this.asyncConnector.sendMessage(connectionHandle, request, !waitForResponse);
                }
                logger.debug("Sending message with tag {}, try {}", (Object)tag, (Object)tries);
                if (waitForResponse) {
                    responseData = listener.waitForAnswer(tag);
                }
                messageSent = true;
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (IPMIException e) {
                this.handleErrorResponse(tries, e);
            }
            catch (Exception e) {
                this.handleRetriesWhenException(tries, e);
            }
        }
        return responseData;
    }

    private void handleRetriesWhenException(int tries, Exception e) throws Exception {
        if (tries > this.retries) {
            throw e;
        }
        long sleepTime = this.random.nextLong() % (long)(this.idleTime / 2) + (long)(this.idleTime / 2);
        Thread.sleep(sleepTime);
        logger.warn("Receiving message failed, retrying", (Throwable)e);
    }

    private void handleErrorResponse(int tries, IPMIException e) throws Exception {
        if (e.getCompletionCode() != CompletionCode.InitializationInProgress && e.getCompletionCode() != CompletionCode.InsufficientResources && e.getCompletionCode() != CompletionCode.NodeBusy && e.getCompletionCode() != CompletionCode.Timeout) {
            throw e;
        }
        this.handleRetriesWhenException(tries, e);
    }

    public void registerIncomingMessageListener(InboundMessageListener listener) {
        this.asyncConnector.registerIncomingPayloadListener(listener);
    }

    public void closeConnection(ConnectionHandle handle) {
        this.asyncConnector.closeConnection(handle);
    }

    public void tearDown() {
        this.asyncConnector.tearDown();
    }

    public void setTimeout(ConnectionHandle handle, int timeout) {
        this.asyncConnector.setTimeout(handle, timeout);
    }

    public int getRetries() {
        return this.retries;
    }
}

