/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.api.sync;

import java.util.ArrayList;
import java.util.List;
import org.sentrysoftware.ipmi.core.api.async.ConnectionHandle;
import org.sentrysoftware.ipmi.core.api.async.IpmiResponseListener;
import org.sentrysoftware.ipmi.core.api.async.messages.IpmiError;
import org.sentrysoftware.ipmi.core.api.async.messages.IpmiResponse;
import org.sentrysoftware.ipmi.core.api.async.messages.IpmiResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;

public class MessageListener
implements IpmiResponseListener {
    private ConnectionHandle handle;
    private int tag;
    private IpmiResponse response;
    private List<IpmiResponse> quickMessages = new ArrayList<IpmiResponse>();

    public MessageListener(ConnectionHandle handle) {
        this.handle = handle;
        this.tag = -1;
        this.response = null;
    }

    public ResponseData waitForAnswer(int tag) throws Exception {
        if (tag < 0 || tag > 63) {
            throw new IllegalArgumentException("Corrupted message tag");
        }
        this.tag = tag;
        for (IpmiResponse quickResponse : this.quickMessages) {
            this.notify(quickResponse);
        }
        while (this.response == null) {
            Thread.sleep(1L);
        }
        if (this.response instanceof IpmiResponseData) {
            this.tag = -1;
            this.quickMessages.clear();
            return ((IpmiResponseData)this.response).getResponseData();
        }
        throw ((IpmiError)this.response).getException();
    }

    @Override
    public synchronized void notify(IpmiResponse response) {
        if (response.getHandle().getHandle() == this.handle.getHandle()) {
            if (this.tag == -1) {
                this.quickMessages.add(response);
            } else if (response.getTag() == this.tag) {
                this.response = response;
            }
        }
    }
}

