/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiCommandCoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.GetSdrRepositoryInfoResponseData;
import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.IpmiPayload;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IPMIException;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanRequest;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanResponse;
import org.sentrysoftware.ipmi.core.coding.payload.lan.NetworkFunction;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GetSdrRepositoryInfo
extends IpmiCommandCoder {
    public GetSdrRepositoryInfo(IpmiVersion version, CipherSuite cipherSuite, AuthenticationType authenticationType) {
        super(version, cipherSuite, authenticationType);
    }

    @Override
    public byte getCommandCode() {
        return 32;
    }

    @Override
    public NetworkFunction getNetworkFunction() {
        return NetworkFunction.StorageRequest;
    }

    @Override
    protected IpmiPayload preparePayload(int sequenceNumber) throws NoSuchAlgorithmException, InvalidKeyException {
        return new IpmiLanRequest(this.getNetworkFunction(), this.getCommandCode(), null, TypeConverter.intToByte(sequenceNumber));
    }

    @Override
    public ResponseData getResponseData(IpmiMessage message) throws IPMIException, NoSuchAlgorithmException, InvalidKeyException {
        if (!this.isCommandResponse(message)) {
            throw new IllegalArgumentException("This is not a response for Get SDR Repository Info command");
        }
        if (!(message.getPayload() instanceof IpmiLanResponse)) {
            throw new IllegalArgumentException("Invalid response payload");
        }
        if (((IpmiLanResponse)message.getPayload()).getCompletionCode() != CompletionCode.Ok) {
            throw new IPMIException(((IpmiLanResponse)message.getPayload()).getCompletionCode());
        }
        byte[] raw = message.getPayload().getIpmiCommandData();
        if (raw == null || raw.length != 14) {
            throw new IllegalArgumentException("Invalid response payload length");
        }
        GetSdrRepositoryInfoResponseData responseData = new GetSdrRepositoryInfoResponseData();
        responseData.setSdrVersion(TypeConverter.littleEndianBcdByteToInt(raw[0]));
        byte[] buffer = new byte[]{raw[1], raw[2], 0, 0};
        responseData.setRecordCount(TypeConverter.littleEndianByteArrayToInt(buffer));
        System.arraycopy(raw, 5, buffer, 0, 4);
        responseData.setAddTimestamp(TypeConverter.littleEndianByteArrayToInt(buffer));
        System.arraycopy(raw, 9, buffer, 0, 4);
        responseData.setDelTimestamp(TypeConverter.littleEndianByteArrayToInt(buffer));
        responseData.setReserveSupported((TypeConverter.byteToInt(raw[13]) & 2) != 0);
        return responseData;
    }
}

