/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr.record;

import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.AddressType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.EntityId;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.InstanceModifierType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorDirection;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorType;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class EventOnlyRecord
extends SensorRecord {
    private byte sensorOwnerId;
    private AddressType addressType;
    private byte channelNumber;
    private byte sensorOwnerLun;
    private byte sensorNumber;
    private EntityId entityId;
    private boolean entityPhysical;
    private byte entityInstanceNumber;
    private SensorType sensorType;
    private int eventReadingType;
    private SensorDirection sensorDirection;
    private String name;
    private InstanceModifierType idInstanceModifierType;
    private int shareCount;
    private boolean entityInstanceIncrements;
    private int idInstanceModifierOffset;

    @Override
    protected void populateTypeSpecficValues(byte[] recordData, SensorRecord record) {
        this.setSensorOwnerId(TypeConverter.intToByte((TypeConverter.byteToInt(recordData[5]) & 0xFE) >> 1));
        this.setAddressType(AddressType.parseInt(TypeConverter.byteToInt(recordData[5]) & 1));
        this.setChannelNumber(TypeConverter.intToByte((TypeConverter.byteToInt(recordData[6]) & 0xF0) >> 4));
        this.setSensorOwnerLun(TypeConverter.intToByte(TypeConverter.byteToInt(recordData[6]) & 3));
        this.setSensorNumber(recordData[7]);
        this.setEntityId(EntityId.parseInt(TypeConverter.byteToInt(recordData[8])));
        this.setEntityPhysical((TypeConverter.byteToInt(recordData[9]) & 0x80) == 0);
        this.setEntityInstanceNumber(TypeConverter.intToByte(TypeConverter.byteToInt(recordData[9]) & 0x7F));
        this.setSensorType(SensorType.parseInt(TypeConverter.byteToInt(recordData[10])));
        this.setEventReadingType(TypeConverter.byteToInt(recordData[11]));
        this.setSensorDirection(SensorDirection.parseInt((TypeConverter.byteToInt(recordData[12]) & 0xC0) >> 6));
        this.setIdInstanceModifierType(InstanceModifierType.parseInt((TypeConverter.byteToInt(recordData[12]) & 0x30) >> 4));
        this.setShareCount(TypeConverter.byteToInt(recordData[12]) & 0xF);
        this.setEntityInstanceIncrements((TypeConverter.byteToInt(recordData[13]) & 0x80) != 0);
        this.setIdInstanceModifierOffset(TypeConverter.byteToInt(recordData[13]) & 0x7F);
        byte[] nameData = new byte[recordData.length - 17];
        System.arraycopy(recordData, 17, nameData, 0, nameData.length);
        this.setName(this.decodeName(recordData[16], nameData));
    }

    public byte getSensorOwnerId() {
        return this.sensorOwnerId;
    }

    public void setSensorOwnerId(byte sensorOwnerId) {
        this.sensorOwnerId = sensorOwnerId;
    }

    public AddressType getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressType addressType) {
        this.addressType = addressType;
    }

    public byte getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(byte channelNumber) {
        this.channelNumber = channelNumber;
    }

    public byte getSensorOwnerLun() {
        return this.sensorOwnerLun;
    }

    public void setSensorOwnerLun(byte sensorOwnerLun) {
        this.sensorOwnerLun = sensorOwnerLun;
    }

    public byte getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(byte sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public boolean isEntityPhysical() {
        return this.entityPhysical;
    }

    public void setEntityPhysical(boolean entityPhysical) {
        this.entityPhysical = entityPhysical;
    }

    public byte getEntityInstanceNumber() {
        return this.entityInstanceNumber;
    }

    public void setEntityInstanceNumber(byte entityInstanceNumber) {
        this.entityInstanceNumber = entityInstanceNumber;
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
    }

    public int getEventReadingType() {
        return this.eventReadingType;
    }

    public void setEventReadingType(int eventReadingType) {
        this.eventReadingType = eventReadingType;
    }

    public SensorDirection getSensorDirection() {
        return this.sensorDirection;
    }

    public void setSensorDirection(SensorDirection sensorDirection) {
        this.sensorDirection = sensorDirection;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public InstanceModifierType getIdInstanceModifierType() {
        return this.idInstanceModifierType;
    }

    public void setIdInstanceModifierType(InstanceModifierType idInstanceModifierType) {
        this.idInstanceModifierType = idInstanceModifierType;
    }

    public int getShareCount() {
        return this.shareCount;
    }

    public void setShareCount(int shareCount) {
        this.shareCount = shareCount;
    }

    public boolean isEntityInstanceIncrements() {
        return this.entityInstanceIncrements;
    }

    public void setEntityInstanceIncrements(boolean entityInstanceIncrements) {
        this.entityInstanceIncrements = entityInstanceIncrements;
    }

    public int getIdInstanceModifierOffset() {
        return this.idInstanceModifierOffset;
    }

    public void setIdInstanceModifierOffset(int idInstanceModifierOffset) {
        this.idInstanceModifierOffset = idInstanceModifierOffset;
    }
}

