/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr.record;

import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.AddressType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.EntityId;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.ModifierUnitUsage;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.RateUnit;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorDirection;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorUnit;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class FullSensorRecord
extends SensorRecord {
    private byte sensorOwnerId;
    private AddressType addressType;
    private byte channelNumber;
    private byte sensorOwnerLun;
    private byte sensorNumber;
    private EntityId entityId;
    private boolean entityPhysical;
    private byte entityInstanceNumber;
    private boolean hysteresisReadable;
    private boolean thresholdsReadable;
    private SensorType sensorType;
    private int eventReadingType;
    private RateUnit rateUnit;
    private ModifierUnitUsage modifierUnitUsage;
    private SensorUnit sensorBaseUnit;
    private SensorUnit sensorModifierUnit;
    private double m;
    private double tolerance;
    private double b;
    private double accuracy;
    private int rExp;
    private SensorDirection sensorDirection;
    private double nominalReading;
    private double normalMaximum;
    private double normalMinimum;
    private double sensorMaximumReading;
    private double sensorMinmumReading;
    private double upperNonRecoverableThreshold;
    private double lowerNonRecoverableThreshold;
    private double upperCriticalThreshold;
    private double lowerCriticalThreshold;
    private double upperNonCriticalThreshold;
    private double lowerNonCriticalThreshold;
    private String name;
    private byte sensorUnits1;
    private int linearization;

    @Override
    protected void populateTypeSpecficValues(byte[] recordData, SensorRecord record) {
        this.setSensorOwnerId(TypeConverter.intToByte((TypeConverter.byteToInt(recordData[5]) & 0xFE) >> 1));
        this.setAddressType(AddressType.parseInt(TypeConverter.byteToInt(recordData[5]) & 1));
        this.setChannelNumber(TypeConverter.intToByte((TypeConverter.byteToInt(recordData[6]) & 0xF0) >> 4));
        this.setSensorOwnerLun(TypeConverter.intToByte(TypeConverter.byteToInt(recordData[6]) & 3));
        this.setSensorNumber(recordData[7]);
        this.setEntityId(EntityId.parseInt(TypeConverter.byteToInt(recordData[8])));
        this.setEntityPhysical((TypeConverter.byteToInt(recordData[9]) & 0x80) == 0);
        this.setEntityInstanceNumber(TypeConverter.intToByte(TypeConverter.byteToInt(recordData[9]) & 0x7F));
        int hysteresis = (TypeConverter.byteToInt(recordData[11]) & 0x30) >> 4;
        this.setHysteresisReadable(this.isFieldReadable(hysteresis));
        int thresholds = (TypeConverter.byteToInt(recordData[11]) & 0xC) >> 2;
        this.setThresholdsReadable(this.isFieldReadable(thresholds));
        this.setSensorType(SensorType.parseInt(TypeConverter.byteToInt(recordData[12])));
        this.setEventReadingType(TypeConverter.byteToInt(recordData[13]));
        this.setRateUnit(RateUnit.parseInt((TypeConverter.byteToInt(recordData[20]) & 0x38) >> 3));
        this.setModifierUnitUsage(ModifierUnitUsage.parseInt((TypeConverter.byteToInt(recordData[20]) & 6) >> 1));
        this.setSensorBaseUnit(SensorUnit.parseInt(TypeConverter.byteToInt(recordData[21])));
        this.setSensorModifierUnit(SensorUnit.parseInt(TypeConverter.byteToInt(recordData[22])));
        int calcM = TypeConverter.byteToInt(recordData[24]);
        this.setM(TypeConverter.decode2sComplement(calcM |= (TypeConverter.byteToInt(recordData[25]) & 0xC0) << 2, 9));
        this.sensorUnits1 = recordData[20];
        this.setTolerance(this.calcFormula((TypeConverter.byteToInt(recordData[25]) & 0x3F) / 2, 8, this.sensorUnits1));
        int calcB = TypeConverter.byteToInt(recordData[26]);
        this.setB(TypeConverter.decode2sComplement(calcB |= (TypeConverter.byteToInt(recordData[27]) & 0xC0) << 2, 9));
        int calcAcc = TypeConverter.byteToInt(recordData[27]) & 0x3F;
        int exp = TypeConverter.byteToInt(recordData[28]) & 3;
        this.setAccuracy((double)(calcAcc |= (TypeConverter.byteToInt(recordData[28]) & 0xF0) << 2) / 10000.0 * Math.pow(10.0, exp));
        this.setSensorDirection(SensorDirection.parseInt(TypeConverter.byteToInt(recordData[28]) & 3));
        this.setrExp(TypeConverter.decode2sComplement((TypeConverter.byteToInt(recordData[29]) & 0xF0) >> 4, 3));
        int bExp = TypeConverter.decode2sComplement(TypeConverter.byteToInt(recordData[29]) & 0xF, 3);
        this.setB(this.getB() * Math.pow(10.0, bExp));
        this.setNominalReading(this.calcFormula(TypeConverter.byteToInt(recordData[31])));
        this.setNormalMaximum(this.calcFormula(TypeConverter.byteToInt(recordData[32])));
        this.setNormalMinimum(this.calcFormula(TypeConverter.byteToInt(recordData[33])));
        this.setSensorMaximumReading(this.calcFormula(TypeConverter.byteToInt(recordData[34])));
        this.setSensorMinmumReading(this.calcFormula(TypeConverter.byteToInt(recordData[35])));
        if ((TypeConverter.byteToInt(recordData[10]) & 4) != 0) {
            if ((TypeConverter.byteToInt(recordData[18]) & 0x20) != 0) {
                this.setUpperNonRecoverableThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[36])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 0x10) != 0) {
                this.setUpperCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[37])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 8) != 0) {
                this.setUpperNonCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[38])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 4) != 0) {
                this.setLowerNonRecoverableThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[39])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 2) != 0) {
                this.setLowerCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[40])));
            }
            if ((TypeConverter.byteToInt(recordData[18]) & 1) != 0) {
                this.setLowerNonCriticalThreshold(this.calcFormula(TypeConverter.byteToInt(recordData[41])));
            }
        }
        byte[] nameData = new byte[recordData.length - 48];
        System.arraycopy(recordData, 48, nameData, 0, nameData.length);
        this.setName(this.decodeName(recordData[47], nameData));
        this.linearization = TypeConverter.byteToInt(recordData[23]) & 0x7F;
    }

    private boolean isFieldReadable(int field) {
        return field == 1 || field == 2;
    }

    public void setSensorOwnerId(byte sensorOwnerId) {
        this.sensorOwnerId = sensorOwnerId;
    }

    public byte getSensorOwnerId() {
        return this.sensorOwnerId;
    }

    public AddressType getAddressType() {
        return this.addressType;
    }

    public void setAddressType(AddressType addressType) {
        this.addressType = addressType;
    }

    public byte getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(byte channelNumber) {
        this.channelNumber = channelNumber;
    }

    public byte getSensorOwnerLun() {
        return this.sensorOwnerLun;
    }

    public void setSensorOwnerLun(byte sensorOwnerLun) {
        this.sensorOwnerLun = sensorOwnerLun;
    }

    public byte getSensorNumber() {
        return this.sensorNumber;
    }

    public void setSensorNumber(byte sensorNumber) {
        this.sensorNumber = sensorNumber;
    }

    public EntityId getEntityId() {
        return this.entityId;
    }

    public void setEntityId(EntityId entityId) {
        this.entityId = entityId;
    }

    public boolean isEntityPhysical() {
        return this.entityPhysical;
    }

    public void setEntityPhysical(boolean entityPhysical) {
        this.entityPhysical = entityPhysical;
    }

    public byte getEntityInstanceNumber() {
        return this.entityInstanceNumber;
    }

    public void setEntityInstanceNumber(byte entityInstanceNumber) {
        this.entityInstanceNumber = entityInstanceNumber;
    }

    public boolean isHysteresisReadable() {
        return this.hysteresisReadable;
    }

    public void setHysteresisReadable(boolean hysteresisReadable) {
        this.hysteresisReadable = hysteresisReadable;
    }

    public boolean isThresholdsReadable() {
        return this.thresholdsReadable;
    }

    public void setThresholdsReadable(boolean thresholdsReadable) {
        this.thresholdsReadable = thresholdsReadable;
    }

    public SensorType getSensorType() {
        return this.sensorType;
    }

    public void setSensorType(SensorType sensorType) {
        this.sensorType = sensorType;
    }

    public int getEventReadingType() {
        return this.eventReadingType;
    }

    public void setEventReadingType(int eventReadingType) {
        this.eventReadingType = eventReadingType;
    }

    public RateUnit getRateUnit() {
        return this.rateUnit;
    }

    public void setRateUnit(RateUnit rateUnit) {
        this.rateUnit = rateUnit;
    }

    public ModifierUnitUsage getModifierUnitUsage() {
        return this.modifierUnitUsage;
    }

    public void setModifierUnitUsage(ModifierUnitUsage modifierUnitUsage) {
        this.modifierUnitUsage = modifierUnitUsage;
    }

    public SensorUnit getSensorBaseUnit() {
        return this.sensorBaseUnit;
    }

    public void setSensorBaseUnit(SensorUnit sensorBaseUnit) {
        this.sensorBaseUnit = sensorBaseUnit;
    }

    public SensorUnit getSensorModifierUnit() {
        return this.sensorModifierUnit;
    }

    public void setSensorModifierUnit(SensorUnit sensorModifierUnit) {
        this.sensorModifierUnit = sensorModifierUnit;
    }

    private double getM() {
        return this.m;
    }

    private void setM(double m) {
        this.m = m;
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double mTolerance) {
        this.tolerance = mTolerance;
    }

    private double getB() {
        return this.b;
    }

    private void setB(double b) {
        this.b = b;
    }

    public double getAccuracy() {
        return this.accuracy;
    }

    public void setAccuracy(double bAccuracy) {
        this.accuracy = bAccuracy;
    }

    private void setrExp(int rExp) {
        this.rExp = rExp;
    }

    private int getrExp() {
        return this.rExp;
    }

    public SensorDirection getSensorDirection() {
        return this.sensorDirection;
    }

    public void setSensorDirection(SensorDirection sensorDirection) {
        this.sensorDirection = sensorDirection;
    }

    public double getNominalReading() {
        return this.nominalReading;
    }

    public void setNominalReading(double nominalReading) {
        this.nominalReading = nominalReading;
    }

    public double getNormalMaximum() {
        return this.normalMaximum;
    }

    public void setNormalMaximum(double normalMaximum) {
        this.normalMaximum = normalMaximum;
    }

    public double getNormalMinimum() {
        return this.normalMinimum;
    }

    public void setNormalMinimum(double normalMinimum) {
        this.normalMinimum = normalMinimum;
    }

    public double getSensorMaximumReading() {
        return this.sensorMaximumReading;
    }

    public void setSensorMaximumReading(double sensorMaximumReading) {
        this.sensorMaximumReading = sensorMaximumReading;
    }

    public double getSensorMinmumReading() {
        return this.sensorMinmumReading;
    }

    public void setSensorMinmumReading(double sensorMinmumReading) {
        this.sensorMinmumReading = sensorMinmumReading;
    }

    public double getUpperNonRecoverableThreshold() {
        return this.upperNonRecoverableThreshold;
    }

    public void setUpperNonRecoverableThreshold(double upperNonRecoverableThreshold) {
        this.upperNonRecoverableThreshold = upperNonRecoverableThreshold;
    }

    public double getLowerNonRecoverableThreshold() {
        return this.lowerNonRecoverableThreshold;
    }

    public void setLowerNonRecoverableThreshold(double lowerNonRecoverableThreshold) {
        this.lowerNonRecoverableThreshold = lowerNonRecoverableThreshold;
    }

    public double getUpperCriticalThreshold() {
        return this.upperCriticalThreshold;
    }

    public void setUpperCriticalThreshold(double upperCriticalThreshold) {
        this.upperCriticalThreshold = upperCriticalThreshold;
    }

    public double getLowerCriticalThreshold() {
        return this.lowerCriticalThreshold;
    }

    public void setLowerCriticalThreshold(double lowerCriticalThreshold) {
        this.lowerCriticalThreshold = lowerCriticalThreshold;
    }

    public double getUpperNonCriticalThreshold() {
        return this.upperNonCriticalThreshold;
    }

    public void setUpperNonCriticalThreshold(double upperNonCriticalThreshold) {
        this.upperNonCriticalThreshold = upperNonCriticalThreshold;
    }

    public double getLowerNonCriticalThreshold() {
        return this.lowerNonCriticalThreshold;
    }

    public void setLowerNonCriticalThreshold(double lowerNonCriticalThreshold) {
        this.lowerNonCriticalThreshold = lowerNonCriticalThreshold;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double calcFormula(int value) {
        return this.calcFormula(value, 8, this.sensorUnits1);
    }

    protected double calcFormula(int value, int length, byte sensorUnits1) {
        int dataFormat = (TypeConverter.byteToInt(sensorUnits1) & 0xC0) >> 6;
        int base = 0;
        switch (dataFormat) {
            case 0: {
                base = value;
                break;
            }
            case 1: {
                base = TypeConverter.decode1sComplement(value, length - 1);
                break;
            }
            case 2: {
                base = TypeConverter.decode2sComplement(value, length - 1);
                break;
            }
            case 3: {
                base = value;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data format in sensorUnits1");
            }
        }
        double result = (this.getM() * (double)base + this.getB()) * Math.pow(10.0, this.getrExp());
        switch (this.linearization) {
            case 0: {
                return result;
            }
            case 1: {
                return Math.log(result);
            }
            case 2: {
                return Math.log10(result);
            }
            case 3: {
                return Math.log(result) / Math.log(2.0);
            }
            case 5: {
                return Math.pow(10.0, result);
            }
            case 6: {
                return Math.pow(2.0, result);
            }
            case 7: {
                return 1.0 / result;
            }
            case 8: {
                return Math.pow(result, 2.0);
            }
            case 9: {
                return Math.pow(result, 3.0);
            }
            case 10: {
                return Math.pow(result, 0.5);
            }
            case 11: {
                return Math.pow(result, 0.33);
            }
        }
        throw new IllegalArgumentException("Unsupported linearization type");
    }

    public double getSensorResolution() {
        return Math.abs(this.getM() / 2.0 * Math.pow(10.0, this.getrExp()));
    }
}

