/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.commands.sdr.record;

import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.DeviceType;
import org.sentrysoftware.ipmi.core.coding.commands.sdr.record.SensorRecord;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class GenericDeviceLocatorRecord
extends SensorRecord {
    private int deviceAccessAddress;
    private int deviceSlaveAddress;
    private int channelNumber;
    private int accessLun;
    private int busId;
    private int addressSpan;
    private DeviceType deviceType;
    private int deviceTypeModifier;
    private int entityId;
    private int entityInstance;
    private String name;

    @Override
    protected void populateTypeSpecficValues(byte[] recordData, SensorRecord record) {
        this.setDeviceAccessAddress((TypeConverter.byteToInt(recordData[5]) & 0xFE) >> 1);
        this.setDeviceSlaveAddress((TypeConverter.byteToInt(recordData[6]) & 0xFE) >> 1);
        this.setChannelNumber((TypeConverter.byteToInt(recordData[6]) & 1) << 3 | (TypeConverter.byteToInt(recordData[7]) & 0xE0) >> 5);
        this.setAccessLun((TypeConverter.byteToInt(recordData[7]) & 0x18) >> 3);
        this.setBusId(TypeConverter.byteToInt(recordData[7]) & 3);
        this.setAddressSpan(TypeConverter.byteToInt(recordData[8]) & 3);
        this.setDeviceType(DeviceType.parseInt(TypeConverter.byteToInt(recordData[10])));
        this.setDeviceTypeModifier(TypeConverter.byteToInt(recordData[11]));
        this.setEntityId(TypeConverter.byteToInt(recordData[12]));
        this.setEntityInstance(TypeConverter.byteToInt(recordData[13]));
        byte[] nameData = new byte[recordData.length - 17];
        System.arraycopy(recordData, 17, nameData, 0, nameData.length);
        this.setName(this.decodeName(recordData[16], nameData));
    }

    public int getDeviceAccessAddress() {
        return this.deviceAccessAddress;
    }

    public void setDeviceAccessAddress(int deviceAccessAddress) {
        this.deviceAccessAddress = deviceAccessAddress;
    }

    public int getDeviceSlaveAddress() {
        return this.deviceSlaveAddress;
    }

    public void setDeviceSlaveAddress(int deviceSlaveAddress) {
        this.deviceSlaveAddress = deviceSlaveAddress;
    }

    public int getChannelNumber() {
        return this.channelNumber;
    }

    public void setChannelNumber(int channelNumber) {
        this.channelNumber = channelNumber;
    }

    public int getAccessLun() {
        return this.accessLun;
    }

    public void setAccessLun(int accessLun) {
        this.accessLun = accessLun;
    }

    public int getBusId() {
        return this.busId;
    }

    public void setBusId(int busId) {
        this.busId = busId;
    }

    public int getAddressSpan() {
        return this.addressSpan;
    }

    public void setAddressSpan(int addressSpan) {
        this.addressSpan = addressSpan;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    public int getDeviceTypeModifier() {
        return this.deviceTypeModifier;
    }

    public void setDeviceTypeModifier(int deviceTypeModifier) {
        this.deviceTypeModifier = deviceTypeModifier;
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public int getEntityInstance() {
        return this.entityInstance;
    }

    public void setEntityInstance(int entityInstance) {
        this.entityInstance = entityInstance;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

