/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.payload;

import java.security.InvalidKeyException;
import org.sentrysoftware.ipmi.core.coding.security.ConfidentialityAlgorithm;

public abstract class IpmiPayload {
    private byte[] data;
    private byte[] encryptedPayload;

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getEncryptedPayload() {
        return this.encryptedPayload;
    }

    public abstract byte[] getPayloadData();

    public abstract int getPayloadLength();

    public abstract byte[] getIpmiCommandData();

    public void encryptPayload(ConfidentialityAlgorithm confidentialityAlgorithm) throws InvalidKeyException {
        this.encryptedPayload = confidentialityAlgorithm.encrypt(this.getPayloadData());
    }
}

