/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.payload.lan;

import org.sentrysoftware.ipmi.core.coding.payload.CompletionCode;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanMessage;
import org.sentrysoftware.ipmi.core.common.TypeConverter;

public class IpmiLanResponse
extends IpmiLanMessage {
    private CompletionCode completionCode;

    public void setCompletionCode(byte completionCode) {
        this.completionCode = CompletionCode.parseInt(TypeConverter.byteToInt(completionCode));
    }

    public CompletionCode getCompletionCode() {
        return this.completionCode;
    }

    public IpmiLanResponse(byte[] rawData) {
        this.setRequesterAddress(rawData[0]);
        this.networkFunction = TypeConverter.intToByte((TypeConverter.byteToInt(rawData[1]) & 0xFC) >> 2);
        this.setRequesterLogicalUnitNumber(TypeConverter.intToByte(TypeConverter.byteToInt(rawData[1]) & 3));
        if (rawData[2] != this.getChecksum1(rawData)) {
            throw new IllegalArgumentException("Checksum 1 failed");
        }
        this.setResponderAddress(rawData[3]);
        this.setSequenceNumber(TypeConverter.intToByte((TypeConverter.byteToInt(rawData[4]) & 0xFC) >> 2));
        this.setResponderLogicalUnitNumber(TypeConverter.intToByte(TypeConverter.byteToInt(rawData[4]) & 3));
        this.setCommand(rawData[5]);
        this.setCompletionCode(rawData[6]);
        if (rawData.length > 8) {
            byte[] data = new byte[rawData.length - 8];
            System.arraycopy(rawData, 7, data, 0, rawData.length - 8);
            this.setData(data);
        }
        if (rawData[rawData.length - 1] != this.getChecksum2(rawData)) {
            throw new IllegalArgumentException("Checksum 2 failed");
        }
    }

    @Override
    public int getPayloadLength() {
        int length = 8;
        if (this.getData() != null) {
            length += this.getData().length;
        }
        return length;
    }

    @Override
    @Deprecated
    public byte[] getPayloadData() {
        return null;
    }
}

