/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.coding.security;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.sentrysoftware.ipmi.core.coding.security.IntegrityAlgorithm;

public class IntegrityHmacSha1_96
extends IntegrityAlgorithm {
    public static final String ALGORITHM_NAME = "HmacSHA1";
    private Mac mac = Mac.getInstance("HmacSHA1");
    private static final byte[] CONST1 = new byte[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};

    @Override
    public void initialize(byte[] sik) throws InvalidKeyException {
        super.initialize(sik);
        SecretKeySpec k1 = new SecretKeySpec(sik, ALGORITHM_NAME);
        this.mac.init(k1);
        k1 = new SecretKeySpec(this.mac.doFinal(CONST1), ALGORITHM_NAME);
        this.mac.init(k1);
    }

    @Override
    public byte getCode() {
        return 1;
    }

    @Override
    public byte[] generateAuthCode(byte[] base) {
        if (this.sik == null) {
            throw new NullPointerException("Algorithm not initialized.");
        }
        byte[] result = new byte[12];
        byte[] updatedBase = base[base.length - 2] == 0 ? this.injectIntegrityPad(base, 12) : base;
        System.arraycopy(this.mac.doFinal(updatedBase), 0, result, 0, 12);
        return result;
    }
}

