/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.common;

public class MessageComposer {
    private final byte[] message;
    private int pointer = 0;

    public static MessageComposer get(int messageSize) {
        return new MessageComposer(messageSize);
    }

    private MessageComposer(int messageSize) {
        if (messageSize < 0) {
            throw new IllegalArgumentException("Message size cannot be negative");
        }
        this.message = new byte[messageSize];
    }

    public MessageComposer appendField(byte fieldData) {
        this.message[this.pointer++] = fieldData;
        return this;
    }

    public MessageComposer appendField(byte[] fieldData) {
        System.arraycopy(fieldData, 0, this.message, this.pointer, fieldData.length);
        this.pointer += fieldData.length;
        return this;
    }

    public byte[] getMessage() {
        return this.message;
    }
}

