/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.connection;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilitiesResponseData;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.PropertiesManager;
import org.sentrysoftware.ipmi.core.connection.Connection;
import org.sentrysoftware.ipmi.core.connection.ConnectionListener;
import org.sentrysoftware.ipmi.core.transport.Messenger;
import org.sentrysoftware.ipmi.core.transport.UdpMessenger;

public class ConnectionManager {
    private Messenger messenger;
    private List<Connection> connections;
    private static final AtomicInteger sessionlessTag = new AtomicInteger(0);
    private static List<Integer> reservedTags = new ArrayList<Integer>();
    private static int pingPeriod = -1;

    public ConnectionManager(int port) throws IOException {
        this.messenger = new UdpMessenger(port);
        this.initialize();
    }

    public ConnectionManager(int port, InetAddress address) throws IOException {
        this.messenger = new UdpMessenger(port, address);
        this.initialize();
    }

    public ConnectionManager(Messenger messenger) {
        this.messenger = messenger;
        this.initialize();
    }

    private void initialize() {
        this.connections = new ArrayList<Connection>();
        reservedTags = new ArrayList<Integer>();
        if (pingPeriod == -1) {
            pingPeriod = Integer.parseInt(PropertiesManager.getInstance().getProperty("pingPeriod"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                if (connection == null || !connection.isActive()) continue;
                connection.disconnect();
            }
        }
        this.messenger.closeConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int generateSessionlessTag() {
        AtomicInteger atomicInteger = sessionlessTag;
        synchronized (atomicInteger) {
            List<Integer> list;
            boolean wait = true;
            while (wait) {
                sessionlessTag.incrementAndGet();
                sessionlessTag.set(sessionlessTag.get() % 60);
                list = reservedTags;
                synchronized (list) {
                    if (!reservedTags.contains(sessionlessTag.get())) {
                        wait = false;
                    }
                }
                if (!wait) continue;
                try {
                    sessionlessTag.wait(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            list = reservedTags;
            synchronized (list) {
                reservedTags.add(sessionlessTag.get());
            }
            return sessionlessTag.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void freeTag(int tag) {
        List<Integer> list = reservedTags;
        synchronized (list) {
            reservedTags.remove((Object)tag);
        }
    }

    public Connection getConnection(int index) {
        return this.connections.get(index);
    }

    public void closeConnection(int index) {
        this.connections.get(index).disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(InetAddress address, int port) {
        List<Connection> list = this.connections;
        synchronized (list) {
            for (Connection connection : this.connections) {
                if (connection == null || !connection.isActive() || connection.getRemoteMachineAddress() != address || connection.getRemoteMachinePort() != port) continue;
                return connection;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createConnection(InetAddress address, int port, int pingPeriod, boolean skipCiphers) throws IOException {
        Connection connection = new Connection(this.messenger, 0);
        connection.connect(address, port, pingPeriod, skipCiphers);
        List<Connection> list = this.connections;
        synchronized (list) {
            this.connections.add(connection);
            return this.connections.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createConnection(InetAddress address, int port, int pingPeriod) throws IOException {
        Connection connection = new Connection(this.messenger, 0);
        connection.connect(address, port, pingPeriod);
        List<Connection> list = this.connections;
        synchronized (list) {
            this.connections.add(connection);
            return this.connections.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createConnection(InetAddress address, int port) throws IOException {
        List<Connection> list = this.connections;
        synchronized (list) {
            Connection connection = new Connection(this.messenger, this.connections.size());
            connection.connect(address, port, pingPeriod);
            this.connections.add(connection);
            return this.connections.size() - 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createConnection(InetAddress address, int port, boolean skipCiphers) throws IOException {
        List<Connection> list = this.connections;
        synchronized (list) {
            Connection connection = new Connection(this.messenger, this.connections.size());
            connection.connect(address, port, pingPeriod, skipCiphers);
            this.connections.add(connection);
            return this.connections.size() - 1;
        }
    }

    public List<CipherSuite> getAvailableCipherSuites(int connection) throws Exception {
        List<CipherSuite> suites;
        int tag = ConnectionManager.generateSessionlessTag();
        try {
            suites = this.connections.get(connection).getAvailableCipherSuites(tag);
        }
        catch (Exception e) {
            ConnectionManager.freeTag(tag);
            throw e;
        }
        ConnectionManager.freeTag(tag);
        return suites;
    }

    public GetChannelAuthenticationCapabilitiesResponseData getChannelAuthenticationCapabilities(int connection, CipherSuite cipherSuite, PrivilegeLevel requestedPrivilegeLevel) throws Exception {
        GetChannelAuthenticationCapabilitiesResponseData responseData;
        int tag = ConnectionManager.generateSessionlessTag();
        try {
            responseData = this.connections.get(connection).getChannelAuthenticationCapabilities(tag, cipherSuite, requestedPrivilegeLevel);
        }
        catch (Exception e) {
            ConnectionManager.freeTag(tag);
            throw e;
        }
        ConnectionManager.freeTag(tag);
        return responseData;
    }

    public int startSession(int connection, CipherSuite cipherSuite, PrivilegeLevel privilegeLevel, String username, String password, byte[] bmcKey) throws Exception {
        int sessionId;
        int tag = ConnectionManager.generateSessionlessTag();
        try {
            sessionId = this.connections.get(connection).startSession(tag, cipherSuite, privilegeLevel, username, password, bmcKey);
        }
        catch (Exception e) {
            ConnectionManager.freeTag(tag);
            throw e;
        }
        ConnectionManager.freeTag(tag);
        return sessionId;
    }

    public void registerListener(int connection, ConnectionListener listener) {
        this.connections.get(connection).registerListener(listener);
    }
}

