/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.connection;

import java.io.IOException;
import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.coding.commands.ResponseData;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilities;
import org.sentrysoftware.ipmi.core.coding.payload.lan.IpmiLanMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv20Message;
import org.sentrysoftware.ipmi.core.connection.Connection;
import org.sentrysoftware.ipmi.core.connection.MessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpmiMessageHandler
extends MessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(IpmiMessageHandler.class);

    public IpmiMessageHandler(Connection connection, int timeout) throws IOException {
        super(connection, timeout, 1, 63);
    }

    @Override
    protected void handleIncomingMessageInternal(Ipmiv20Message message) {
        if (message.getPayload() instanceof IpmiLanMessage) {
            IpmiLanMessage lanMessagePayload = (IpmiLanMessage)message.getPayload();
            PayloadCoder coder = this.messageQueue.getMessageFromQueue(lanMessagePayload.getSequenceNumber());
            byte tag = lanMessagePayload.getSequenceNumber();
            logger.debug("Received message with tag " + tag);
            if (coder == null) {
                logger.debug("No message tagged with " + tag + " in queue. Dropping orphan message.");
                return;
            }
            if (coder.getClass() == GetChannelAuthenticationCapabilities.class) {
                this.messageQueue.remove(tag);
            } else {
                try {
                    ResponseData responseData = coder.getResponseData(message);
                    this.connection.notifyResponseListeners(this.connection.getHandle(), tag, responseData, null);
                }
                catch (Exception e) {
                    this.connection.notifyResponseListeners(this.connection.getHandle(), tag, null, e);
                }
                this.messageQueue.remove(lanMessagePayload.getSequenceNumber());
            }
        }
    }
}

