/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.connection;

import java.net.InetAddress;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.sentrysoftware.ipmi.core.api.async.ConnectionHandle;
import org.sentrysoftware.ipmi.core.api.sol.CipherSuiteSelectionHandler;
import org.sentrysoftware.ipmi.core.api.sync.IpmiConnector;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.connection.Session;
import org.sentrysoftware.ipmi.core.connection.SessionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private static Integer sessionId = 100;
    private final ConcurrentHashMap<Integer, Session> sessionsPerConnectionHandle = new ConcurrentHashMap();

    public static synchronized int generateSessionId() {
        Integer n = sessionId = Integer.valueOf(sessionId % 0x1FFFFFFF);
        sessionId = sessionId + 1;
        return n;
    }

    public static Session establishSession(IpmiConnector connector, String remoteHost, int remotePort, String user, String password, CipherSuiteSelectionHandler cipherSuiteSelectionHandler) throws SessionException {
        ConnectionHandle handle = null;
        try {
            handle = connector.createConnection(InetAddress.getByName(remoteHost), remotePort);
            List<CipherSuite> availableCipherSuites = connector.getAvailableCipherSuites(handle);
            CipherSuite cipherSuite = cipherSuiteSelectionHandler.choose(availableCipherSuites);
            if (cipherSuite == null) {
                cipherSuite = CipherSuite.getEmpty();
            }
            connector.getChannelAuthenticationCapabilities(handle, cipherSuite, PrivilegeLevel.Administrator);
            return connector.openSession(handle, user, password, null);
        }
        catch (Exception e) {
            SessionManager.closeConnection(connector, handle);
            throw new SessionException("Cannot create new session due to exception", e);
        }
    }

    private static void closeConnection(IpmiConnector connector, ConnectionHandle handle) {
        try {
            if (connector != null && handle != null) {
                connector.closeSession(handle);
                connector.tearDown();
            }
        }
        catch (Exception e) {
            logger.error("Cannot close connection after exception thrown during session establishment.", (Throwable)e);
        }
    }

    public Session registerSession(int sessionId, ConnectionHandle connectionHandle) {
        if (connectionHandle.getUser() == null || connectionHandle.getRemoteAddress() == null) {
            throw new IllegalArgumentException("Given connection handle is incomplete (lacks user or remote address)");
        }
        Session newSession = new Session(sessionId, connectionHandle);
        Session currentSession = this.sessionsPerConnectionHandle.putIfAbsent(connectionHandle.getHandle(), newSession);
        return currentSession != null ? currentSession : newSession;
    }

    public void unregisterSession(ConnectionHandle connectionHandle) {
        this.sessionsPerConnectionHandle.remove(connectionHandle.getHandle());
    }

    public Session getSessionForCriteria(InetAddress remoteAddress, int remotePort, String user) {
        for (Session session : this.sessionsPerConnectionHandle.values()) {
            ConnectionHandle sessionConnectionHandle = session.getConnectionHandle();
            if (!sessionConnectionHandle.getUser().equals(user) || !sessionConnectionHandle.getRemoteAddress().equals(remoteAddress) || sessionConnectionHandle.getRemotePort() != remotePort) continue;
            return session;
        }
        return null;
    }
}

