/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.connection.queue;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.sentrysoftware.ipmi.core.coding.PayloadCoder;
import org.sentrysoftware.ipmi.core.connection.Connection;
import org.sentrysoftware.ipmi.core.connection.ConnectionException;
import org.sentrysoftware.ipmi.core.connection.queue.QueueElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageQueue
extends TimerTask {
    private List<QueueElement> queue;
    private int timeout;
    private Timer timer;
    private Connection connection;
    private int lastSequenceNumber;
    private Object lastSequenceNumberLock = new Object();
    private int minSequenceNumber = 1;
    private int sequenceNumberUpperBound = 64;
    private static Logger logger = LoggerFactory.getLogger(MessageQueue.class);
    private static int cleaningFrequency = 500;
    private static final int QUEUE_SIZE = 8;
    private List<Integer> reservedTags;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public MessageQueue(Connection connection, int timeout, int minSequenceNumber, int maxSequenceNumber) {
        this.minSequenceNumber = minSequenceNumber;
        this.sequenceNumberUpperBound = maxSequenceNumber + 1;
        this.reservedTags = new ArrayList<Integer>();
        this.lastSequenceNumber = minSequenceNumber - 1;
        this.connection = connection;
        this.queue = new ArrayList<QueueElement>();
        this.setTimeout(timeout);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)this, cleaningFrequency, (long)cleaningFrequency);
    }

    private int incrementSequenceNumber(int currentSequenceNumber) {
        int newSequenceNumber = (currentSequenceNumber + 1) % this.sequenceNumberUpperBound;
        if (newSequenceNumber == 0) {
            newSequenceNumber = this.minSequenceNumber;
        }
        return newSequenceNumber;
    }

    public void tearDown() {
        this.timer.cancel();
    }

    private synchronized boolean isReserved(int tag) {
        return this.reservedTags.contains(tag);
    }

    private synchronized boolean reserveTag(int tag) {
        if (this.isReserved(tag)) {
            this.reservedTags.add(tag);
            return true;
        }
        return false;
    }

    private synchronized void releaseTag(int tag) {
        this.reservedTags.remove((Object)tag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(PayloadCoder request) {
        this.run();
        boolean first = true;
        List<QueueElement> list = this.queue;
        synchronized (list) {
            Object object = this.lastSequenceNumberLock;
            synchronized (object) {
                if (this.queue.size() < 8) {
                    int sequenceNumber = this.incrementSequenceNumber(this.lastSequenceNumber);
                    while (this.isReserved(sequenceNumber)) {
                        sequenceNumber = this.incrementSequenceNumber(sequenceNumber);
                        if (!first) {
                            try {
                                this.lastSequenceNumberLock.wait(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (sequenceNumber == this.lastSequenceNumber) {
                            return -1;
                        }
                        first = false;
                    }
                    this.reserveTag(sequenceNumber);
                    this.lastSequenceNumber = sequenceNumber;
                    QueueElement element = new QueueElement(sequenceNumber, request);
                    this.queue.add(element);
                    return sequenceNumber;
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int tag) {
        this.run();
        List<QueueElement> list = this.queue;
        synchronized (list) {
            int i = 0;
            int index = -1;
            for (QueueElement element : this.queue) {
                if (element.getId() == tag) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == 0) {
                this.queue.remove(0);
                this.releaseTag(tag);
                while (!this.queue.isEmpty() && this.queue.get(0).getRequest() == null) {
                    int additionalTag = this.queue.get(0).getId();
                    this.queue.remove(0);
                    this.releaseTag(additionalTag);
                }
            } else if (index > 0) {
                this.queue.get(index).setRequest(null);
            }
        }
    }

    public void removeAt(int index) {
        if (index >= this.queue.size()) {
            throw new IndexOutOfBoundsException("Index out of bounds : " + index);
        }
        this.remove(this.queue.get(index).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsId(int sequenceNumber) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != sequenceNumber || element.getRequest() == null) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSequenceNumber() {
        Object object = this.lastSequenceNumberLock;
        synchronized (object) {
            int sequenceNumber;
            this.lastSequenceNumber = sequenceNumber = this.incrementSequenceNumber(this.lastSequenceNumber);
            return sequenceNumber;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PayloadCoder getMessageFromQueue(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != tag || element.getRequest() == null) continue;
                return element.getRequest();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageIndexFromQueue(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            int i = 0;
            for (QueueElement element : this.queue) {
                if (element.getId() == tag && element.getRequest() != null) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public int getMessageRetries(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != tag || element.getRequest() == null) continue;
                return element.getRetries();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageSequenceNumber(int tag) {
        List<QueueElement> list = this.queue;
        synchronized (list) {
            for (QueueElement element : this.queue) {
                if (element.getId() != tag || element.getRequest() == null) continue;
                return element.getId();
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.queue != null) {
            List<QueueElement> list = this.queue;
            synchronized (list) {
                boolean process = true;
                while (process && !this.queue.isEmpty()) {
                    boolean done;
                    QueueElement oldestQueueElement = this.queue.get(0);
                    boolean bl = done = oldestQueueElement.getRequest() == null;
                    if (this.messageJustTimedOut(oldestQueueElement) || done) {
                        this.processObsoleteMessage(oldestQueueElement, done);
                        continue;
                    }
                    process = false;
                }
            }
        }
    }

    private boolean messageJustTimedOut(QueueElement oldestQueueElement) {
        Date now = new Date();
        return now.getTime() - oldestQueueElement.getTimestamp().getTime() > (long)this.timeout;
    }

    private void processObsoleteMessage(QueueElement message, boolean done) {
        int tag = message.getId();
        boolean previouslyTimedOut = message.isTimedOut();
        if (previouslyTimedOut || done) {
            this.queue.remove(0);
            logger.info("Removing message after timeout, tag: " + tag);
            this.releaseTag(tag);
        } else {
            message.makeTimedOut();
            message.refreshTimestamp();
            this.connection.notifyResponseListeners(this.connection.getHandle(), tag, null, new ConnectionException("Message timed out"));
        }
    }
}

