/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm.states;

import org.sentrysoftware.ipmi.core.coding.commands.session.OpenSession;
import org.sentrysoftware.ipmi.core.coding.payload.PlainMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.IpmiMessage;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.PlainCommandv20Decoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.ProtocolDecoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.Protocolv20Decoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.actions.ResponseAction;
import org.sentrysoftware.ipmi.core.sm.events.DefaultAck;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.events.Timeout;
import org.sentrysoftware.ipmi.core.sm.states.Authcap;
import org.sentrysoftware.ipmi.core.sm.states.OpenSessionComplete;
import org.sentrysoftware.ipmi.core.sm.states.State;

public class OpenSessionWaiting
extends State {
    private int tag;

    public OpenSessionWaiting(int tag) {
        this.tag = tag;
    }

    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof DefaultAck) {
            stateMachine.setCurrent(new OpenSessionComplete());
        } else if (machineEvent instanceof Timeout) {
            stateMachine.setCurrent(new Authcap());
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
        if (ProtocolDecoder.decodeAuthenticationType(message) != AuthenticationType.RMCPPlus) {
            return;
        }
        PlainCommandv20Decoder decoder = new PlainCommandv20Decoder(CipherSuite.getEmpty());
        if (Protocolv20Decoder.decodePayloadType(message.getData()[1]) != PayloadType.RmcpOpenSessionResponse) {
            return;
        }
        IpmiMessage ipmiMessage = null;
        try {
            ipmiMessage = decoder.decode(message);
            OpenSession openSession = new OpenSession(CipherSuite.getEmpty());
            if (openSession.isCommandResponse(ipmiMessage) && TypeConverter.byteToInt(((PlainMessage)ipmiMessage.getPayload()).getPayloadData()[0]) == this.tag) {
                stateMachine.doExternalAction(new ResponseAction(openSession.getResponseData(ipmiMessage)));
            }
        }
        catch (Exception e) {
            stateMachine.doExternalAction(new ErrorAction(e));
        }
    }
}

