/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.ipmi.core.sm.states;

import org.sentrysoftware.ipmi.core.coding.Encoder;
import org.sentrysoftware.ipmi.core.coding.commands.IpmiVersion;
import org.sentrysoftware.ipmi.core.coding.commands.PrivilegeLevel;
import org.sentrysoftware.ipmi.core.coding.commands.session.CloseSession;
import org.sentrysoftware.ipmi.core.coding.commands.session.GetChannelAuthenticationCapabilities;
import org.sentrysoftware.ipmi.core.coding.protocol.AuthenticationType;
import org.sentrysoftware.ipmi.core.coding.protocol.Ipmiv20Message;
import org.sentrysoftware.ipmi.core.coding.protocol.PayloadType;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.ProtocolDecoder;
import org.sentrysoftware.ipmi.core.coding.protocol.decoder.Protocolv20Decoder;
import org.sentrysoftware.ipmi.core.coding.protocol.encoder.Protocolv20Encoder;
import org.sentrysoftware.ipmi.core.coding.rmcp.RmcpMessage;
import org.sentrysoftware.ipmi.core.coding.security.CipherSuite;
import org.sentrysoftware.ipmi.core.common.TypeConverter;
import org.sentrysoftware.ipmi.core.sm.StateMachine;
import org.sentrysoftware.ipmi.core.sm.actions.ErrorAction;
import org.sentrysoftware.ipmi.core.sm.actions.MessageAction;
import org.sentrysoftware.ipmi.core.sm.events.Sendv20Message;
import org.sentrysoftware.ipmi.core.sm.events.SessionUpkeep;
import org.sentrysoftware.ipmi.core.sm.events.StateMachineEvent;
import org.sentrysoftware.ipmi.core.sm.events.Timeout;
import org.sentrysoftware.ipmi.core.sm.states.Authcap;
import org.sentrysoftware.ipmi.core.sm.states.State;

public class SessionValid
extends State {
    private CipherSuite cipherSuite;
    private int sessionId;

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public SessionValid(CipherSuite cipherSuite, int sessionId) {
        this.cipherSuite = cipherSuite;
        this.sessionId = sessionId;
    }

    @Override
    public void doTransition(StateMachine stateMachine, StateMachineEvent machineEvent) {
        if (machineEvent instanceof Sendv20Message) {
            Sendv20Message event = (Sendv20Message)machineEvent;
            try {
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), event.getPayloadCoder(), event.getMessageSequenceNumber(), event.getSessionSequenceNumber(), event.getSessionId()));
            }
            catch (Exception e) {
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else if (machineEvent instanceof SessionUpkeep) {
            SessionUpkeep event = (SessionUpkeep)machineEvent;
            try {
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), new GetChannelAuthenticationCapabilities(IpmiVersion.V20, IpmiVersion.V20, this.cipherSuite, PrivilegeLevel.Callback, TypeConverter.intToByte(14)), event.getMessageSequenceNumber(), event.getSessionSequenceNumber(), event.getSessionId()));
            }
            catch (Exception e) {
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else if (machineEvent instanceof Timeout) {
            stateMachine.setCurrent(new Authcap());
        } else if (machineEvent instanceof org.sentrysoftware.ipmi.core.sm.events.CloseSession) {
            org.sentrysoftware.ipmi.core.sm.events.CloseSession event = (org.sentrysoftware.ipmi.core.sm.events.CloseSession)machineEvent;
            try {
                stateMachine.setCurrent(new Authcap());
                stateMachine.sendMessage(Encoder.encode(new Protocolv20Encoder(), new CloseSession(IpmiVersion.V20, this.cipherSuite, AuthenticationType.RMCPPlus, event.getSessionId()), event.getMessageSequenceNumber(), event.getSessionSequenceNumber(), event.getSessionId()));
            }
            catch (Exception e) {
                stateMachine.setCurrent(this);
                stateMachine.doExternalAction(new ErrorAction(e));
            }
        } else {
            stateMachine.doExternalAction(new ErrorAction(new IllegalArgumentException("Invalid transition")));
        }
    }

    @Override
    public void doAction(StateMachine stateMachine, RmcpMessage message) {
        if (ProtocolDecoder.decodeAuthenticationType(message) != AuthenticationType.RMCPPlus) {
            return;
        }
        if (Protocolv20Decoder.decodeSessionID(message) == 0) {
            return;
        }
        Protocolv20Decoder decoder = new Protocolv20Decoder(this.cipherSuite);
        PayloadType payloadType = Protocolv20Decoder.decodePayloadType(message.getData()[1]);
        if (payloadType != PayloadType.Ipmi && payloadType != PayloadType.Sol) {
            return;
        }
        if (Protocolv20Decoder.decodeSessionID(message) != this.sessionId) {
            return;
        }
        try {
            Ipmiv20Message message20 = (Ipmiv20Message)decoder.decode(message);
            if (message20.getSessionID() == this.sessionId) {
                stateMachine.doExternalAction(new MessageAction(message20));
            }
        }
        catch (Exception e) {
            stateMachine.doExternalAction(new ErrorAction(e));
        }
    }
}

