/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.frontend;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sentrysoftware.jawk.NotImplementedError;
import org.sentrysoftware.jawk.ext.JawkExtension;
import org.sentrysoftware.jawk.frontend.AwkSyntaxTree;
import org.sentrysoftware.jawk.intermediate.Address;
import org.sentrysoftware.jawk.intermediate.AwkTuples;
import org.sentrysoftware.jawk.intermediate.HasFunctionAddress;
import org.sentrysoftware.jawk.jrt.KeyList;
import org.sentrysoftware.jawk.util.AwkLogger;
import org.sentrysoftware.jawk.util.ScriptSource;
import org.slf4j.Logger;

public class AwkParser {
    private static final Logger LOG = AwkLogger.getLogger(AwkParser.class);
    private static int s_idx = 257;
    private static final int _EOF_ = s_idx++;
    private static final int _NEWLINE_ = s_idx++;
    private static final int _SEMICOLON_ = s_idx++;
    private static final int _ID_ = s_idx++;
    private static final int _FUNC_ID_ = s_idx++;
    private static final int _INTEGER_ = s_idx++;
    private static final int _DOUBLE_ = s_idx++;
    private static final int _STRING_ = s_idx++;
    private static final int _EQUALS_ = s_idx++;
    private static final int _AND_ = s_idx++;
    private static final int _OR_ = s_idx++;
    private static final int _EQ_ = s_idx++;
    private static final int _GT_ = s_idx++;
    private static final int _GE_ = s_idx++;
    private static final int _LT_ = s_idx++;
    private static final int _LE_ = s_idx++;
    private static final int _NE_ = s_idx++;
    private static final int _NOT_ = s_idx++;
    private static final int _PIPE_ = s_idx++;
    private static final int _QUESTION_MARK_ = s_idx++;
    private static final int _COLON_ = s_idx++;
    private static final int _APPEND_ = s_idx++;
    private static final int _PLUS_ = s_idx++;
    private static final int _MINUS_ = s_idx++;
    private static final int _MULT_ = s_idx++;
    private static final int _DIVIDE_ = s_idx++;
    private static final int _MOD_ = s_idx++;
    private static final int _POW_ = s_idx++;
    private static final int _COMMA_ = s_idx++;
    private static final int _MATCHES_ = s_idx++;
    private static final int _NOT_MATCHES_ = s_idx++;
    private static final int _DOLLAR_ = s_idx++;
    private static final int _INC_ = s_idx++;
    private static final int _DEC_ = s_idx++;
    private static final int _PLUS_EQ_ = s_idx++;
    private static final int _MINUS_EQ_ = s_idx++;
    private static final int _MULT_EQ_ = s_idx++;
    private static final int _DIV_EQ_ = s_idx++;
    private static final int _MOD_EQ_ = s_idx++;
    private static final int _POW_EQ_ = s_idx++;
    private static final int _OPEN_PAREN_ = s_idx++;
    private static final int _CLOSE_PAREN_ = s_idx++;
    private static final int _OPEN_BRACE_ = s_idx++;
    private static final int _CLOSE_BRACE_ = s_idx++;
    private static final int _OPEN_BRACKET_ = s_idx++;
    private static final int _CLOSE_BRACKET_ = s_idx++;
    private static final int _BUILTIN_FUNC_NAME_ = s_idx++;
    private static final int _EXTENSION_ = s_idx++;
    private static final Map<String, Integer> KEYWORDS = new HashMap<String, Integer>();
    private static int f_idx;
    private static final Map<String, Integer> BUILTIN_FUNC_NAMES;
    private static final int sp_idx = 257;
    private static final Map<String, Integer> SPECIAL_VAR_NAMES;
    private final AwkSymbolTableImpl symbol_table = new AwkSymbolTableImpl();
    private final boolean additional_functions;
    private final boolean additional_type_functions;
    private final Map<String, JawkExtension> extensions;
    private List<ScriptSource> scriptSources;
    private int scriptSourcesCurrentIndex;
    private LineNumberReader reader;
    private int c;
    private int token;
    private StringBuffer text = new StringBuffer();
    private StringBuffer string = new StringBuffer();
    private StringBuffer regexp = new StringBuffer();
    private Address next_address;

    public AwkParser(boolean additional_functions, boolean additional_type_functions, Map<String, JawkExtension> extensions) {
        this.additional_functions = additional_functions;
        this.additional_type_functions = additional_type_functions;
        if (additional_functions && KEYWORDS.get("_sleep") == null) {
            assert (KEYWORDS.get("_sleep") == null);
            assert (KEYWORDS.get("_dump") == null);
            KEYWORDS.put("_sleep", s_idx++);
            KEYWORDS.put("_dump", s_idx++);
            BUILTIN_FUNC_NAMES.put("exec", f_idx++);
        }
        if (additional_type_functions && KEYWORDS.get("_INTEGER") == null) {
            assert (KEYWORDS.get("_INTEGER") == null);
            assert (KEYWORDS.get("_DOUBLE") == null);
            assert (KEYWORDS.get("_STRING") == null);
            KEYWORDS.put("_INTEGER", s_idx++);
            KEYWORDS.put("_DOUBLE", s_idx++);
            KEYWORDS.put("_STRING", s_idx++);
        }
        this.extensions = extensions;
    }

    private void read() throws IOException {
        this.text.append((char)this.c);
        this.c = this.reader.read();
        while (this.c == 13) {
            this.c = this.reader.read();
        }
        if (this.c < 0 && this.scriptSourcesCurrentIndex + 1 < this.scriptSources.size()) {
            ++this.scriptSourcesCurrentIndex;
            this.reader = new LineNumberReader(this.scriptSources.get(this.scriptSourcesCurrentIndex).getReader());
            this.read();
        }
    }

    private void skipWhitespaces() throws IOException {
        while (this.c == 32 || this.c == 9 || this.c == 35 || this.c == 10) {
            if (this.c == 35) {
                while (this.c >= 0 && this.c != 10) {
                    this.read();
                }
            }
            this.read();
        }
    }

    private void warn(String message) {
        LOG.warn("%s (%s:%d)", new Object[]{message, this.scriptSources.get(this.scriptSourcesCurrentIndex).getDescription(), this.reader.getLineNumber()});
    }

    public AwkSyntaxTree parse(List<ScriptSource> scriptSources) throws IOException {
        if (scriptSources == null || scriptSources.isEmpty()) {
            throw new IOException("No script sources supplied");
        }
        this.scriptSources = scriptSources;
        this.scriptSourcesCurrentIndex = 0;
        this.reader = new LineNumberReader(scriptSources.get(this.scriptSourcesCurrentIndex).getReader());
        this.read();
        this.lexer();
        return this.SCRIPT();
    }

    private void readString() throws IOException {
        this.string.setLength(0);
        block11: while (this.token != _EOF_ && this.c > 0 && this.c != 34 && this.c != 10) {
            if (this.c == 92) {
                this.read();
                switch (this.c) {
                    case 110: {
                        this.string.append('\n');
                        break;
                    }
                    case 116: {
                        this.string.append('\t');
                        break;
                    }
                    case 114: {
                        this.string.append('\r');
                        break;
                    }
                    case 97: {
                        this.string.append('\u0007');
                        break;
                    }
                    case 98: {
                        this.string.append('\b');
                        break;
                    }
                    case 102: {
                        this.string.append('\f');
                        break;
                    }
                    case 118: {
                        this.string.append('\u000b');
                        break;
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: {
                        int octalChar = this.c - 48;
                        this.read();
                        if (this.c >= 48 && this.c <= 55) {
                            octalChar = (octalChar << 3) + this.c - 48;
                            this.read();
                            if (this.c >= 48 && this.c <= 55) {
                                octalChar = (octalChar << 3) + this.c - 48;
                                this.read();
                            }
                        }
                        this.string.append((char)octalChar);
                        continue block11;
                    }
                    case 120: {
                        int hexChar = 0;
                        this.read();
                        if (this.c >= 48 && this.c <= 57) {
                            hexChar = this.c - 48;
                        } else if (this.c >= 65 && this.c <= 70) {
                            hexChar = this.c - 65 + 10;
                        } else if (this.c >= 97 && this.c <= 102) {
                            hexChar = this.c - 97 + 10;
                        } else {
                            this.warn("no hex digits in `\\x' sequence");
                            this.string.append('x');
                            continue block11;
                        }
                        this.read();
                        if (this.c >= 48 && this.c <= 57) {
                            hexChar = (hexChar << 4) + this.c - 48;
                        } else if (this.c >= 65 && this.c <= 70) {
                            hexChar = (hexChar << 4) + this.c - 65 + 10;
                        } else if (this.c >= 97 && this.c <= 102) {
                            hexChar = (hexChar << 4) + this.c - 97 + 10;
                        } else {
                            this.string.append((char)hexChar);
                            continue block11;
                        }
                        this.string.append((char)hexChar);
                        break;
                    }
                    default: {
                        this.string.append((char)this.c);
                        break;
                    }
                }
            } else {
                this.string.append((char)this.c);
            }
            this.read();
        }
        if (this.token == _EOF_ || this.c == 10 || this.c <= 0) {
            throw new LexerException("Unterminated string: " + this.text);
        }
        this.read();
    }

    private void readRegexp() throws IOException {
        this.regexp.setLength(0);
        while (this.token != _EOF_ && this.c > 0 && this.c != 47 && this.c != 10) {
            if (this.c == 92) {
                this.read();
                if (this.c != 47) {
                    this.regexp.append('\\');
                }
            }
            this.regexp.append((char)this.c);
            this.read();
        }
        if (this.token == _EOF_ || this.c == 10 || this.c <= 0) {
            throw new LexerException("Unterminated string: " + this.text);
        }
        this.read();
    }

    private static String toTokenString(int token) {
        Class<AwkParser> c = AwkParser.class;
        Field[] fields = c.getDeclaredFields();
        try {
            for (Field field : fields) {
                if ((field.getModifiers() & 8) <= 0 || field.getType() != Integer.TYPE || field.getInt(null) != token) continue;
                return field.getName();
            }
        }
        catch (IllegalAccessException iac) {
            LOG.error("Failed to create token string", (Throwable)iac);
            return "[" + token + ": " + iac + "]";
        }
        return "{" + token + "}";
    }

    private int lexer(int expected_token) throws IOException {
        if (this.token != expected_token) {
            throw new ParserException("Expecting " + AwkParser.toTokenString(expected_token) + ". Found: " + AwkParser.toTokenString(this.token) + " (" + this.text + ")");
        }
        return this.lexer();
    }

    private int lexer() throws IOException {
        while (this.c >= 0 && (this.c == 32 || this.c == 9 || this.c == 35 || this.c == 92)) {
            if (this.c == 92) {
                this.read();
                if (this.c != 10) continue;
                this.read();
                continue;
            }
            if (this.c == 35) {
                while (this.c >= 0 && this.c != 10) {
                    this.read();
                }
                continue;
            }
            this.read();
        }
        this.text.setLength(0);
        if (this.c < 0) {
            this.token = _EOF_;
            return this.token;
        }
        if (this.c == 44) {
            this.read();
            this.skipWhitespaces();
            this.token = _COMMA_;
            return this.token;
        }
        if (this.c == 40) {
            this.read();
            this.token = _OPEN_PAREN_;
            return this.token;
        }
        if (this.c == 41) {
            this.read();
            this.token = _CLOSE_PAREN_;
            return this.token;
        }
        if (this.c == 123) {
            this.read();
            this.skipWhitespaces();
            this.token = _OPEN_BRACE_;
            return this.token;
        }
        if (this.c == 125) {
            this.read();
            this.token = _CLOSE_BRACE_;
            return this.token;
        }
        if (this.c == 91) {
            this.read();
            this.token = _OPEN_BRACKET_;
            return this.token;
        }
        if (this.c == 93) {
            this.read();
            this.token = _CLOSE_BRACKET_;
            return this.token;
        }
        if (this.c == 36) {
            this.read();
            this.token = _DOLLAR_;
            return this.token;
        }
        if (this.c == 126) {
            this.read();
            this.token = _MATCHES_;
            return this.token;
        }
        if (this.c == 63) {
            this.read();
            this.skipWhitespaces();
            this.token = _QUESTION_MARK_;
            return this.token;
        }
        if (this.c == 58) {
            this.read();
            this.skipWhitespaces();
            this.token = _COLON_;
            return this.token;
        }
        if (this.c == 38) {
            this.read();
            if (this.c == 38) {
                this.read();
                this.skipWhitespaces();
                this.token = _AND_;
                return this.token;
            }
            throw new LexerException("use && for logical and");
        }
        if (this.c == 124) {
            this.read();
            if (this.c == 124) {
                this.read();
                this.skipWhitespaces();
                this.token = _OR_;
                return this.token;
            }
            this.token = _PIPE_;
            return this.token;
        }
        if (this.c == 61) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _EQ_;
                return this.token;
            }
            this.token = _EQUALS_;
            return this.token;
        }
        if (this.c == 43) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _PLUS_EQ_;
                return this.token;
            }
            if (this.c == 43) {
                this.read();
                this.token = _INC_;
                return this.token;
            }
            this.token = _PLUS_;
            return this.token;
        }
        if (this.c == 45) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _MINUS_EQ_;
                return this.token;
            }
            if (this.c == 45) {
                this.read();
                this.token = _DEC_;
                return this.token;
            }
            this.token = _MINUS_;
            return this.token;
        }
        if (this.c == 42) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _MULT_EQ_;
                return this.token;
            }
            if (this.c == 42) {
                this.read();
                this.token = _POW_;
                return this.token;
            }
            this.token = _MULT_;
            return this.token;
        }
        if (this.c == 47) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _DIV_EQ_;
                return this.token;
            }
            this.token = _DIVIDE_;
            return this.token;
        }
        if (this.c == 37) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _MOD_EQ_;
                return this.token;
            }
            this.token = _MOD_;
            return this.token;
        }
        if (this.c == 94) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _POW_EQ_;
                return this.token;
            }
            this.token = _POW_;
            return this.token;
        }
        if (this.c == 62) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _GE_;
                return this.token;
            }
            if (this.c == 62) {
                this.read();
                this.token = _APPEND_;
                return this.token;
            }
            this.token = _GT_;
            return this.token;
        }
        if (this.c == 60) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _LE_;
                return this.token;
            }
            this.token = _LT_;
            return this.token;
        }
        if (this.c == 33) {
            this.read();
            if (this.c == 61) {
                this.read();
                this.token = _NE_;
                return this.token;
            }
            if (this.c == 126) {
                this.read();
                this.token = _NOT_MATCHES_;
                return this.token;
            }
            this.token = _NOT_;
            return this.token;
        }
        if (this.c == 46) {
            this.read();
            boolean hit = false;
            while (this.c > 0 && Character.isDigit(this.c)) {
                hit = true;
                this.read();
            }
            if (!hit) {
                throw new LexerException("Decimal point encountered with no values on either side.");
            }
            this.token = _DOUBLE_;
            return this.token;
        }
        if (Character.isDigit(this.c)) {
            this.read();
            while (this.c > 0) {
                if (this.c == 46) {
                    this.read();
                    while (this.c > 0 && Character.isDigit(this.c)) {
                        this.read();
                    }
                    this.token = _DOUBLE_;
                    return this.token;
                }
                if (!Character.isDigit(this.c)) break;
                this.read();
            }
            this.token = _INTEGER_;
            return this.token;
        }
        if (Character.isJavaIdentifierStart(this.c)) {
            this.read();
            while (Character.isJavaIdentifierPart(this.c)) {
                this.read();
            }
            if (this.extensions.get(this.text.toString()) != null) {
                this.token = _EXTENSION_;
                return this.token;
            }
            Integer kw_token = KEYWORDS.get(this.text.toString());
            if (kw_token != null) {
                this.token = kw_token;
                return this.token;
            }
            Integer bf_idx = BUILTIN_FUNC_NAMES.get(this.text.toString());
            if (bf_idx != null) {
                this.token = _BUILTIN_FUNC_NAME_;
                return this.token;
            }
            if (this.c == 40) {
                this.token = _FUNC_ID_;
                return this.token;
            }
            this.token = _ID_;
            return this.token;
        }
        if (this.c == 59) {
            this.read();
            while ((this.c == 32 || this.c == 9 || this.c == 10 || this.c == 35) && this.c != 10) {
                if (this.c == 35) {
                    while (this.c >= 0 && this.c != 10) {
                        this.read();
                    }
                    if (this.c != 10) continue;
                    this.read();
                    continue;
                }
                this.read();
            }
            this.token = _SEMICOLON_;
            return this.token;
        }
        if (this.c == 10) {
            this.read();
            while (this.c == 32 || this.c == 9 || this.c == 35 || this.c == 10) {
                if (this.c == 35) {
                    while (this.c >= 0 && this.c != 10) {
                        this.read();
                    }
                }
                this.read();
            }
            this.token = _NEWLINE_;
            return this.token;
        }
        if (this.c == 34) {
            this.read();
            this.readString();
            this.token = _STRING_;
            return this.token;
        }
        throw new LexerException("Invalid character (" + this.c + "): " + (char)this.c);
    }

    private void terminator() throws IOException {
        if (!this.opt_terminator()) {
            throw new ParserException("Expecting statement terminator. Got " + AwkParser.toTokenString(this.token) + ": " + this.text);
        }
    }

    private boolean opt_terminator() throws IOException {
        if (this.opt_newline()) {
            return true;
        }
        if (this.token == _EOF_ || this.token == _CLOSE_BRACE_) {
            return true;
        }
        if (this.token == _SEMICOLON_) {
            this.lexer();
            return true;
        }
        return false;
    }

    private boolean opt_newline() throws IOException {
        if (this.token == _NEWLINE_) {
            this.lexer();
            return true;
        }
        return false;
    }

    AST SCRIPT() throws IOException {
        AST rl = this.token != _EOF_ ? this.RULE_LIST() : null;
        this.lexer(_EOF_);
        return rl;
    }

    AST RULE_LIST() throws IOException {
        this.opt_newline();
        AST rule_or_function = null;
        if (this.token == KEYWORDS.get("function")) {
            rule_or_function = this.FUNCTION();
        } else if (this.token != _EOF_) {
            rule_or_function = this.RULE();
        } else {
            return null;
        }
        this.opt_terminator();
        if (rule_or_function == null) {
            return this.RULE_LIST();
        }
        return new RuleList_AST(rule_or_function, this.RULE_LIST());
    }

    AST FUNCTION() throws IOException {
        this.expectKeyword("function");
        if (this.token != _FUNC_ID_ && this.token != _ID_) {
            throw new ParserException("Expecting function name. Got " + AwkParser.toTokenString(this.token) + ": " + this.text);
        }
        String function_name = this.text.toString();
        this.lexer();
        this.symbol_table.setFunctionName(function_name);
        this.lexer(_OPEN_PAREN_);
        AST formal_param_list = this.token == _CLOSE_PAREN_ ? null : this.FORMAL_PARAM_LIST(function_name);
        this.lexer(_CLOSE_PAREN_);
        this.opt_newline();
        this.lexer(_OPEN_BRACE_);
        AST function_block = this.STATEMENT_LIST();
        this.lexer(_CLOSE_BRACE_);
        this.symbol_table.clearFunctionName(function_name);
        return this.symbol_table.addFunctionDef(function_name, formal_param_list, function_block);
    }

    AST FORMAL_PARAM_LIST(String func_name) throws IOException {
        if (this.token == _ID_) {
            String id = this.text.toString();
            int offset = this.symbol_table.addFunctionParameter(func_name, id);
            this.lexer();
            if (this.token == _COMMA_) {
                this.lexer();
                this.opt_newline();
                AST rest = this.FORMAL_PARAM_LIST(func_name);
                if (rest == null) {
                    throw new ParserException("Cannot terminate a formal parameter list with a comma.");
                }
                return new FunctionDefParamList_AST(id, offset, rest);
            }
            return new FunctionDefParamList_AST(id, offset, null);
        }
        return null;
    }

    AST RULE() throws IOException {
        AST opt_stmts;
        AST opt_expr;
        if (this.token == KEYWORDS.get("BEGIN")) {
            this.lexer();
            opt_expr = this.symbol_table.addBEGIN();
        } else if (this.token == KEYWORDS.get("END")) {
            this.lexer();
            opt_expr = this.symbol_table.addEND();
        } else if (this.token != _OPEN_BRACE_ && this.token != _SEMICOLON_ && this.token != _NEWLINE_ && this.token != _EOF_) {
            opt_expr = this.ASSIGNMENT_EXPRESSION(true, true, false);
            if (this.token == _COMMA_) {
                this.lexer();
                this.opt_newline();
                opt_expr = new ConditionPair_AST(opt_expr, this.ASSIGNMENT_EXPRESSION(true, true, false));
            }
        } else {
            opt_expr = null;
        }
        if (this.token == _OPEN_BRACE_) {
            this.lexer();
            opt_stmts = this.STATEMENT_LIST();
            this.lexer(_CLOSE_BRACE_);
        } else {
            opt_stmts = null;
        }
        return new Rule_AST(opt_expr, opt_stmts);
    }

    private AST STATEMENT_LIST() throws IOException {
        AST stmt;
        this.opt_newline();
        if (this.token == _CLOSE_BRACE_ || this.token == _EOF_) {
            return null;
        }
        if (this.token == _OPEN_BRACE_) {
            this.lexer();
            stmt = this.STATEMENT_LIST();
            this.lexer(_CLOSE_BRACE_);
        } else {
            if (this.token == _SEMICOLON_) {
                this.lexer();
                return this.STATEMENT_LIST();
            }
            stmt = this.STATEMENT();
        }
        AST rest = this.STATEMENT_LIST();
        if (rest == null) {
            return stmt;
        }
        if (stmt == null) {
            return rest;
        }
        return new STATEMENTLIST_AST(stmt, rest);
    }

    AST EXPRESSION_LIST(boolean not_in_print_root, boolean allow_in_keyword) throws IOException {
        AST expr = this.ASSIGNMENT_EXPRESSION(not_in_print_root, allow_in_keyword, false);
        if (this.token == _COMMA_) {
            this.lexer();
            this.opt_newline();
            return new FunctionCallParamList_AST(expr, this.EXPRESSION_LIST(not_in_print_root, allow_in_keyword));
        }
        return new FunctionCallParamList_AST(expr, null);
    }

    AST ASSIGNMENT_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST comma_expression = this.COMMA_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        int op = 0;
        String txt = null;
        AST assignment_expression = null;
        if (this.token == _EQUALS_ || this.token == _PLUS_EQ_ || this.token == _MINUS_EQ_ || this.token == _MULT_EQ_ || this.token == _DIV_EQ_ || this.token == _MOD_EQ_ || this.token == _POW_EQ_) {
            op = this.token;
            txt = this.text.toString();
            this.lexer();
            assignment_expression = this.ASSIGNMENT_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            return new AssignmentExpression_AST(comma_expression, op, txt, assignment_expression);
        }
        return comma_expression;
    }

    AST COMMA_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST concat_expression = this.TERNARY_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        if (allow_multidim_indices && this.token == _COMMA_) {
            this.lexer();
            this.opt_newline();
            AST rest = this.COMMA_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            if (rest instanceof ArrayIndex_AST) {
                return new ArrayIndex_AST(concat_expression, rest);
            }
            return new ArrayIndex_AST(concat_expression, (AST)new ArrayIndex_AST(rest, null));
        }
        return concat_expression;
    }

    AST TERNARY_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST le1 = this.LOGICAL_OR_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        if (this.token == _QUESTION_MARK_) {
            this.lexer();
            AST true_block = this.TERNARY_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            this.lexer(_COLON_);
            AST false_block = this.TERNARY_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            return new TernaryExpression_AST(le1, true_block, false_block);
        }
        return le1;
    }

    AST LOGICAL_OR_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST le2 = this.LOGICAL_AND_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        int op = 0;
        String txt = null;
        AST le1 = null;
        if (this.token == _OR_) {
            op = this.token;
            txt = this.text.toString();
            this.lexer();
            le1 = this.LOGICAL_OR_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            return new LogicalExpression_AST(le2, op, txt, le1);
        }
        return le2;
    }

    AST LOGICAL_AND_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST comparison_expression = this.IN_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        int op = 0;
        String txt = null;
        AST le2 = null;
        if (this.token == _AND_) {
            op = this.token;
            txt = this.text.toString();
            this.lexer();
            le2 = this.LOGICAL_AND_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            return new LogicalExpression_AST(comparison_expression, op, txt, le2);
        }
        return comparison_expression;
    }

    AST IN_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST comparison = this.MATCHING_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        if (allow_in_keyword && this.token == KEYWORDS.get("in")) {
            this.lexer();
            return new InExpression_AST(comparison, this.IN_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices));
        }
        return comparison;
    }

    AST MATCHING_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST expression = this.COMPARISON_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        int op = 0;
        String txt = null;
        AST comparison_expression = null;
        if (this.token == _MATCHES_ || this.token == _NOT_MATCHES_) {
            op = this.token;
            txt = this.text.toString();
            this.lexer();
            comparison_expression = this.MATCHING_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            return new ComparisonExpression_AST(expression, op, txt, comparison_expression);
        }
        return expression;
    }

    AST COMPARISON_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST expression = this.CONCAT_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        int op = 0;
        String txt = null;
        AST comparison_expression = null;
        if (this.token == _EQ_ || this.token == _GE_ || this.token == _LT_ || this.token == _LE_ || this.token == _NE_ || this.token == _GT_ && not_in_print_root) {
            op = this.token;
            txt = this.text.toString();
            this.lexer();
            comparison_expression = this.COMPARISON_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            return new ComparisonExpression_AST(expression, op, txt, comparison_expression);
        }
        if (not_in_print_root && this.token == _PIPE_) {
            this.lexer();
            return this.GETLINE_EXPRESSION(expression, not_in_print_root, allow_in_keyword);
        }
        return expression;
    }

    AST CONCAT_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST te = this.EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        if (this.token == _INTEGER_ || this.token == _DOUBLE_ || this.token == _OPEN_PAREN_ || this.token == _FUNC_ID_ || this.token == _INC_ || this.token == _DEC_ || this.token == _ID_ || this.token == _STRING_ || this.token == _DOLLAR_ || this.token == _BUILTIN_FUNC_NAME_ || this.token == _EXTENSION_) {
            return new ConcatExpression_AST(te, this.CONCAT_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices));
        }
        if (this.additional_type_functions && (this.token == KEYWORDS.get("_INTEGER") || this.token == KEYWORDS.get("_DOUBLE") || this.token == KEYWORDS.get("_STRING"))) {
            return new ConcatExpression_AST(te, this.CONCAT_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices));
        }
        return te;
    }

    AST EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST term = this.TERM(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        while (this.token == _PLUS_ || this.token == _MINUS_) {
            int op = this.token;
            String txt = this.text.toString();
            this.lexer();
            AST nextTerm = this.TERM(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            term = new BinaryExpression_AST(term, op, txt, nextTerm);
        }
        return term;
    }

    AST TERM(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST unaryFactor = this.UNARY_FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        while (this.token == _MULT_ || this.token == _DIVIDE_ || this.token == _MOD_) {
            int op = this.token;
            String txt = this.text.toString();
            this.lexer();
            AST nextUnaryFactor = this.UNARY_FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            unaryFactor = new BinaryExpression_AST(unaryFactor, op, txt, nextUnaryFactor);
        }
        return unaryFactor;
    }

    AST UNARY_FACTOR(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        if (this.token == _NOT_) {
            this.lexer();
            return new NotExpression_AST(this.POWER_FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices));
        }
        if (this.token == _MINUS_) {
            this.lexer();
            return new NegativeExpression_AST(this.POWER_FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices));
        }
        if (this.token == _PLUS_) {
            this.lexer();
            return new UnaryPlusExpression_AST(this.POWER_FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices));
        }
        return this.POWER_FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices);
    }

    AST POWER_FACTOR(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        AST incdec_ast = this.FACTOR_FOR_INCDEC(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        if (this.token == _POW_) {
            int op = this.token;
            String txt = this.text.toString();
            this.lexer();
            AST term = this.POWER_FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices);
            return new BinaryExpression_AST(incdec_ast, op, txt, term);
        }
        return incdec_ast;
    }

    private boolean isLvalue(AST ast) {
        return ast instanceof ID_AST || ast instanceof ArrayReference_AST || ast instanceof DollarExpression_AST;
    }

    AST FACTOR_FOR_INCDEC(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        boolean pre_inc = false;
        boolean pre_dec = false;
        boolean post_inc = false;
        boolean post_dec = false;
        if (this.token == _INC_) {
            pre_inc = true;
            this.lexer();
        } else if (this.token == _DEC_) {
            pre_dec = true;
            this.lexer();
        }
        AST factor_ast = this.FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        if ((pre_inc || pre_dec) && !this.isLvalue(factor_ast)) {
            throw new ParserException("Cannot pre inc/dec a non-lvalue");
        }
        if (this.isLvalue(factor_ast) && !pre_inc && !pre_dec) {
            if (this.token == _INC_) {
                post_inc = true;
                this.lexer();
            } else if (this.token == _DEC_) {
                post_dec = true;
                this.lexer();
            }
        }
        if ((pre_inc || pre_dec) && (post_inc || post_dec)) {
            throw new ParserException("Cannot do pre inc/dec AND post inc/dec.");
        }
        if (pre_inc) {
            return new PreInc_AST(factor_ast);
        }
        if (pre_dec) {
            return new PreDec_AST(factor_ast);
        }
        if (post_inc) {
            return new PostInc_AST(factor_ast);
        }
        if (post_dec) {
            return new PostDec_AST(factor_ast);
        }
        return factor_ast;
    }

    AST FACTOR(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        if (this.token == _OPEN_PAREN_) {
            this.lexer();
            AST assignment_expression = this.ASSIGNMENT_EXPRESSION(true, allow_in_keyword, true);
            if (allow_multidim_indices && assignment_expression instanceof ArrayIndex_AST) {
                throw new ParserException("Cannot nest multi-dimensional array index expressions.");
            }
            this.lexer(_CLOSE_PAREN_);
            return assignment_expression;
        }
        if (this.token == _INTEGER_) {
            AST integer = this.symbol_table.addINTEGER(this.text.toString());
            this.lexer();
            return integer;
        }
        if (this.token == _DOUBLE_) {
            AST dbl = this.symbol_table.addDOUBLE(this.text.toString());
            this.lexer();
            return dbl;
        }
        if (this.token == _STRING_) {
            AST str = this.symbol_table.addSTRING(this.string.toString());
            this.lexer();
            return str;
        }
        if (this.token == KEYWORDS.get("getline")) {
            return this.GETLINE_EXPRESSION(null, not_in_print_root, allow_in_keyword);
        }
        if (this.token == _DIVIDE_ || this.token == _DIV_EQ_) {
            this.readRegexp();
            if (this.token == _DIV_EQ_) {
                this.regexp.insert(0, '=');
            }
            AST regexp_ast = this.symbol_table.addREGEXP(this.regexp.toString());
            this.lexer();
            return regexp_ast;
        }
        if (this.additional_type_functions && this.token == KEYWORDS.get("_INTEGER")) {
            return this.INTEGER_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        }
        if (this.additional_type_functions && this.token == KEYWORDS.get("_DOUBLE")) {
            return this.DOUBLE_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        }
        if (this.additional_type_functions && this.token == KEYWORDS.get("_STRING")) {
            return this.STRING_EXPRESSION(not_in_print_root, allow_in_keyword, allow_multidim_indices);
        }
        if (this.token == _DOLLAR_) {
            this.lexer();
            if (this.token == _INC_ || this.token == _DEC_) {
                return new DollarExpression_AST(this.FACTOR_FOR_INCDEC(not_in_print_root, allow_in_keyword, allow_multidim_indices));
            }
            if (this.token == _NOT_ || this.token == _MINUS_ || this.token == _PLUS_) {
                return new DollarExpression_AST(this.UNARY_FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices));
            }
            return new DollarExpression_AST(this.FACTOR(not_in_print_root, allow_in_keyword, allow_multidim_indices));
        }
        return this.SYMBOL(not_in_print_root, allow_in_keyword);
    }

    AST INTEGER_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        boolean parens = this.c == 40;
        this.expectKeyword("_INTEGER");
        if (this.token == _SEMICOLON_ || this.token == _NEWLINE_ || this.token == _CLOSE_BRACE_) {
            throw new ParserException("expression expected");
        }
        if (parens) {
            this.lexer(_OPEN_PAREN_);
        }
        if (this.token == _CLOSE_PAREN_) {
            throw new ParserException("expression expected");
        }
        IntegerExpression_AST int_expr_ast = new IntegerExpression_AST(this.ASSIGNMENT_EXPRESSION(not_in_print_root || parens, allow_in_keyword, allow_multidim_indices));
        if (parens) {
            this.lexer(_CLOSE_PAREN_);
        }
        return int_expr_ast;
    }

    AST DOUBLE_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        boolean parens = this.c == 40;
        this.expectKeyword("_DOUBLE");
        if (this.token == _SEMICOLON_ || this.token == _NEWLINE_ || this.token == _CLOSE_BRACE_) {
            throw new ParserException("expression expected");
        }
        if (parens) {
            this.lexer(_OPEN_PAREN_);
        }
        if (this.token == _CLOSE_PAREN_) {
            throw new ParserException("expression expected");
        }
        DoubleExpression_AST double_expr_ast = new DoubleExpression_AST(this.ASSIGNMENT_EXPRESSION(not_in_print_root || parens, allow_in_keyword, allow_multidim_indices));
        if (parens) {
            this.lexer(_CLOSE_PAREN_);
        }
        return double_expr_ast;
    }

    AST STRING_EXPRESSION(boolean not_in_print_root, boolean allow_in_keyword, boolean allow_multidim_indices) throws IOException {
        boolean parens = this.c == 40;
        this.expectKeyword("_STRING");
        if (this.token == _SEMICOLON_ || this.token == _NEWLINE_ || this.token == _CLOSE_BRACE_) {
            throw new ParserException("expression expected");
        }
        if (parens) {
            this.lexer(_OPEN_PAREN_);
        }
        if (this.token == _CLOSE_PAREN_) {
            throw new ParserException("expression expected");
        }
        StringExpression_AST string_expr_ast = new StringExpression_AST(this.ASSIGNMENT_EXPRESSION(not_in_print_root || parens, allow_in_keyword, allow_multidim_indices));
        if (parens) {
            this.lexer(_CLOSE_PAREN_);
        }
        return string_expr_ast;
    }

    AST SYMBOL(boolean not_in_print_root, boolean allow_in_keyword) throws IOException {
        if (this.token != _ID_ && this.token != _FUNC_ID_ && this.token != _BUILTIN_FUNC_NAME_ && this.token != _EXTENSION_) {
            throw new ParserException("Expecting an ID. Got " + AwkParser.toTokenString(this.token) + ": " + this.text);
        }
        int id_token = this.token;
        String id = this.text.toString();
        boolean parens = this.c == 40;
        this.lexer();
        if (id_token == _EXTENSION_) {
            AST params;
            String extension_keyword = id;
            if (parens) {
                this.lexer();
                params = this.token == _CLOSE_PAREN_ ? null : this.EXPRESSION_LIST(true, allow_in_keyword);
                this.lexer(_CLOSE_PAREN_);
            } else {
                params = null;
            }
            return new Extension_AST(extension_keyword, params);
        }
        if (id_token == _FUNC_ID_ || id_token == _BUILTIN_FUNC_NAME_) {
            AST params;
            if (id.equals("length")) {
                if (this.token == _OPEN_PAREN_) {
                    this.lexer();
                    params = this.token == _CLOSE_PAREN_ ? null : this.EXPRESSION_LIST(true, allow_in_keyword);
                    this.lexer(_CLOSE_PAREN_);
                } else {
                    params = null;
                }
            } else {
                this.lexer(_OPEN_PAREN_);
                params = this.token == _CLOSE_PAREN_ ? null : this.EXPRESSION_LIST(true, allow_in_keyword);
                this.lexer(_CLOSE_PAREN_);
            }
            if (id_token == _BUILTIN_FUNC_NAME_) {
                return new BuiltinFunctionCall_AST(id, params);
            }
            return this.symbol_table.addFunctionCall(id, params);
        }
        if (this.token == _OPEN_BRACKET_) {
            this.lexer();
            AST idx_ast = this.ARRAY_INDEX(true, allow_in_keyword);
            this.lexer(_CLOSE_BRACKET_);
            if (this.token == _OPEN_BRACKET_) {
                throw new ParserException("Use [a,b,c,...] instead of [a][b][c]... for multi-dimensional arrays.");
            }
            return this.symbol_table.addArrayReference(id, idx_ast);
        }
        return this.symbol_table.addID(id);
    }

    AST ARRAY_INDEX(boolean not_in_print_root, boolean allow_in_keyword) throws IOException {
        AST expr_ast = this.ASSIGNMENT_EXPRESSION(not_in_print_root, allow_in_keyword, false);
        if (this.token == _COMMA_) {
            this.opt_newline();
            this.lexer();
            return new ArrayIndex_AST(expr_ast, this.ARRAY_INDEX(not_in_print_root, allow_in_keyword));
        }
        return new ArrayIndex_AST(expr_ast, null);
    }

    AST STATEMENT() throws IOException {
        AST stmt;
        if (this.token == _OPEN_BRACE_) {
            this.lexer();
            AST lst = this.STATEMENT_LIST();
            this.lexer(_CLOSE_BRACE_);
            return lst;
        }
        if (this.token == KEYWORDS.get("if")) {
            stmt = this.IF_STATEMENT();
        } else if (this.token == KEYWORDS.get("while")) {
            stmt = this.WHILE_STATEMENT();
        } else if (this.token == KEYWORDS.get("for")) {
            stmt = this.FOR_STATEMENT();
        } else {
            AST stmt2 = this.token == KEYWORDS.get("do") ? this.DO_STATEMENT() : (this.token == KEYWORDS.get("return") ? this.RETURN_STATEMENT() : (this.token == KEYWORDS.get("exit") ? this.EXIT_STATEMENT() : (this.token == KEYWORDS.get("delete") ? this.DELETE_STATEMENT() : (this.token == KEYWORDS.get("print") ? this.PRINT_STATEMENT() : (this.token == KEYWORDS.get("printf") ? this.PRINTF_STATEMENT() : (this.token == KEYWORDS.get("next") ? this.NEXT_STATEMENT() : (this.token == KEYWORDS.get("continue") ? this.CONTINUE_STATEMENT() : (this.token == KEYWORDS.get("break") ? this.BREAK_STATEMENT() : (this.additional_functions && this.token == KEYWORDS.get("_sleep") ? this.SLEEP_STATEMENT() : (this.additional_functions && this.token == KEYWORDS.get("_dump") ? this.DUMP_STATEMENT() : this.EXPRESSION_STATEMENT(true, false)))))))))));
            this.terminator();
            return stmt2;
        }
        return stmt;
    }

    AST EXPRESSION_STATEMENT(boolean allow_in_keyword, boolean allow_non_statement_asts) throws IOException {
        AST expr_ast = this.ASSIGNMENT_EXPRESSION(true, allow_in_keyword, false);
        if (!allow_non_statement_asts && expr_ast instanceof NonStatement_AST) {
            throw new ParserException("Not a valid statement.");
        }
        return new ExpressionStatement_AST(expr_ast);
    }

    AST IF_STATEMENT() throws IOException {
        AST b1;
        this.expectKeyword("if");
        this.lexer(_OPEN_PAREN_);
        AST expr = this.ASSIGNMENT_EXPRESSION(true, true, false);
        this.lexer(_CLOSE_PAREN_);
        this.opt_newline();
        if (this.token == _SEMICOLON_) {
            this.lexer();
            this.opt_newline();
            b1 = null;
        } else {
            b1 = this.BLOCK_OR_STMT();
        }
        this.opt_newline();
        if (this.token == KEYWORDS.get("else")) {
            this.lexer();
            this.opt_newline();
            AST b2 = this.BLOCK_OR_STMT();
            return new IfStatement_AST(expr, b1, b2);
        }
        IfStatement_AST if_ast = new IfStatement_AST(expr, b1, null);
        return if_ast;
    }

    AST BREAK_STATEMENT() throws IOException {
        this.expectKeyword("break");
        return new BreakStatement_AST();
    }

    AST BLOCK_OR_STMT() throws IOException {
        return this.BLOCK_OR_STMT(false);
    }

    AST BLOCK_OR_STMT(boolean require_terminator) throws IOException {
        this.opt_newline();
        if (this.token == _OPEN_BRACE_) {
            this.lexer();
            AST block = this.STATEMENT_LIST();
            this.lexer(_CLOSE_BRACE_);
            return block;
        }
        AST block = this.token == _SEMICOLON_ ? null : this.STATEMENT();
        if (require_terminator) {
            this.terminator();
        }
        return block;
    }

    AST WHILE_STATEMENT() throws IOException {
        this.expectKeyword("while");
        this.lexer(_OPEN_PAREN_);
        AST expr = this.ASSIGNMENT_EXPRESSION(true, true, false);
        this.lexer(_CLOSE_PAREN_);
        AST block = this.BLOCK_OR_STMT();
        return new WhileStatement_AST(expr, block);
    }

    AST FOR_STATEMENT() throws IOException {
        this.expectKeyword("for");
        AST expr1 = null;
        AST expr2 = null;
        AST expr3 = null;
        this.lexer(_OPEN_PAREN_);
        expr1 = this.OPT_SIMPLE_STATEMENT(false);
        if (this.token == KEYWORDS.get("in")) {
            if (expr1.ast1 == null || expr1.ast2 != null) {
                throw new ParserException("Invalid expression prior to 'in' statement. Got : " + expr1);
            }
            expr1 = expr1.ast1;
            if (expr1 == null || !(expr1 instanceof ID_AST)) {
                throw new ParserException("Expecting an ID for 'in' statement. Got : " + expr1);
            }
            this.lexer();
            if (this.token != _ID_) {
                throw new ParserException("Expecting an ARRAY ID for 'in' statement. Got " + AwkParser.toTokenString(this.token) + ": " + this.text);
            }
            String arr_id = this.text.toString();
            AST array_id_ast = this.symbol_table.addArrayID(arr_id);
            this.lexer();
            this.lexer(_CLOSE_PAREN_);
            AST block = this.BLOCK_OR_STMT();
            return new ForInStatement_AST(expr1, array_id_ast, block);
        }
        if (this.token != _SEMICOLON_) {
            throw new ParserException("Expecting ;. Got " + AwkParser.toTokenString(this.token) + ": " + this.text);
        }
        this.lexer();
        if (this.token != _SEMICOLON_) {
            expr2 = this.ASSIGNMENT_EXPRESSION(true, true, false);
        }
        if (this.token != _SEMICOLON_) {
            throw new ParserException("Expecting ;. Got " + AwkParser.toTokenString(this.token) + ": " + this.text);
        }
        this.lexer();
        if (this.token != _CLOSE_PAREN_) {
            expr3 = this.OPT_SIMPLE_STATEMENT(true);
        }
        this.lexer(_CLOSE_PAREN_);
        AST block = this.BLOCK_OR_STMT();
        return new ForStatement_AST(expr1, expr2, expr3, block);
    }

    AST OPT_SIMPLE_STATEMENT(boolean allow_in_keyword) throws IOException {
        if (this.token == _SEMICOLON_) {
            return null;
        }
        if (this.token == KEYWORDS.get("delete")) {
            return this.DELETE_STATEMENT();
        }
        if (this.token == KEYWORDS.get("print")) {
            return this.PRINT_STATEMENT();
        }
        if (this.token == KEYWORDS.get("printf")) {
            return this.PRINTF_STATEMENT();
        }
        return this.EXPRESSION_STATEMENT(allow_in_keyword, true);
    }

    AST DELETE_STATEMENT() throws IOException {
        boolean parens = this.c == 40;
        this.expectKeyword("delete");
        if (parens) {
            assert (this.token == _OPEN_PAREN_);
            this.lexer();
        }
        AST symbol_ast = this.SYMBOL(true, true);
        if (parens) {
            this.lexer(_CLOSE_PAREN_);
        }
        return new DeleteStatement_AST(symbol_ast);
    }

    private ParsedPrintStatement parsePrintStatement(boolean parens) throws IOException {
        AST output_expr;
        int output_token;
        AST func_params;
        if (parens) {
            this.lexer();
            func_params = this.token == _CLOSE_PAREN_ ? null : this.EXPRESSION_LIST(true, true);
            this.lexer(_CLOSE_PAREN_);
        } else {
            func_params = this.token == _NEWLINE_ || this.token == _SEMICOLON_ || this.token == _CLOSE_BRACE_ || this.token == _CLOSE_PAREN_ || this.token == _GT_ || this.token == _APPEND_ || this.token == _PIPE_ ? null : this.EXPRESSION_LIST(false, true);
        }
        if (this.token == _GT_ || this.token == _APPEND_ || this.token == _PIPE_) {
            output_token = this.token;
            this.lexer();
            output_expr = this.ASSIGNMENT_EXPRESSION(true, true, false);
        } else {
            output_token = -1;
            output_expr = null;
        }
        return new ParsedPrintStatement(func_params, output_token, output_expr);
    }

    AST PRINT_STATEMENT() throws IOException {
        boolean parens = this.c == 40;
        this.expectKeyword("print");
        ParsedPrintStatement parsedPrintStatement = this.parsePrintStatement(parens);
        return new Print_AST(parsedPrintStatement.getFuncParams(), parsedPrintStatement.getOutputToken(), parsedPrintStatement.getOutputExpr());
    }

    AST PRINTF_STATEMENT() throws IOException {
        boolean parens = this.c == 40;
        this.expectKeyword("printf");
        ParsedPrintStatement parsedPrintStatement = this.parsePrintStatement(parens);
        return new Printf_AST(parsedPrintStatement.getFuncParams(), parsedPrintStatement.getOutputToken(), parsedPrintStatement.getOutputExpr());
    }

    AST GETLINE_EXPRESSION(AST pipe_expr, boolean not_in_print_root, boolean allow_in_keyword) throws IOException {
        this.expectKeyword("getline");
        AST lvalue = this.LVALUE(not_in_print_root, allow_in_keyword);
        if (this.token == _LT_) {
            this.lexer();
            AST assignment_expr = this.ASSIGNMENT_EXPRESSION(not_in_print_root, allow_in_keyword, false);
            if (pipe_expr != null) {
                throw new ParserException("Cannot have both pipe expression and redirect into a getline.");
            }
            return new Getline_AST(pipe_expr, lvalue, assignment_expr);
        }
        return new Getline_AST(pipe_expr, lvalue, null);
    }

    AST LVALUE(boolean not_in_print_root, boolean allow_in_keyword) throws IOException {
        if (this.token == _DOLLAR_) {
            return this.FACTOR(not_in_print_root, allow_in_keyword, false);
        }
        if (this.token == _ID_) {
            return this.FACTOR(not_in_print_root, allow_in_keyword, false);
        }
        return null;
    }

    AST DO_STATEMENT() throws IOException {
        this.expectKeyword("do");
        this.opt_newline();
        AST block = this.BLOCK_OR_STMT();
        if (this.token == _SEMICOLON_) {
            this.lexer();
        }
        this.opt_newline();
        this.expectKeyword("while");
        this.lexer(_OPEN_PAREN_);
        AST expr = this.ASSIGNMENT_EXPRESSION(true, true, false);
        this.lexer(_CLOSE_PAREN_);
        return new DoStatement_AST(block, expr);
    }

    AST RETURN_STATEMENT() throws IOException {
        this.expectKeyword("return");
        if (this.token == _SEMICOLON_ || this.token == _NEWLINE_ || this.token == _CLOSE_BRACE_) {
            return new ReturnStatement_AST(null);
        }
        return new ReturnStatement_AST(this.ASSIGNMENT_EXPRESSION(true, true, false));
    }

    AST EXIT_STATEMENT() throws IOException {
        this.expectKeyword("exit");
        if (this.token == _SEMICOLON_ || this.token == _NEWLINE_ || this.token == _CLOSE_BRACE_) {
            return new ExitStatement_AST(null);
        }
        return new ExitStatement_AST(this.ASSIGNMENT_EXPRESSION(true, true, false));
    }

    AST SLEEP_STATEMENT() throws IOException {
        boolean parens = this.c == 40;
        this.expectKeyword("_sleep");
        if (this.token == _SEMICOLON_ || this.token == _NEWLINE_ || this.token == _CLOSE_BRACE_) {
            return new SleepStatement_AST(null);
        }
        if (parens) {
            this.lexer();
        }
        SleepStatement_AST sleep_ast = this.token == _CLOSE_PAREN_ ? new SleepStatement_AST(null) : new SleepStatement_AST(this.ASSIGNMENT_EXPRESSION(true, true, false));
        if (parens) {
            this.lexer(_CLOSE_PAREN_);
        }
        return sleep_ast;
    }

    AST DUMP_STATEMENT() throws IOException {
        boolean parens = this.c == 40;
        this.expectKeyword("_dump");
        if (this.token == _SEMICOLON_ || this.token == _NEWLINE_ || this.token == _CLOSE_BRACE_) {
            return new DumpStatement_AST(null);
        }
        if (parens) {
            this.lexer();
        }
        DumpStatement_AST dump_ast = this.token == _CLOSE_PAREN_ ? new DumpStatement_AST(null) : new DumpStatement_AST(this.EXPRESSION_LIST(true, true));
        if (parens) {
            this.lexer(_CLOSE_PAREN_);
        }
        return dump_ast;
    }

    AST NEXT_STATEMENT() throws IOException {
        this.expectKeyword("next");
        return new NextStatement_AST();
    }

    AST CONTINUE_STATEMENT() throws IOException {
        this.expectKeyword("continue");
        return new ContinueStatement_AST();
    }

    private void expectKeyword(String keyword) throws IOException {
        if (this.token != KEYWORDS.get(keyword)) {
            throw new ParserException("Expecting " + keyword + ". Got " + AwkParser.toTokenString(this.token) + ": " + this.text);
        }
        this.lexer();
    }

    private static boolean isRule(AST ast) {
        return ast != null && !ast.isBegin() && !ast.isEnd() && !ast.isFunction();
    }

    private static boolean isExtensionConditionRule(AST ast) {
        if (!AwkParser.isRule(ast)) {
            return false;
        }
        if (ast.ast1 == null) {
            return false;
        }
        if (!AwkParser.containsASTType(ast.ast1, Extension_AST.class)) {
            return false;
        }
        return !AwkParser.containsASTType(ast.ast1, new Class[]{FunctionCall_AST.class, DollarExpression_AST.class});
    }

    private static boolean containsASTType(AST ast, Class<?> cls) {
        return AwkParser.containsASTType(ast, new Class[]{cls});
    }

    private static boolean containsASTType(AST ast, Class<?>[] cls_array) {
        if (ast == null) {
            return false;
        }
        for (Class<?> cls : cls_array) {
            if (!cls.isInstance(ast)) continue;
            return true;
        }
        return AwkParser.containsASTType(ast.ast1, cls_array) || AwkParser.containsASTType(ast.ast2, cls_array) || AwkParser.containsASTType(ast.ast3, cls_array) || AwkParser.containsASTType(ast.ast4, cls_array);
    }

    public void populateGlobalVariableNameToOffsetMappings(AwkTuples tuples) {
        for (String varname : this.symbol_table.global_ids.keySet()) {
            ID_AST id_ast = (ID_AST)this.symbol_table.global_ids.get(varname);
            tuples.addGlobalVariableNameToOffsetMapping(varname, id_ast.offset, id_ast.is_array);
        }
        tuples.setFunctionNameSet(this.symbol_table.function_proxies.keySet());
    }

    static {
        KEYWORDS.put("function", s_idx++);
        KEYWORDS.put("BEGIN", s_idx++);
        KEYWORDS.put("END", s_idx++);
        KEYWORDS.put("in", s_idx++);
        KEYWORDS.put("if", s_idx++);
        KEYWORDS.put("else", s_idx++);
        KEYWORDS.put("while", s_idx++);
        KEYWORDS.put("for", s_idx++);
        KEYWORDS.put("do", s_idx++);
        KEYWORDS.put("return", s_idx++);
        KEYWORDS.put("exit", s_idx++);
        KEYWORDS.put("next", s_idx++);
        KEYWORDS.put("continue", s_idx++);
        KEYWORDS.put("delete", s_idx++);
        KEYWORDS.put("break", s_idx++);
        KEYWORDS.put("print", s_idx++);
        KEYWORDS.put("printf", s_idx++);
        KEYWORDS.put("getline", s_idx++);
        f_idx = 257;
        BUILTIN_FUNC_NAMES = new HashMap<String, Integer>();
        BUILTIN_FUNC_NAMES.put("atan2", f_idx++);
        BUILTIN_FUNC_NAMES.put("close", f_idx++);
        BUILTIN_FUNC_NAMES.put("cos", f_idx++);
        BUILTIN_FUNC_NAMES.put("exp", f_idx++);
        BUILTIN_FUNC_NAMES.put("index", f_idx++);
        BUILTIN_FUNC_NAMES.put("int", f_idx++);
        BUILTIN_FUNC_NAMES.put("length", f_idx++);
        BUILTIN_FUNC_NAMES.put("log", f_idx++);
        BUILTIN_FUNC_NAMES.put("match", f_idx++);
        BUILTIN_FUNC_NAMES.put("rand", f_idx++);
        BUILTIN_FUNC_NAMES.put("sin", f_idx++);
        BUILTIN_FUNC_NAMES.put("split", f_idx++);
        BUILTIN_FUNC_NAMES.put("sprintf", f_idx++);
        BUILTIN_FUNC_NAMES.put("sqrt", f_idx++);
        BUILTIN_FUNC_NAMES.put("srand", f_idx++);
        BUILTIN_FUNC_NAMES.put("sub", f_idx++);
        BUILTIN_FUNC_NAMES.put("gsub", f_idx++);
        BUILTIN_FUNC_NAMES.put("substr", f_idx++);
        BUILTIN_FUNC_NAMES.put("system", f_idx++);
        BUILTIN_FUNC_NAMES.put("tolower", f_idx++);
        BUILTIN_FUNC_NAMES.put("toupper", f_idx++);
        SPECIAL_VAR_NAMES = new HashMap<String, Integer>();
        SPECIAL_VAR_NAMES.put("NR", 257);
        SPECIAL_VAR_NAMES.put("FNR", 257);
        SPECIAL_VAR_NAMES.put("NF", 257);
        SPECIAL_VAR_NAMES.put("FS", 257);
        SPECIAL_VAR_NAMES.put("RS", 257);
        SPECIAL_VAR_NAMES.put("OFS", 257);
        SPECIAL_VAR_NAMES.put("ORS", 257);
        SPECIAL_VAR_NAMES.put("RSTART", 257);
        SPECIAL_VAR_NAMES.put("RLENGTH", 257);
        SPECIAL_VAR_NAMES.put("FILENAME", 257);
        SPECIAL_VAR_NAMES.put("SUBSEP", 257);
        SPECIAL_VAR_NAMES.put("CONVFMT", 257);
        SPECIAL_VAR_NAMES.put("OFMT", 257);
        SPECIAL_VAR_NAMES.put("ENVIRON", 257);
        SPECIAL_VAR_NAMES.put("ARGC", 257);
        SPECIAL_VAR_NAMES.put("ARGV", 257);
    }

    private abstract class AST
    implements AwkSyntaxTree {
        private final String sourceDescription;
        private final int lineNo;
        protected AST parent;
        protected AST ast1;
        protected AST ast2;
        protected AST ast3;
        protected AST ast4;
        protected boolean is_begin;
        protected boolean is_end;
        protected boolean is_function;

        protected final AST searchFor(Class<?> cls) {
            AST ptr = this;
            while (ptr != null) {
                if (cls.isInstance(ptr)) {
                    return ptr;
                }
                ptr = ptr.parent;
            }
            return null;
        }

        protected AST() {
            this.sourceDescription = ((ScriptSource)AwkParser.this.scriptSources.get(AwkParser.this.scriptSourcesCurrentIndex)).getDescription();
            this.lineNo = AwkParser.this.reader.getLineNumber() + 1;
            this.is_begin = this.isBegin();
            this.is_end = this.isEnd();
            this.is_function = this.isFunction();
        }

        protected AST(AST ast1) {
            this.sourceDescription = ((ScriptSource)AwkParser.this.scriptSources.get(AwkParser.this.scriptSourcesCurrentIndex)).getDescription();
            this.lineNo = AwkParser.this.reader.getLineNumber() + 1;
            this.is_begin = this.isBegin();
            this.is_end = this.isEnd();
            this.is_function = this.isFunction();
            this.ast1 = ast1;
            if (ast1 != null) {
                ast1.parent = this;
            }
        }

        protected AST(AST ast1, AST ast2) {
            this.sourceDescription = ((ScriptSource)AwkParser.this.scriptSources.get(AwkParser.this.scriptSourcesCurrentIndex)).getDescription();
            this.lineNo = AwkParser.this.reader.getLineNumber() + 1;
            this.is_begin = this.isBegin();
            this.is_end = this.isEnd();
            this.is_function = this.isFunction();
            this.ast1 = ast1;
            this.ast2 = ast2;
            if (ast1 != null) {
                ast1.parent = this;
            }
            if (ast2 != null) {
                ast2.parent = this;
            }
        }

        protected AST(AST ast1, AST ast2, AST ast3) {
            this.sourceDescription = ((ScriptSource)AwkParser.this.scriptSources.get(AwkParser.this.scriptSourcesCurrentIndex)).getDescription();
            this.lineNo = AwkParser.this.reader.getLineNumber() + 1;
            this.is_begin = this.isBegin();
            this.is_end = this.isEnd();
            this.is_function = this.isFunction();
            this.ast1 = ast1;
            this.ast2 = ast2;
            this.ast3 = ast3;
            if (ast1 != null) {
                ast1.parent = this;
            }
            if (ast2 != null) {
                ast2.parent = this;
            }
            if (ast3 != null) {
                ast3.parent = this;
            }
        }

        protected AST(AST ast1, AST ast2, AST ast3, AST ast4) {
            this.sourceDescription = ((ScriptSource)AwkParser.this.scriptSources.get(AwkParser.this.scriptSourcesCurrentIndex)).getDescription();
            this.lineNo = AwkParser.this.reader.getLineNumber() + 1;
            this.is_begin = this.isBegin();
            this.is_end = this.isEnd();
            this.is_function = this.isFunction();
            this.ast1 = ast1;
            this.ast2 = ast2;
            this.ast3 = ast3;
            this.ast4 = ast4;
            if (ast1 != null) {
                ast1.parent = this;
            }
            if (ast2 != null) {
                ast2.parent = this;
            }
            if (ast3 != null) {
                ast3.parent = this;
            }
            if (ast4 != null) {
                ast4.parent = this;
            }
        }

        @Override
        public void dump(PrintStream ps) {
            this.dump(ps, 0);
        }

        private void dump(PrintStream ps, int lvl) {
            StringBuffer spaces = new StringBuffer();
            for (int i = 0; i < lvl; ++i) {
                spaces.append(' ');
            }
            ps.println(spaces + this.toString());
            if (this.ast1 != null) {
                this.ast1.dump(ps, lvl + 1);
            }
            if (this.ast2 != null) {
                this.ast2.dump(ps, lvl + 1);
            }
            if (this.ast3 != null) {
                this.ast3.dump(ps, lvl + 1);
            }
            if (this.ast4 != null) {
                this.ast4.dump(ps, lvl + 1);
            }
        }

        @Override
        public void semanticAnalysis() {
            if (this.ast1 != null) {
                this.ast1.semanticAnalysis();
            }
            if (this.ast2 != null) {
                this.ast2.semanticAnalysis();
            }
            if (this.ast3 != null) {
                this.ast3.semanticAnalysis();
            }
            if (this.ast4 != null) {
                this.ast4.semanticAnalysis();
            }
        }

        @Override
        public abstract int populateTuples(AwkTuples var1);

        protected final void pushSourceLineNumber(AwkTuples tuples) {
            tuples.pushSourceLineNumber(this.lineNo);
        }

        protected final void popSourceLineNumber(AwkTuples tuples) {
            tuples.popSourceLineNumber(this.lineNo);
        }

        private boolean isBegin() {
            boolean result = this.is_begin;
            if (!result && this.ast1 != null) {
                result = this.ast1.isBegin();
            }
            if (!result && this.ast2 != null) {
                result = this.ast2.isBegin();
            }
            if (!result && this.ast3 != null) {
                result = this.ast3.isBegin();
            }
            if (!result && this.ast4 != null) {
                result = this.ast4.isBegin();
            }
            return result;
        }

        private boolean isEnd() {
            boolean result = this.is_end;
            if (!result && this.ast1 != null) {
                result = this.ast1.isEnd();
            }
            if (!result && this.ast2 != null) {
                result = this.ast2.isEnd();
            }
            if (!result && this.ast3 != null) {
                result = this.ast3.isEnd();
            }
            if (!result && this.ast4 != null) {
                result = this.ast4.isEnd();
            }
            return result;
        }

        private boolean isFunction() {
            boolean result = this.is_function;
            if (!result && this.ast1 != null) {
                result = this.ast1.isFunction();
            }
            if (!result && this.ast2 != null) {
                result = this.ast2.isFunction();
            }
            if (!result && this.ast3 != null) {
                result = this.ast3.isFunction();
            }
            if (!result && this.ast4 != null) {
                result = this.ast4.isFunction();
            }
            return result;
        }

        public boolean isArray() {
            return false;
        }

        public boolean isScalar() {
            return false;
        }

        protected final void throwSemanticException(String msg) {
            throw new SemanticException(msg);
        }

        public String toString() {
            return this.getClass().getName().replaceFirst(".*[$.]", "");
        }

        protected class SemanticException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            SemanticException(String msg) {
                super(msg + " (" + AST.this.sourceDescription + ":" + AST.this.lineNo + ")");
            }
        }
    }

    private class AwkSymbolTableImpl {
        private Begin_AST begin_ast = null;
        private End_AST end_ast = null;
        private Map<String, FunctionProxy> function_proxies = new HashMap<String, FunctionProxy>();
        private Map<String, ID_AST> global_ids = new HashMap<String, ID_AST>();
        private Map<String, Map<String, ID_AST>> local_ids = new HashMap<String, Map<String, ID_AST>>();
        private Map<String, Set<String>> function_parameters = new HashMap<String, Set<String>>();
        private Set<String> ids = new HashSet<String>();
        private String func_name = null;

        private AwkSymbolTableImpl() {
        }

        int numGlobals() {
            return this.global_ids.size();
        }

        void setFunctionName(String func_name) {
            assert (this.func_name == null);
            this.func_name = func_name;
        }

        void clearFunctionName(String func_name) {
            assert (this.func_name != null && this.func_name.length() > 0);
            assert (this.func_name.equals(func_name));
            this.func_name = null;
        }

        AST addBEGIN() {
            if (this.begin_ast == null) {
                this.begin_ast = new Begin_AST();
            }
            return this.begin_ast;
        }

        AST addEND() {
            if (this.end_ast == null) {
                this.end_ast = new End_AST();
            }
            return this.end_ast;
        }

        private ID_AST getID(String id) {
            Map<String, ID_AST> map;
            if (this.function_proxies.get(id) != null) {
                throw new ParserException("cannot use " + id + " as a variable; it is a function");
            }
            this.ids.add(id);
            if (this.func_name == null) {
                map = this.global_ids;
            } else {
                Set<String> set = this.function_parameters.get(this.func_name);
                if (set != null && set.contains(id)) {
                    map = this.local_ids.get(this.func_name);
                    if (map == null) {
                        map = new HashMap<String, ID_AST>();
                        this.local_ids.put(this.func_name, map);
                    }
                } else {
                    map = this.global_ids;
                }
            }
            assert (map != null);
            ID_AST id_ast = map.get(id);
            if (id_ast == null) {
                id_ast = new ID_AST(id, map == this.global_ids);
                id_ast.offset = map.size();
                assert (id_ast.offset != -1);
                map.put(id, id_ast);
            }
            return id_ast;
        }

        AST addID(String id) throws ParserException {
            ID_AST ret_val = this.getID(id);
            return ret_val;
        }

        int addFunctionParameter(String func_name, String id) {
            Set<String> set = this.function_parameters.get(func_name);
            if (set == null) {
                set = new HashSet<String>();
                this.function_parameters.put(func_name, set);
            }
            if (set.contains(id)) {
                throw new ParserException("multiply defined parameter " + id + " in function " + func_name);
            }
            int retval = set.size();
            set.add(id);
            Map<String, ID_AST> map = this.local_ids.get(func_name);
            if (map == null) {
                map = new HashMap<String, ID_AST>();
                this.local_ids.put(func_name, map);
            }
            assert (map != null);
            ID_AST id_ast = map.get(id);
            if (id_ast == null) {
                id_ast = new ID_AST(id, map == this.global_ids);
                id_ast.offset = map.size();
                assert (id_ast.offset != -1);
                map.put(id, id_ast);
            }
            return retval;
        }

        ID_AST getFunctionParameterIDAST(String func_name, String f_id_string) {
            return this.local_ids.get(func_name).get(f_id_string);
        }

        AST addArrayID(String id) throws ParserException {
            ID_AST ret_val = this.getID(id);
            if (ret_val.isScalar()) {
                throw new ParserException("Cannot use " + ret_val + " as an array.");
            }
            ret_val.setArray(true);
            return ret_val;
        }

        AST addFunctionDef(String func_name, AST param_list, AST block) {
            if (this.ids.contains(func_name)) {
                throw new ParserException("cannot use " + func_name + " as a function; it is a variable");
            }
            FunctionProxy function_proxy = this.function_proxies.get(func_name);
            if (function_proxy == null) {
                function_proxy = new FunctionProxy(func_name);
                this.function_proxies.put(func_name, function_proxy);
            }
            FunctionDef_AST function_def = new FunctionDef_AST(func_name, param_list, block);
            function_proxy.setFunctionDefinition(function_def);
            return function_def;
        }

        AST addFunctionCall(String id, AST param_list) {
            FunctionProxy function_proxy = this.function_proxies.get(id);
            if (function_proxy == null) {
                function_proxy = new FunctionProxy(id);
                this.function_proxies.put(id, function_proxy);
            }
            return new FunctionCall_AST(function_proxy, param_list);
        }

        AST addArrayReference(String id, AST idx_ast) throws ParserException {
            return new ArrayReference_AST(this.addArrayID(id), idx_ast);
        }

        AST addINTEGER(String integer) {
            return new Integer_AST(Long.parseLong(integer));
        }

        AST addDOUBLE(String dbl) {
            return new Double_AST(Double.valueOf(dbl));
        }

        AST addSTRING(String str) {
            return new String_AST(str);
        }

        AST addREGEXP(String regexp) {
            return new Regexp_AST(regexp);
        }
    }

    public class LexerException
    extends IOException {
        private static final long serialVersionUID = 1L;

        LexerException(String msg) {
            super(msg + " (" + ((ScriptSource)AwkParser.this.scriptSources.get(AwkParser.this.scriptSourcesCurrentIndex)).getDescription() + ":" + AwkParser.this.reader.getLineNumber() + ")");
        }
    }

    public class ParserException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        ParserException(String msg) {
            super(msg + " (" + ((ScriptSource)AwkParser.this.scriptSources.get(AwkParser.this.scriptSourcesCurrentIndex)).getDescription() + ":" + AwkParser.this.reader.getLineNumber() + ")");
        }
    }

    private final class RuleList_AST
    extends AST {
        private RuleList_AST(AST rule, AST rest) {
            super(rule, rest);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            AwkParser.this.next_address = tuples.createAddress("next_address");
            Address exit_addr = tuples.createAddress("end blocks start address");
            Address start_address = tuples.createAddress("start address");
            tuples.setExitAddress(exit_addr);
            tuples.gotoAddress(start_address);
            AST ptr = this;
            while (ptr != null) {
                if (ptr.ast1 != null && ptr.ast1.isFunction()) {
                    assert (ptr.ast1 != null);
                    int ast1_count = ptr.ast1.populateTuples(tuples);
                    assert (ast1_count == 0);
                }
                ptr = ptr.ast2;
            }
            tuples.address(start_address);
            ID_AST nr_ast = AwkParser.this.symbol_table.getID("NR");
            ID_AST fnr_ast = AwkParser.this.symbol_table.getID("FNR");
            ID_AST nf_ast = AwkParser.this.symbol_table.getID("NF");
            ID_AST fs_ast = AwkParser.this.symbol_table.getID("FS");
            ID_AST rs_ast = AwkParser.this.symbol_table.getID("RS");
            ID_AST ofs_ast = AwkParser.this.symbol_table.getID("OFS");
            ID_AST ors_ast = AwkParser.this.symbol_table.getID("ORS");
            ID_AST rstart_ast = AwkParser.this.symbol_table.getID("RSTART");
            ID_AST rlength_ast = AwkParser.this.symbol_table.getID("RLENGTH");
            ID_AST filename_ast = AwkParser.this.symbol_table.getID("FILENAME");
            ID_AST subsep_ast = AwkParser.this.symbol_table.getID("SUBSEP");
            ID_AST convfmt_ast = AwkParser.this.symbol_table.getID("CONVFMT");
            ID_AST ofmt_ast = AwkParser.this.symbol_table.getID("OFMT");
            ID_AST environ_ast = AwkParser.this.symbol_table.getID("ENVIRON");
            ID_AST argc_ast = AwkParser.this.symbol_table.getID("ARGC");
            ID_AST argv_ast = AwkParser.this.symbol_table.getID("ARGV");
            tuples.setNumGlobals(AwkParser.this.symbol_table.numGlobals());
            tuples.nfOffset(nf_ast.offset);
            tuples.nrOffset(nr_ast.offset);
            tuples.fnrOffset(fnr_ast.offset);
            tuples.fsOffset(fs_ast.offset);
            tuples.rsOffset(rs_ast.offset);
            tuples.ofsOffset(ofs_ast.offset);
            tuples.orsOffset(ors_ast.offset);
            tuples.rstartOffset(rstart_ast.offset);
            tuples.rlengthOffset(rlength_ast.offset);
            tuples.filenameOffset(filename_ast.offset);
            tuples.subsepOffset(subsep_ast.offset);
            tuples.convfmtOffset(convfmt_ast.offset);
            tuples.ofmtOffset(ofmt_ast.offset);
            tuples.environOffset(environ_ast.offset);
            tuples.argcOffset(argc_ast.offset);
            tuples.argvOffset(argv_ast.offset);
            ptr = this;
            while (ptr != null) {
                if (ptr.ast1 != null && ptr.ast1.isBegin()) {
                    ptr.ast1.populateTuples(tuples);
                }
                ptr = ptr.ast2;
            }
            boolean req_input = false;
            ptr = this;
            while (!req_input && ptr != null) {
                if (AwkParser.isRule(ptr.ast1)) {
                    req_input = true;
                }
                ptr = ptr.ast2;
            }
            ptr = this;
            while (!req_input && ptr != null) {
                if (ptr.ast1 != null && ptr.ast1.isEnd()) {
                    req_input = true;
                }
                ptr = ptr.ast2;
            }
            if (req_input) {
                Address input_loop_address = null;
                Address no_more_input = null;
                input_loop_address = tuples.createAddress("input_loop_address");
                tuples.address(input_loop_address);
                ptr = this;
                no_more_input = tuples.createAddress("no_more_input");
                tuples.consumeInput(no_more_input);
                while (ptr != null) {
                    if (AwkParser.isRule(ptr.ast1)) {
                        ptr.ast1.populateTuples(tuples);
                    }
                    ptr = ptr.ast2;
                }
                tuples.address(AwkParser.this.next_address);
                tuples.gotoAddress(input_loop_address);
                if (req_input) {
                    tuples.address(no_more_input);
                    tuples.nop();
                }
            }
            tuples.address(exit_addr);
            tuples.setWithinEndBlocks(true);
            ptr = this;
            while (ptr != null) {
                if (ptr.ast1 != null && ptr.ast1.isEnd()) {
                    ptr.ast1.populateTuples(tuples);
                }
                ptr = ptr.ast2;
            }
            tuples.nop();
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class FunctionDefParamList_AST
    extends AST {
        private String id;

        private FunctionDefParamList_AST(String id, int offset, AST rest) {
            super(rest);
            this.id = id;
        }

        @Override
        public final int populateTuples(AwkTuples tuples) {
            throw new Error("Cannot 'execute' function definition parameter list (formal parameters) in this manner.");
        }

        @Override
        public void semanticAnalysis() throws AST.SemanticException {
            FunctionDefParamList_AST ptr = this;
            while (ptr != null) {
                if (SPECIAL_VAR_NAMES.get(ptr.id) != null) {
                    throw new AST.SemanticException("Special variable " + ptr.id + " cannot be used as a formal parameter");
                }
                ptr = (FunctionDefParamList_AST)ptr.ast1;
            }
        }
    }

    private final class ConditionPair_AST
    extends ScalarExpression_AST {
        private ConditionPair_AST(AST boolean_ast_1, AST boolean_ast_2) {
            super(boolean_ast_1, boolean_ast_2);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            assert (this.ast2 != null);
            int ast2_result = this.ast2.populateTuples(tuples);
            assert (ast2_result == 1);
            tuples.conditionPair();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class Rule_AST
    extends AST
    implements Nextable {
        private Rule_AST(AST opt_expression, AST opt_rule) {
            super(opt_expression, opt_rule);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            if (this.ast1 == null) {
                tuples.push(1);
            } else {
                int result = this.ast1.populateTuples(tuples);
                assert (result == 1);
            }
            Address bypass_rule = tuples.createAddress("bypass_rule");
            tuples.ifFalse(bypass_rule);
            if (this.ast2 == null) {
                if (this.ast1 == null || !this.ast1.isBegin() && !this.ast1.isEnd()) {
                    tuples.print(0);
                }
            } else {
                int ast2_count = this.ast2.populateTuples(tuples);
                assert (ast2_count == 0);
            }
            tuples.address(bypass_rule).nop();
            this.popSourceLineNumber(tuples);
            return 0;
        }

        @Override
        public Address nextAddress() {
            if (!AwkParser.isRule(this)) {
                throw new AST.SemanticException("Must call next within an input rule.");
            }
            if (AwkParser.this.next_address == null) {
                throw new AST.SemanticException("Cannot call next here.");
            }
            return AwkParser.this.next_address;
        }
    }

    private final class STATEMENTLIST_AST
    extends AST {
        private STATEMENTLIST_AST(AST statement_ast, AST rest) {
            super(statement_ast, rest);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int ast1_count = this.ast1.populateTuples(tuples);
            assert (ast1_count == 0);
            if (this.ast2 != null) {
                int ast2_count = this.ast2.populateTuples(tuples);
                assert (ast2_count == 0);
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }

        @Override
        public String toString() {
            return super.toString() + " <" + this.ast1 + ">";
        }
    }

    private final class FunctionCallParamList_AST
    extends AST {
        private FunctionCallParamList_AST(AST expr, AST rest) {
            super(expr, rest);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int retval = this.ast2 == null ? this.ast1.populateTuples(tuples) : this.ast1.populateTuples(tuples) + this.ast2.populateTuples(tuples);
            this.popSourceLineNumber(tuples);
            return retval;
        }
    }

    private final class AssignmentExpression_AST
    extends ScalarExpression_AST {
        private int op;
        private String text;

        private AssignmentExpression_AST(AST lhs, int op, String text, AST rhs) {
            super(lhs, rhs);
            this.op = op;
            this.text = text;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.op + "/" + this.text + ")";
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast2 != null);
            int ast2_count = this.ast2.populateTuples(tuples);
            assert (ast2_count == 1);
            if (this.ast1 instanceof ID_AST) {
                ID_AST id_ast = (ID_AST)this.ast1;
                if (id_ast.isArray()) {
                    throw new AST.SemanticException("Cannot use " + id_ast + " as a scalar. It is an array.");
                }
                id_ast.setScalar(true);
                if (this.op == _EQUALS_) {
                    tuples.assign(id_ast.offset, id_ast.is_global);
                } else if (this.op == _PLUS_EQ_) {
                    tuples.plusEq(id_ast.offset, id_ast.is_global);
                } else if (this.op == _MINUS_EQ_) {
                    tuples.minusEq(id_ast.offset, id_ast.is_global);
                } else if (this.op == _MULT_EQ_) {
                    tuples.multEq(id_ast.offset, id_ast.is_global);
                } else if (this.op == _DIV_EQ_) {
                    tuples.divEq(id_ast.offset, id_ast.is_global);
                } else if (this.op == _MOD_EQ_) {
                    tuples.modEq(id_ast.offset, id_ast.is_global);
                } else {
                    if (this.op != _POW_EQ_) throw new Error("Unhandled op: " + this.op + " / " + this.text);
                    tuples.powEq(id_ast.offset, id_ast.is_global);
                }
                if (id_ast.id.equals("RS")) {
                    tuples.applyRS();
                }
            } else if (this.ast1 instanceof ArrayReference_AST) {
                ArrayReference_AST arr = (ArrayReference_AST)this.ast1;
                assert (arr.ast2 != null);
                int arr_ast2_result = arr.ast2.populateTuples(tuples);
                assert (arr_ast2_result == 1);
                ID_AST id_ast = (ID_AST)arr.ast1;
                if (id_ast.isScalar()) {
                    throw new AST.SemanticException("Cannot use " + id_ast + " as an array. It is a scalar.");
                }
                id_ast.setArray(true);
                if (this.op == _EQUALS_) {
                    tuples.assignArray(id_ast.offset, id_ast.is_global);
                } else if (this.op == _PLUS_EQ_) {
                    tuples.plusEqArray(id_ast.offset, id_ast.is_global);
                } else if (this.op == _MINUS_EQ_) {
                    tuples.minusEqArray(id_ast.offset, id_ast.is_global);
                } else if (this.op == _MULT_EQ_) {
                    tuples.multEqArray(id_ast.offset, id_ast.is_global);
                } else if (this.op == _DIV_EQ_) {
                    tuples.divEqArray(id_ast.offset, id_ast.is_global);
                } else if (this.op == _MOD_EQ_) {
                    tuples.modEqArray(id_ast.offset, id_ast.is_global);
                } else {
                    if (this.op != _POW_EQ_) throw new NotImplementedError("Unhandled op: " + this.op + " / " + this.text + " for arrays.");
                    tuples.powEqArray(id_ast.offset, id_ast.is_global);
                }
            } else {
                if (!(this.ast1 instanceof DollarExpression_AST)) throw new AST.SemanticException("Cannot perform an assignment on: " + this.ast1);
                DollarExpression_AST dollar_expr = (DollarExpression_AST)this.ast1;
                assert (dollar_expr.ast1 != null);
                int ast1_result = dollar_expr.ast1.populateTuples(tuples);
                assert (ast1_result == 1);
                if (this.op == _EQUALS_) {
                    tuples.assignAsInputField();
                } else if (this.op == _PLUS_EQ_) {
                    tuples.plusEqInputField();
                } else if (this.op == _MINUS_EQ_) {
                    tuples.minusEqInputField();
                } else if (this.op == _MULT_EQ_) {
                    tuples.multEqInputField();
                } else if (this.op == _DIV_EQ_) {
                    tuples.divEqInputField();
                } else if (this.op == _MOD_EQ_) {
                    tuples.modEqInputField();
                } else {
                    if (this.op != _POW_EQ_) throw new NotImplementedError("Unhandled op: " + this.op + " / " + this.text + " for dollar expressions.");
                    tuples.powEqInputField();
                }
            }
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class ArrayIndex_AST
    extends ScalarExpression_AST {
        private ArrayIndex_AST(AST expr_ast, AST next) {
            super(expr_ast, next);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            AST ptr = this;
            int cnt = 0;
            while (ptr != null) {
                assert (ptr.ast1 != null);
                int ptr_ast1_result = ptr.ast1.populateTuples(tuples);
                assert (ptr_ast1_result == 1);
                ++cnt;
                ptr = ptr.ast2;
            }
            assert (cnt >= 1);
            if (cnt > 1) {
                tuples.applySubsep(cnt);
            }
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class TernaryExpression_AST
    extends ScalarExpression_AST {
        private TernaryExpression_AST(AST a1, AST a2, AST a3) {
            super(a1, a2, a3);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            assert (this.ast2 != null);
            assert (this.ast3 != null);
            Address elseexpr = tuples.createAddress("elseexpr");
            Address end_tertiary = tuples.createAddress("end_tertiary");
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.ifFalse(elseexpr);
            int ast2_result = this.ast2.populateTuples(tuples);
            assert (ast2_result == 1);
            tuples.gotoAddress(end_tertiary);
            tuples.address(elseexpr);
            int ast3_result = this.ast3.populateTuples(tuples);
            assert (ast3_result == 1);
            tuples.address(end_tertiary);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class LogicalExpression_AST
    extends ScalarExpression_AST {
        private int op;
        private String text;

        private LogicalExpression_AST(AST lhs, int op, String text, AST rhs) {
            super(lhs, rhs);
            this.op = op;
            this.text = text;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.op + "/" + this.text + ")";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            Address end = tuples.createAddress("end");
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.dup();
            if (this.op == _OR_) {
                tuples.ifTrue(end);
            } else if (this.op == _AND_) {
                tuples.ifFalse(end);
            } else assert (false) : "Invalid op: " + this.op + " / " + this.text;
            tuples.pop();
            int ast2_result = this.ast2.populateTuples(tuples);
            assert (ast2_result == 1);
            tuples.address(end);
            tuples.toNumber();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class InExpression_AST
    extends ScalarExpression_AST {
        private InExpression_AST(AST arg, AST arr) {
            super(arg, arr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            assert (this.ast2 != null);
            if (!(this.ast2 instanceof ID_AST)) {
                throw new AST.SemanticException("Expecting an array for rhs of IN. Got an expression.");
            }
            ID_AST arr_ast = (ID_AST)this.ast2;
            if (arr_ast.isScalar()) {
                throw new AST.SemanticException("Expecting an array for rhs of IN. Got a scalar.");
            }
            arr_ast.setArray(true);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            int ast2_result = arr_ast.populateTuples(tuples);
            assert (ast2_result == 1);
            tuples.isIn();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class ComparisonExpression_AST
    extends ScalarExpression_AST {
        private int op;
        private String text;

        private ComparisonExpression_AST(AST lhs, int op, String text, AST rhs) {
            super(lhs, rhs);
            this.op = op;
            this.text = text;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.op + "/" + this.text + ")";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            assert (this.ast2 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            int ast2_result = this.ast2.populateTuples(tuples);
            assert (ast2_result == 1);
            if (this.op == _EQ_) {
                tuples.cmpEq();
            } else if (this.op == _NE_) {
                tuples.cmpEq();
                tuples.not();
            } else if (this.op == _LT_) {
                tuples.cmpLt();
            } else if (this.op == _GT_) {
                tuples.cmpGt();
            } else if (this.op == _LE_) {
                tuples.cmpGt();
                tuples.not();
            } else if (this.op == _GE_) {
                tuples.cmpLt();
                tuples.not();
            } else if (this.op == _MATCHES_) {
                tuples.matches();
            } else if (this.op == _NOT_MATCHES_) {
                tuples.matches();
                tuples.not();
            } else {
                throw new Error("Unhandled op: " + this.op + " / " + this.text);
            }
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class ConcatExpression_AST
    extends ScalarExpression_AST {
        private ConcatExpression_AST(AST lhs, AST rhs) {
            super(lhs, rhs);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int lhs_count = this.ast1.populateTuples(tuples);
            assert (lhs_count == 1);
            assert (this.ast2 != null);
            int rhs_count = this.ast2.populateTuples(tuples);
            assert (rhs_count == 1);
            tuples.concat();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class BinaryExpression_AST
    extends ScalarExpression_AST {
        private int op;
        private String text;

        private BinaryExpression_AST(AST lhs, int op, String text, AST rhs) {
            super(lhs, rhs);
            this.op = op;
            this.text = text;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.op + "/" + this.text + ")";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            int ast2_result = this.ast2.populateTuples(tuples);
            assert (ast2_result == 1);
            if (this.op == _PLUS_) {
                tuples.add();
            } else if (this.op == _MINUS_) {
                tuples.subtract();
            } else if (this.op == _MULT_) {
                tuples.multiply();
            } else if (this.op == _DIVIDE_) {
                tuples.divide();
            } else if (this.op == _MOD_) {
                tuples.mod();
            } else if (this.op == _POW_) {
                tuples.pow();
            } else {
                throw new Error("Unhandled op: " + this.op + " / " + this);
            }
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class NotExpression_AST
    extends ScalarExpression_AST {
        private NotExpression_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.not();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class NegativeExpression_AST
    extends ScalarExpression_AST {
        private NegativeExpression_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.negate();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class UnaryPlusExpression_AST
    extends ScalarExpression_AST {
        private UnaryPlusExpression_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.unaryPlus();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class ID_AST
    extends AST
    implements NonStatement_AST {
        private String id;
        private int offset = -1;
        private boolean is_global;
        private boolean is_array = false;
        private boolean is_scalar = false;

        private ID_AST(String id, boolean is_global) {
            this.id = id;
            this.is_global = is_global;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.id + ")";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.offset != -1) : "offset = " + this.offset + " for " + this;
            tuples.dereference(this.offset, this.isArray(), this.is_global);
            this.popSourceLineNumber(tuples);
            return 1;
        }

        @Override
        public final boolean isArray() {
            return this.is_array;
        }

        @Override
        public final boolean isScalar() {
            return this.is_scalar;
        }

        private void setArray(boolean b) {
            this.is_array = b;
        }

        private void setScalar(boolean b) {
            this.is_scalar = b;
        }
    }

    private final class ArrayReference_AST
    extends ScalarExpression_AST {
        private ArrayReference_AST(AST id_ast, AST idx_ast) {
            super(id_ast, idx_ast);
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.ast1 + " [...])";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            assert (this.ast2 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            int ast2_result = this.ast2.populateTuples(tuples);
            assert (ast2_result == 1);
            tuples.dereferenceArray();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class DollarExpression_AST
    extends ScalarExpression_AST {
        private DollarExpression_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.getInputField();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class PreInc_AST
    extends ScalarExpression_AST {
        private PreInc_AST(AST symbol_ast) {
            super(symbol_ast);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            if (this.ast1 instanceof ID_AST) {
                ID_AST id_ast = (ID_AST)this.ast1;
                tuples.inc(id_ast.offset, id_ast.is_global);
            } else if (this.ast1 instanceof ArrayReference_AST) {
                ArrayReference_AST arr_ast = (ArrayReference_AST)this.ast1;
                ID_AST id_ast = (ID_AST)arr_ast.ast1;
                assert (id_ast != null);
                assert (arr_ast.ast2 != null);
                int arr_ast2_result = arr_ast.ast2.populateTuples(tuples);
                assert (arr_ast2_result == 1);
                tuples.incArrayRef(id_ast.offset, id_ast.is_global);
            } else {
                if (this.ast1 instanceof DollarExpression_AST) {
                    DollarExpression_AST dollar_expr = (DollarExpression_AST)this.ast1;
                    assert (dollar_expr.ast1 != null);
                    int ast1_result = dollar_expr.ast1.populateTuples(tuples);
                    assert (ast1_result == 1);
                    tuples.dup();
                    tuples.incDollarRef();
                    tuples.getInputField();
                    this.popSourceLineNumber(tuples);
                    return 1;
                }
                throw new NotImplementedError("unhandled preinc for " + this.ast1);
            }
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class PreDec_AST
    extends ScalarExpression_AST {
        private PreDec_AST(AST symbol_ast) {
            super(symbol_ast);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            if (this.ast1 instanceof ID_AST) {
                ID_AST id_ast = (ID_AST)this.ast1;
                tuples.dec(id_ast.offset, id_ast.is_global);
            } else if (this.ast1 instanceof ArrayReference_AST) {
                ArrayReference_AST arr_ast = (ArrayReference_AST)this.ast1;
                ID_AST id_ast = (ID_AST)arr_ast.ast1;
                assert (id_ast != null);
                assert (arr_ast.ast2 != null);
                int arr_ast2_result = arr_ast.ast2.populateTuples(tuples);
                assert (arr_ast2_result == 1);
                tuples.decArrayRef(id_ast.offset, id_ast.is_global);
            } else {
                if (this.ast1 instanceof DollarExpression_AST) {
                    DollarExpression_AST dollar_expr = (DollarExpression_AST)this.ast1;
                    assert (dollar_expr.ast1 != null);
                    int ast1_result = dollar_expr.ast1.populateTuples(tuples);
                    assert (ast1_result == 1);
                    tuples.dup();
                    tuples.decDollarRef();
                    tuples.getInputField();
                    this.popSourceLineNumber(tuples);
                    return 1;
                }
                throw new NotImplementedError("unhandled predec for " + this.ast1);
            }
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class PostInc_AST
    extends ScalarExpression_AST {
        private PostInc_AST(AST symbol_ast) {
            super(symbol_ast);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            if (this.ast1 instanceof ID_AST) {
                ID_AST id_ast = (ID_AST)this.ast1;
                tuples.postInc(id_ast.offset, id_ast.is_global);
            } else if (this.ast1 instanceof ArrayReference_AST) {
                ArrayReference_AST arr_ast = (ArrayReference_AST)this.ast1;
                ID_AST id_ast = (ID_AST)arr_ast.ast1;
                assert (id_ast != null);
                assert (arr_ast.ast2 != null);
                int arr_ast2_result = arr_ast.ast2.populateTuples(tuples);
                assert (arr_ast2_result == 1);
                tuples.incArrayRef(id_ast.offset, id_ast.is_global);
            } else if (this.ast1 instanceof DollarExpression_AST) {
                DollarExpression_AST dollar_expr = (DollarExpression_AST)this.ast1;
                assert (dollar_expr.ast1 != null);
                int dollarast_ast1_result = dollar_expr.ast1.populateTuples(tuples);
                assert (dollarast_ast1_result == 1);
                tuples.incDollarRef();
            } else {
                throw new NotImplementedError("unhandled postinc for " + this.ast1);
            }
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class PostDec_AST
    extends ScalarExpression_AST {
        private PostDec_AST(AST symbol_ast) {
            super(symbol_ast);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            if (this.ast1 instanceof ID_AST) {
                ID_AST id_ast = (ID_AST)this.ast1;
                tuples.postDec(id_ast.offset, id_ast.is_global);
            } else if (this.ast1 instanceof ArrayReference_AST) {
                ArrayReference_AST arr_ast = (ArrayReference_AST)this.ast1;
                ID_AST id_ast = (ID_AST)arr_ast.ast1;
                assert (id_ast != null);
                assert (arr_ast.ast2 != null);
                int arr_ast2_result = arr_ast.ast2.populateTuples(tuples);
                assert (arr_ast2_result == 1);
                tuples.decArrayRef(id_ast.offset, id_ast.is_global);
            } else if (this.ast1 instanceof DollarExpression_AST) {
                DollarExpression_AST dollar_expr = (DollarExpression_AST)this.ast1;
                assert (dollar_expr.ast1 != null);
                int dollarast_ast1_result = dollar_expr.ast1.populateTuples(tuples);
                assert (dollarast_ast1_result == 1);
                tuples.decDollarRef();
            } else {
                throw new NotImplementedError("unhandled postinc for " + this.ast1);
            }
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class IntegerExpression_AST
    extends ScalarExpression_AST {
        private IntegerExpression_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.castInt();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class DoubleExpression_AST
    extends ScalarExpression_AST {
        private DoubleExpression_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.castDouble();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class StringExpression_AST
    extends ScalarExpression_AST {
        private StringExpression_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.castString();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class Extension_AST
    extends AST {
        private String extension_keyword;

        private Extension_AST(String extension_keyword, AST param_ast) {
            super(param_ast);
            this.extension_keyword = extension_keyword;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            boolean is_initial;
            int param_count;
            this.pushSourceLineNumber(tuples);
            if (this.ast1 == null) {
                param_count = 0;
            } else {
                JawkExtension extension = (JawkExtension)AwkParser.this.extensions.get(this.extension_keyword);
                int arg_count = this.countParams((FunctionCallParamList_AST)this.ast1);
                int[] req_array_idxs = extension.getAssocArrayParameterPositions(this.extension_keyword, arg_count);
                assert (req_array_idxs != null);
                for (int idx : req_array_idxs) {
                    AST param_ast = this.getParamAst((FunctionCallParamList_AST)this.ast1, idx);
                    assert (this.ast1 instanceof FunctionCallParamList_AST);
                    if (!(param_ast.ast1 instanceof ID_AST)) continue;
                    ID_AST id_ast = (ID_AST)param_ast.ast1;
                    if (id_ast.isScalar()) {
                        throw new AST.SemanticException("Extension '" + this.extension_keyword + "' requires parameter position " + idx + " be an associative array, not a scalar.");
                    }
                    id_ast.setArray(true);
                }
                param_count = this.ast1.populateTuples(tuples);
                assert (param_count >= 0);
            }
            if (this.parent instanceof FunctionCallParamList_AST) {
                AST ptr = this.parent;
                while (ptr instanceof FunctionCallParamList_AST) {
                    ptr = ptr.parent;
                }
                is_initial = !(ptr instanceof Extension_AST);
            } else {
                is_initial = true;
            }
            tuples.extension(this.extension_keyword, param_count, is_initial);
            this.popSourceLineNumber(tuples);
            return 1;
        }

        private AST getParamAst(FunctionCallParamList_AST p_ast, int pos) {
            for (int i = 0; i < pos; ++i) {
                p_ast = (FunctionCallParamList_AST)p_ast.ast2;
                if (p_ast != null) continue;
                throw new AST.SemanticException("More arguments required for assoc array parameter position specification.");
            }
            return p_ast;
        }

        private int countParams(FunctionCallParamList_AST p_ast) {
            int cnt = 0;
            while (p_ast != null) {
                p_ast = (FunctionCallParamList_AST)p_ast.ast2;
                ++cnt;
            }
            return cnt;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.extension_keyword + ")";
        }
    }

    private final class BuiltinFunctionCall_AST
    extends ScalarExpression_AST {
        private String id;
        private int f_idx;

        private BuiltinFunctionCall_AST(String id, AST params) {
            super(params);
            this.id = id;
            assert (BUILTIN_FUNC_NAMES.get(id) != null);
            this.f_idx = (Integer)BUILTIN_FUNC_NAMES.get(id);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("sprintf")) {
                if (this.ast1 == null) {
                    throw new AST.SemanticException("sprintf requires at least 1 argument");
                }
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result == 0) {
                    throw new AST.SemanticException("sprintf requires at minimum 1 argument");
                }
                tuples.sprintf(ast1_result);
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("close")) {
                if (this.ast1 == null) {
                    throw new AST.SemanticException("close requires 1 argument");
                }
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("close requires only 1 argument");
                }
                tuples.close();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("length")) {
                if (this.ast1 == null) {
                    tuples.length(0);
                } else {
                    int ast1_result = this.ast1.populateTuples(tuples);
                    if (ast1_result != 1) {
                        throw new AST.SemanticException("length requires at least one argument");
                    }
                    tuples.length(1);
                }
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("srand")) {
                if (this.ast1 == null) {
                    tuples.srand(0);
                } else {
                    int ast1_result = this.ast1.populateTuples(tuples);
                    if (ast1_result != 1) {
                        throw new AST.SemanticException("srand takes either 0 or one argument, not " + ast1_result);
                    }
                    tuples.srand(1);
                }
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("rand")) {
                if (this.ast1 != null) {
                    throw new AST.SemanticException("rand does not take arguments");
                }
                tuples.rand();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("sqrt")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("sqrt requires only 1 argument");
                }
                tuples.sqrt();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("int")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("int requires only 1 argument");
                }
                tuples.intFunc();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("log")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("int requires only 1 argument");
                }
                tuples.log();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("exp")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("exp requires only 1 argument");
                }
                tuples.exp();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("sin")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("sin requires only 1 argument");
                }
                tuples.sin();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("cos")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("cos requires only 1 argument");
                }
                tuples.cos();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("atan2")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 2) {
                    throw new AST.SemanticException("atan2 requires 2 arguments");
                }
                tuples.atan2();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("match")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 2) {
                    throw new AST.SemanticException("match requires 2 arguments");
                }
                tuples.match();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("index")) {
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 2) {
                    throw new AST.SemanticException("index requires 2 arguments");
                }
                tuples.index();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("sub") || this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("gsub")) {
                if (this.ast1 == null || this.ast1.ast2 == null || this.ast1.ast2.ast1 == null) {
                    throw new AST.SemanticException("sub needs at least 2 arguments");
                }
                boolean is_gsub = this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("gsub");
                int numargs = this.ast1.populateTuples(tuples);
                if (numargs == 2) {
                    tuples.subForDollar0(is_gsub);
                } else if (numargs == 3) {
                    AST ptr = this.ast1.ast2.ast2.ast1;
                    if (ptr instanceof ID_AST) {
                        ID_AST id_ast = (ID_AST)ptr;
                        if (id_ast.isArray()) {
                            throw new AST.SemanticException("sub cannot accept an unindexed array as its 3rd argument");
                        }
                        id_ast.setScalar(true);
                        tuples.subForVariable(id_ast.offset, id_ast.is_global, is_gsub);
                    } else if (ptr instanceof ArrayReference_AST) {
                        ArrayReference_AST arr_ast = (ArrayReference_AST)ptr;
                        int ast2_result = arr_ast.ast2.populateTuples(tuples);
                        assert (ast2_result == 1);
                        ID_AST id_ast = (ID_AST)arr_ast.ast1;
                        if (id_ast.isScalar()) {
                            throw new AST.SemanticException("Cannot use " + id_ast + " as an array.");
                        }
                        tuples.subForArrayReference(id_ast.offset, id_ast.is_global, is_gsub);
                    } else if (ptr instanceof DollarExpression_AST) {
                        DollarExpression_AST dollar_expr = (DollarExpression_AST)ptr;
                        assert (dollar_expr.ast1 != null);
                        int ast1_result = dollar_expr.ast1.populateTuples(tuples);
                        assert (ast1_result == 1);
                        tuples.subForDollarReference(is_gsub);
                    } else {
                        throw new AST.SemanticException("sub's 3rd argument must be either an id, an array reference, or an input field reference");
                    }
                }
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("split")) {
                if (this.ast1 == null || this.ast1.ast2 == null || this.ast1.ast2.ast1 == null) {
                    throw new AST.SemanticException("split needs at least 2 arguments");
                }
                AST ptr = this.ast1.ast2.ast1;
                if (!(ptr instanceof ID_AST)) {
                    throw new AST.SemanticException("split needs an array name as its 2nd argument");
                }
                ID_AST arr_ast = (ID_AST)ptr;
                if (arr_ast.isScalar()) {
                    throw new AST.SemanticException("split's 2nd arg cannot be a scalar");
                }
                arr_ast.setArray(true);
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 2 && ast1_result != 3) {
                    throw new AST.SemanticException("split requires 2 or 3 arguments, not " + ast1_result);
                }
                tuples.split(ast1_result);
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("substr")) {
                if (this.ast1 == null) {
                    throw new AST.SemanticException("substr requires at least 2 arguments");
                }
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 2 && ast1_result != 3) {
                    throw new AST.SemanticException("substr requires 2 or 3 arguments, not " + ast1_result);
                }
                tuples.substr(ast1_result);
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("tolower")) {
                if (this.ast1 == null) {
                    throw new AST.SemanticException("tolower requires 1 argument");
                }
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("tolower requires only 1 argument");
                }
                tuples.tolower();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("toupper")) {
                if (this.ast1 == null) {
                    throw new AST.SemanticException("toupper requires 1 argument");
                }
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("toupper requires only 1 argument");
                }
                tuples.toupper();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("system")) {
                if (this.ast1 == null) {
                    throw new AST.SemanticException("system requires 1 argument");
                }
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("system requires only 1 argument");
                }
                tuples.system();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            if (this.f_idx == (Integer)BUILTIN_FUNC_NAMES.get("exec")) {
                if (this.ast1 == null) {
                    throw new AST.SemanticException("exec requires 1 argument");
                }
                int ast1_result = this.ast1.populateTuples(tuples);
                if (ast1_result != 1) {
                    throw new AST.SemanticException("exec requires only 1 argument");
                }
                tuples.exec();
                this.popSourceLineNumber(tuples);
                return 1;
            }
            throw new NotImplementedError("builtin: " + this.id);
        }
    }

    private static interface NonStatement_AST {
    }

    private final class ExpressionStatement_AST
    extends AST {
        private ExpressionStatement_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            int expr_count = this.ast1.populateTuples(tuples);
            if (expr_count != 0) {
                if (expr_count == 1) {
                    tuples.pop();
                } else assert (false) : "expr_count = " + expr_count;
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class IfStatement_AST
    extends AST {
        private IfStatement_AST(AST expr, AST b1, AST b2) {
            super(expr, b1, b2);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            Address elseblock = tuples.createAddress("elseblock");
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.ifFalse(elseblock);
            if (this.ast2 != null) {
                int ast2_result = this.ast2.populateTuples(tuples);
                assert (ast2_result == 0);
            }
            if (this.ast3 == null) {
                tuples.address(elseblock);
            } else {
                Address end = tuples.createAddress("end");
                tuples.gotoAddress(end);
                tuples.address(elseblock);
                int ast3_result = this.ast3.populateTuples(tuples);
                assert (ast3_result == 0);
                tuples.address(end);
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private class BreakStatement_AST
    extends AST {
        private BreakStatement_AST() {
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            Breakable breakable = (Breakable)((Object)this.searchFor(Breakable.class));
            if (breakable == null) {
                throw new AST.SemanticException("cannot break; not within a loop");
            }
            assert (breakable != null);
            tuples.gotoAddress(breakable.breakAddress());
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class WhileStatement_AST
    extends AST
    implements Breakable,
    Continueable {
        private Address break_address;
        private Address continue_address;

        private WhileStatement_AST(AST expr, AST block) {
            super(expr, block);
        }

        @Override
        public Address breakAddress() {
            assert (this.break_address != null);
            return this.break_address;
        }

        @Override
        public Address continueAddress() {
            assert (this.continue_address != null);
            return this.continue_address;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            this.break_address = tuples.createAddress("break_address");
            Address loop = tuples.createAddress("loop");
            tuples.address(loop);
            this.continue_address = loop;
            assert (this.ast1 != null);
            int ast1_result = this.ast1.populateTuples(tuples);
            assert (ast1_result == 1);
            tuples.ifFalse(this.break_address);
            if (this.ast2 != null) {
                int ast2_result = this.ast2.populateTuples(tuples);
                assert (ast2_result == 0);
            }
            tuples.gotoAddress(loop);
            tuples.address(this.break_address);
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class ForInStatement_AST
    extends AST
    implements Breakable,
    Continueable {
        private Address break_address;
        private Address continue_address;

        private ForInStatement_AST(AST key_id_ast, AST array_id_ast, AST block) {
            super(key_id_ast, array_id_ast, block);
        }

        @Override
        public Address breakAddress() {
            assert (this.break_address != null);
            return this.break_address;
        }

        @Override
        public Address continueAddress() {
            assert (this.continue_address != null);
            return this.continue_address;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast2 != null);
            ID_AST array_id_ast = (ID_AST)this.ast2;
            if (array_id_ast.isScalar()) {
                throw new AST.SemanticException(array_id_ast + " is not an array");
            }
            array_id_ast.setArray(true);
            this.break_address = tuples.createAddress("break_address");
            this.ast2.populateTuples(tuples);
            tuples.keylist();
            Address loop = tuples.createAddress("loop");
            tuples.address(loop);
            this.continue_address = loop;
            assert (tuples.checkClass(KeyList.class));
            tuples.dup();
            tuples.isEmptyList(this.break_address);
            assert (tuples.checkClass(KeyList.class));
            tuples.dup();
            tuples.getFirstAndRemoveFromList();
            tuples.assign(((ID_AST)this.ast1).offset, ((ID_AST)this.ast1).is_global);
            tuples.pop();
            if (this.ast3 != null) {
                int ast3_result = this.ast3.populateTuples(tuples);
                assert (ast3_result == 0);
            }
            assert (tuples.checkClass(KeyList.class));
            tuples.gotoAddress(loop);
            tuples.address(this.break_address);
            tuples.pop();
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class ForStatement_AST
    extends AST
    implements Breakable,
    Continueable {
        private Address break_address;
        private Address continue_address;

        private ForStatement_AST(AST expr1, AST expr2, AST expr3, AST block) {
            super(expr1, expr2, expr3, block);
        }

        @Override
        public Address breakAddress() {
            assert (this.break_address != null);
            return this.break_address;
        }

        @Override
        public Address continueAddress() {
            assert (this.continue_address != null);
            return this.continue_address;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            this.break_address = tuples.createAddress("break_address");
            this.continue_address = tuples.createAddress("continue_address");
            if (this.ast1 != null) {
                int ast1_result = this.ast1.populateTuples(tuples);
                for (int i = 0; i < ast1_result; ++i) {
                    tuples.pop();
                }
            }
            Address loop = tuples.createAddress("loop");
            tuples.address(loop);
            if (this.ast2 != null) {
                int ast2_result = this.ast2.populateTuples(tuples);
                assert (ast2_result == 1);
                tuples.ifFalse(this.break_address);
            }
            if (this.ast4 != null) {
                int ast4_result = this.ast4.populateTuples(tuples);
                assert (ast4_result == 0);
            }
            tuples.address(this.continue_address);
            if (this.ast3 != null) {
                int ast3_result = this.ast3.populateTuples(tuples);
                for (int i = 0; i < ast3_result; ++i) {
                    tuples.pop();
                }
            }
            tuples.gotoAddress(loop);
            tuples.address(this.break_address);
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class DeleteStatement_AST
    extends AST {
        private DeleteStatement_AST(AST symbol_ast) {
            super(symbol_ast);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            assert (this.ast1 != null);
            if (this.ast1 instanceof ArrayReference_AST) {
                assert (this.ast1.ast1 != null);
                assert (this.ast1.ast2 != null);
                ID_AST id_ast = (ID_AST)this.ast1.ast1;
                if (id_ast.isScalar()) {
                    throw new AST.SemanticException("delete: Cannot use a scalar as an array.");
                }
                id_ast.setArray(true);
                int idx_result = this.ast1.ast2.populateTuples(tuples);
                assert (idx_result == 1);
                tuples.deleteArrayElement(id_ast.offset, id_ast.is_global);
            } else if (this.ast1 instanceof ID_AST) {
                ID_AST id_ast = (ID_AST)this.ast1;
                if (id_ast.isScalar()) {
                    throw new AST.SemanticException("delete: Cannot delete a scalar.");
                }
                id_ast.setArray(true);
                tuples.deleteArray(id_ast.offset, id_ast.is_global);
            } else {
                throw new Error("Should never reach here : delete for " + this.ast1);
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private static final class ParsedPrintStatement {
        private AST funcParams;
        private int outputToken;
        private AST outputExpr;

        ParsedPrintStatement(AST funcParams, int outputToken, AST outputExpr) {
            this.funcParams = funcParams;
            this.outputToken = outputToken;
            this.outputExpr = outputExpr;
        }

        public AST getFuncParams() {
            return this.funcParams;
        }

        public int getOutputToken() {
            return this.outputToken;
        }

        public AST getOutputExpr() {
            return this.outputExpr;
        }
    }

    private final class Print_AST
    extends ScalarExpression_AST {
        private int output_token;

        private Print_AST(AST expr_list, int output_token, AST output_expr) {
            super(expr_list, output_expr);
            this.output_token = output_token;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            int param_count;
            this.pushSourceLineNumber(tuples);
            if (this.ast1 == null) {
                param_count = 0;
            } else {
                param_count = this.ast1.populateTuples(tuples);
                assert (param_count >= 0);
                if (param_count == 0) {
                    throw new AST.SemanticException("Cannot print the result. The expression doesn't return anything.");
                }
            }
            if (this.ast2 != null) {
                int ast2_result = this.ast2.populateTuples(tuples);
                assert (ast2_result == 1);
            }
            if (this.output_token == _GT_) {
                tuples.printToFile(param_count, false);
            } else if (this.output_token == _APPEND_) {
                tuples.printToFile(param_count, true);
            } else if (this.output_token == _PIPE_) {
                tuples.printToPipe(param_count);
            } else {
                tuples.print(param_count);
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class Printf_AST
    extends ScalarExpression_AST {
        private int output_token;

        private Printf_AST(AST expr_list, int output_token, AST output_expr) {
            super(expr_list, output_expr);
            this.output_token = output_token;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            int param_count;
            this.pushSourceLineNumber(tuples);
            if (this.ast1 == null) {
                param_count = 0;
            } else {
                param_count = this.ast1.populateTuples(tuples);
                assert (param_count >= 0);
                if (param_count == 0) {
                    throw new AST.SemanticException("Cannot printf the result. The expression doesn't return anything.");
                }
            }
            if (this.ast2 != null) {
                int ast2_result = this.ast2.populateTuples(tuples);
                assert (ast2_result == 1);
            }
            if (this.output_token == _GT_) {
                tuples.printfToFile(param_count, false);
            } else if (this.output_token == _APPEND_) {
                tuples.printfToFile(param_count, true);
            } else if (this.output_token == _PIPE_) {
                tuples.printfToPipe(param_count);
            } else {
                tuples.printf(param_count);
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class Getline_AST
    extends ScalarExpression_AST {
        private Getline_AST(AST pipe_expr, AST lvalue_ast, AST in_redirect) {
            super(pipe_expr, lvalue_ast, in_redirect);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            if (this.ast1 != null) {
                int ast1_result = this.ast1.populateTuples(tuples);
                assert (ast1_result == 1);
                tuples.useAsCommandInput();
            } else if (this.ast3 != null) {
                int ast3_result = this.ast3.populateTuples(tuples);
                assert (ast3_result == 1);
                tuples.useAsFileInput();
            } else {
                tuples.getlineInput();
            }
            if (this.ast2 == null) {
                tuples.assignAsInput();
            } else if (this.ast2 instanceof ID_AST) {
                ID_AST id_ast = (ID_AST)this.ast2;
                tuples.assign(id_ast.offset, id_ast.is_global);
                if (id_ast.id.equals("RS")) {
                    tuples.applyRS();
                }
            } else if (this.ast2 instanceof ArrayReference_AST) {
                ArrayReference_AST arr = (ArrayReference_AST)this.ast2;
                assert (arr.ast2 != null);
                int arr_ast2_result = arr.ast2.populateTuples(tuples);
                assert (arr_ast2_result == 1);
                ID_AST id_ast = (ID_AST)arr.ast1;
                tuples.assignArray(id_ast.offset, id_ast.is_global);
            } else if (this.ast2 instanceof DollarExpression_AST) {
                DollarExpression_AST dollar_expr = (DollarExpression_AST)this.ast2;
                if (dollar_expr.ast2 != null) {
                    int ast2_result = dollar_expr.ast2.populateTuples(tuples);
                    assert (ast2_result == 1);
                }
                tuples.assignAsInputField();
            } else {
                throw new AST.SemanticException("Cannot getline into a " + this.ast2);
            }
            tuples.pop();
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class DoStatement_AST
    extends AST
    implements Breakable,
    Continueable {
        private Address break_address;
        private Address continue_address;

        private DoStatement_AST(AST block, AST expr) {
            super(block, expr);
        }

        @Override
        public Address breakAddress() {
            assert (this.break_address != null);
            return this.break_address;
        }

        @Override
        public Address continueAddress() {
            assert (this.continue_address != null);
            return this.continue_address;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            this.break_address = tuples.createAddress("break_address");
            this.continue_address = tuples.createAddress("continue_address");
            Address loop = tuples.createAddress("loop");
            tuples.address(loop);
            if (this.ast1 != null) {
                int ast1_result = this.ast1.populateTuples(tuples);
                assert (ast1_result == 0);
            }
            tuples.address(this.continue_address);
            assert (this.ast2 != null);
            int ast2_result = this.ast2.populateTuples(tuples);
            assert (ast2_result == 1);
            tuples.ifTrue(loop);
            tuples.address(this.break_address);
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class ReturnStatement_AST
    extends AST {
        private ReturnStatement_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            Returnable returnable = (Returnable)((Object)this.searchFor(Returnable.class));
            if (returnable == null) {
                throw new AST.SemanticException("Cannot use return here.");
            }
            if (this.ast1 != null) {
                int ast1_result = this.ast1.populateTuples(tuples);
                assert (ast1_result == 1);
                tuples.setReturnResult();
            }
            tuples.gotoAddress(returnable.returnAddress());
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class ExitStatement_AST
    extends AST {
        private ExitStatement_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            if (this.ast1 != null) {
                int ast1_result = this.ast1.populateTuples(tuples);
                assert (ast1_result == 1);
                tuples.exitWithCode();
            } else {
                tuples.exitWithoutCode();
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class SleepStatement_AST
    extends AST {
        private SleepStatement_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            if (this.ast1 == null) {
                tuples.sleep(0);
            } else {
                int ast1_result = this.ast1.populateTuples(tuples);
                assert (ast1_result == 1);
                tuples.sleep(ast1_result);
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class DumpStatement_AST
    extends AST {
        private DumpStatement_AST(AST expr) {
            super(expr);
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            if (this.ast1 == null) {
                tuples.dump(0);
            } else {
                assert (this.ast1 instanceof FunctionCallParamList_AST);
                AST ptr = this.ast1;
                while (ptr != null) {
                    if (!(ptr.ast1 instanceof ID_AST)) {
                        throw new AST.SemanticException("ID required for argument(s) to _dump");
                    }
                    ID_AST id_ast = (ID_AST)ptr.ast1;
                    if (id_ast.isScalar()) {
                        throw new AST.SemanticException("_dump: Cannot use a scalar as an argument.");
                    }
                    id_ast.setArray(true);
                    ptr = ptr.ast2;
                }
                int ast1_result = this.ast1.populateTuples(tuples);
                tuples.dump(ast1_result);
            }
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private class NextStatement_AST
    extends AST {
        private NextStatement_AST() {
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            Nextable nextable = (Nextable)((Object)this.searchFor(Nextable.class));
            if (nextable == null) {
                throw new AST.SemanticException("cannot next; not within any input rules");
            }
            assert (nextable != null);
            tuples.gotoAddress(nextable.nextAddress());
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class ContinueStatement_AST
    extends AST {
        private ContinueStatement_AST() {
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            Continueable continueable = (Continueable)((Object)this.searchFor(Continueable.class));
            if (continueable == null) {
                throw new AST.SemanticException("cannot issue a continue; not within any loops");
            }
            assert (continueable != null);
            tuples.gotoAddress(continueable.continueAddress());
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private final class FunctionCall_AST
    extends ScalarExpression_AST {
        private FunctionProxy function_proxy;

        private FunctionCall_AST(FunctionProxy function_proxy, AST params) {
            super(params);
            this.function_proxy = function_proxy;
        }

        @Override
        public void semanticAnalysis() throws AST.SemanticException {
            if (!this.function_proxy.isDefined()) {
                throw new AST.SemanticException("function " + this.function_proxy + " not defined");
            }
            int actual_param_count = this.ast1 == null ? 0 : this.actualParamCount();
            int formal_param_count = this.function_proxy.getFunctionParamCount();
            if (formal_param_count < actual_param_count) {
                throw new AST.SemanticException("the " + this.function_proxy.getFunctionName() + " function only accepts at most " + formal_param_count + " parameter(s), not " + actual_param_count);
            }
            if (this.ast1 != null) {
                this.function_proxy.checkActualToFormalParameters(this.ast1);
            }
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            if (!this.function_proxy.isDefined()) {
                throw new AST.SemanticException("function " + this.function_proxy + " not defined");
            }
            tuples.scriptThis();
            int actual_param_count = this.ast1 == null ? 0 : this.ast1.populateTuples(tuples);
            int formal_param_count = this.function_proxy.getFunctionParamCount();
            if (formal_param_count < actual_param_count) {
                throw new AST.SemanticException("the " + this.function_proxy.getFunctionName() + " function only accepts at most " + formal_param_count + " parameter(s), not " + actual_param_count);
            }
            this.function_proxy.checkActualToFormalParameters(this.ast1);
            tuples.callFunction(this.function_proxy, this.function_proxy.getFunctionName(), formal_param_count, actual_param_count);
            this.popSourceLineNumber(tuples);
            return 1;
        }

        private int actualParamCount() {
            int cnt = 0;
            AST ptr = this.ast1;
            while (ptr != null) {
                assert (ptr.ast1 != null);
                ++cnt;
                ptr = ptr.ast2;
            }
            return cnt;
        }
    }

    private final class FunctionProxy
    implements HasFunctionAddress {
        private FunctionDef_AST function_def_ast;
        private String id;

        private FunctionProxy(String id) {
            this.id = id;
        }

        private void setFunctionDefinition(FunctionDef_AST function_def) {
            if (this.function_def_ast != null) {
                throw new ParserException("function " + function_def + " already defined");
            }
            this.function_def_ast = function_def;
        }

        private boolean isDefined() {
            return this.function_def_ast != null;
        }

        @Override
        public Address getFunctionAddress() {
            return this.function_def_ast.getAddress();
        }

        private String getFunctionName() {
            return this.id;
        }

        private int getFunctionParamCount() {
            return this.function_def_ast.paramCount();
        }

        public String toString() {
            return super.toString() + " (" + this.id + ")";
        }

        private void checkActualToFormalParameters(AST actual_params) {
            this.function_def_ast.checkActualToFormalParameters(actual_params);
        }
    }

    private final class End_AST
    extends AST {
        private End_AST() {
            this.is_end = true;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            tuples.push(1);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class Begin_AST
    extends AST {
        private Begin_AST() {
            this.is_begin = true;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            tuples.push(1);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class Regexp_AST
    extends ScalarExpression_AST {
        private String regexp_str;

        private Regexp_AST(String regexp_str) {
            assert (regexp_str != null);
            this.regexp_str = regexp_str;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.regexp_str + ")";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            tuples.regexp(this.regexp_str);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class String_AST
    extends ScalarExpression_AST
    implements NonStatement_AST {
        private String S;

        private String_AST(String str) {
            assert (str != null);
            this.S = str;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.S + ")";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            tuples.push(this.S);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class Double_AST
    extends ScalarExpression_AST
    implements NonStatement_AST {
        private Object D;

        private Double_AST(Double D) {
            double d = D;
            this.D = d == (double)((int)d) ? (Number)((int)d) : (Number)d;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.D + ")";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            tuples.push(this.D);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class Integer_AST
    extends ScalarExpression_AST
    implements NonStatement_AST {
        private Long I;

        private Integer_AST(Long I) {
            this.I = I;
        }

        @Override
        public String toString() {
            return super.toString() + " (" + this.I + ")";
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            tuples.push(this.I);
            this.popSourceLineNumber(tuples);
            return 1;
        }
    }

    private final class FunctionDef_AST
    extends AST
    implements Returnable {
        private String id;
        private Address function_address;
        private Address return_address;

        @Override
        public Address returnAddress() {
            assert (this.return_address != null);
            return this.return_address;
        }

        private FunctionDef_AST(String id, AST params, AST func_body) {
            super(params, func_body);
            this.id = id;
            this.is_function = true;
        }

        public Address getAddress() {
            assert (this.function_address != null);
            return this.function_address;
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            this.function_address = tuples.createAddress("function: " + this.id);
            this.return_address = tuples.createAddress("return_address for " + this.id);
            tuples.function(this.id, this.paramCount());
            tuples.address(this.function_address);
            if (this.ast2 != null) {
                int ast2_result = this.ast2.populateTuples(tuples);
                assert (ast2_result == 0 || ast2_result == 1);
            }
            tuples.address(this.return_address);
            tuples.returnFromFunction();
            this.popSourceLineNumber(tuples);
            return 0;
        }

        int paramCount() {
            AST ptr = this.ast1;
            int count = 0;
            while (ptr != null) {
                ++count;
                ptr = ptr.ast1;
            }
            return count;
        }

        void checkActualToFormalParameters(AST actual_param_list) {
            AST a_ptr = actual_param_list;
            FunctionDefParamList_AST f_ptr = (FunctionDefParamList_AST)this.ast1;
            while (a_ptr != null) {
                AST aparam = a_ptr.ast1;
                ID_AST fparam = AwkParser.this.symbol_table.getFunctionParameterIDAST(this.id, f_ptr.id);
                if (aparam.isArray() && ((AST)fparam).isScalar()) {
                    aparam.throwSemanticException(this.id + ": Actual parameter (" + aparam + ") is an array, but formal parameter is used like a scalar.");
                }
                if (aparam.isScalar() && ((AST)fparam).isArray()) {
                    aparam.throwSemanticException(this.id + ": Actual parameter (" + aparam + ") is a scalar, but formal parameter is used like an array.");
                }
                if (aparam instanceof ID_AST) {
                    ID_AST aparam_id_ast = (ID_AST)aparam;
                    if (((AST)fparam).isScalar()) {
                        aparam_id_ast.setScalar(true);
                    }
                    if (((AST)fparam).isArray()) {
                        aparam_id_ast.setArray(true);
                    }
                }
                a_ptr = a_ptr.ast2;
                f_ptr = (FunctionDefParamList_AST)f_ptr.ast1;
            }
        }
    }

    private static interface Returnable {
        public Address returnAddress();
    }

    private final class EmptyStatement_AST
    extends AST {
        private EmptyStatement_AST() {
        }

        @Override
        public int populateTuples(AwkTuples tuples) {
            this.pushSourceLineNumber(tuples);
            this.popSourceLineNumber(tuples);
            return 0;
        }
    }

    private abstract class ScalarExpression_AST
    extends AST {
        protected ScalarExpression_AST() {
        }

        protected ScalarExpression_AST(AST a1) {
            super(a1);
        }

        protected ScalarExpression_AST(AST a1, AST a2) {
            super(a1, a2);
        }

        protected ScalarExpression_AST(AST a1, AST a2, AST a3) {
            super(a1, a2, a3);
        }

        @Override
        public final boolean isArray() {
            return false;
        }

        @Override
        public final boolean isScalar() {
            return true;
        }
    }

    private static interface Continueable {
        public Address continueAddress();
    }

    private static interface Nextable {
        public Address nextAddress();
    }

    private static interface Breakable {
        public Address breakAddress();
    }
}

