/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.jrt;

import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.sentrysoftware.jawk.intermediate.UninitializedObject;
import org.sentrysoftware.jawk.jrt.AwkRuntimeException;

public class AssocArray
implements Comparator<Object> {
    private Map<Object, Object> map;
    public static final int MT_HASH = 2;
    public static final int MT_LINKED = 4;
    public static final int MT_TREE = 8;
    private static final UninitializedObject BLANK = new UninitializedObject();

    public AssocArray(boolean sortedArrayKeys) {
        this.map = sortedArrayKeys ? new TreeMap<Object, Object>(this) : new HashMap<Object, Object>();
    }

    public void useMapType(int mapType) {
        assert (this.map.isEmpty());
        switch (mapType) {
            case 2: {
                this.map = new HashMap<Object, Object>();
                break;
            }
            case 4: {
                this.map = new LinkedHashMap<Object, Object>();
                break;
            }
            case 8: {
                this.map = new TreeMap<Object, Object>(this);
                break;
            }
            default: {
                throw new Error("Invalid map type : " + mapType);
            }
        }
    }

    public String mapString() {
        StringBuilder sb = new StringBuilder().append('{');
        int cnt = 0;
        for (Object o : this.map.keySet()) {
            if (cnt > 0) {
                sb.append(", ");
            }
            if (o instanceof AssocArray) {
                sb.append(((AssocArray)o).mapString());
            } else {
                sb.append(o.toString());
            }
            sb.append('=');
            Object o2 = this.map.get(o);
            if (o2 instanceof AssocArray) {
                sb.append(((AssocArray)o2).mapString());
            } else {
                sb.append(o2.toString());
            }
            ++cnt;
        }
        return sb.append('}').toString();
    }

    public boolean isIn(Object key) {
        return this.map.get(key) != null;
    }

    public Object get(Object key) {
        Object result;
        if (key == null || key instanceof UninitializedObject) {
            key = 0L;
        }
        if ((result = this.map.get(key)) != null) {
            return result;
        }
        try {
            key = Long.parseLong(key.toString());
            result = this.map.get(key);
            if (result != null) {
                return result;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        result = BLANK;
        this.map.put(key, result);
        return result;
    }

    public Object put(Object key, Object value) {
        if (key == null || key instanceof UninitializedObject) {
            key = 0L;
        }
        try {
            long iKey = Long.parseLong(key.toString());
            return this.map.put(iKey, value);
        }
        catch (Exception exception) {
            return this.map.put(key, value);
        }
    }

    public Object put(long key, Object value) {
        return this.map.put(key, value);
    }

    public Set<Object> keySet() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public Object remove(Object key) {
        return this.map.remove(key);
    }

    public String toString() {
        throw new AwkRuntimeException("Cannot evaluate an unindexed array.");
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof String || o2 instanceof String) {
            String s1 = o1.toString();
            String s2 = o2.toString();
            return s1.compareTo(s2);
        }
        if (o1 instanceof Double || o2 instanceof Double) {
            Double d1 = (Double)o1;
            Double d2 = (Double)o2;
            return d1.compareTo(d2);
        }
        Integer i1 = (Integer)o1;
        Integer i2 = (Integer)o2;
        return i1.compareTo(i2);
    }

    public String getMapVersion() {
        return this.map.getClass().getPackage().getSpecificationVersion();
    }
}

