/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.jrt;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PartitioningReader
extends FilterReader {
    private static final boolean FORCE_GREEDY_RS;
    private Pattern rs;
    private Matcher matcher;
    private boolean fromFileNameList;
    private String recordSeparator = null;
    private boolean consumeAll = false;
    private StringBuilder remaining = new StringBuilder();
    private char[] readBuffer = new char[4096];
    private boolean eof = false;

    public PartitioningReader(Reader reader, String recordSeparator) {
        this(reader, recordSeparator, false);
    }

    public PartitioningReader(Reader r, String recordSeparator, boolean fromFileNameList) {
        super(r);
        this.fromFileNameList = fromFileNameList;
        this.setRecordSeparator(recordSeparator);
    }

    public final void setRecordSeparator(String recordSeparator) {
        if (!recordSeparator.equals(this.recordSeparator)) {
            if ("".equals(recordSeparator)) {
                this.consumeAll = true;
                this.rs = Pattern.compile("\\z", 40);
            } else if ("\n".equals(recordSeparator) || "\r\n".equals(recordSeparator) || "\r".equals(recordSeparator)) {
                this.consumeAll = false;
                this.rs = Pattern.compile(recordSeparator, 16);
            } else {
                this.consumeAll = false;
                this.rs = Pattern.compile(recordSeparator, 40);
            }
            this.recordSeparator = recordSeparator;
        }
    }

    public boolean fromFilenameList() {
        return this.fromFileNameList;
    }

    @Override
    public int read(char[] b, int start, int len) throws IOException {
        int readChars = super.read(b, start, len);
        if (readChars >= 0) {
            this.remaining.append(b, start, readChars);
        }
        return readChars;
    }

    public String readRecord() throws IOException {
        if (this.matcher == null) {
            this.matcher = this.rs.matcher(this.remaining);
        } else {
            this.matcher.reset(this.remaining);
        }
        while (this.consumeAll || this.eof || this.remaining.length() == 0 || !this.matcher.find()) {
            int len = this.read(this.readBuffer, 0, this.readBuffer.length);
            if (this.eof || len < 0) {
                this.eof = true;
                String retVal = this.remaining.toString();
                this.remaining.setLength(0);
                if (retVal.length() == 0) {
                    return null;
                }
                return retVal;
            }
            if (len == 0) {
                throw new RuntimeException("len == 0 ?!");
            }
            this.matcher = this.rs.matcher(this.remaining);
        }
        if (FORCE_GREEDY_RS) {
            while (this.matcher.find() && this.matcher.end() == this.remaining.length() && this.matcher.requireEnd() && this.read(this.readBuffer, 0, 1) >= 0) {
                this.matcher = this.rs.matcher(this.remaining);
            }
        }
        String retVal = this.remaining.substring(0, this.matcher.start());
        this.remaining.delete(0, this.matcher.end());
        return retVal;
    }

    static {
        String grs = System.getProperty("jawk.forceGreedyRS", "0").trim();
        FORCE_GREEDY_RS = grs.equals("1") || grs.equalsIgnoreCase("yes") || grs.equalsIgnoreCase("true");
    }
}

