/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.jawk.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public final class DestDirClassLoader
extends ClassLoader {
    private String dirname;

    public DestDirClassLoader(String dirname) {
        this.dirname = dirname;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] b = this.loadClassData(name);
        return this.defineClass(name, b, 0, b.length);
    }

    private byte[] loadClassData(String name) throws ClassNotFoundException {
        String fileName = this.dirname + File.separator + name + ".class";
        try {
            int len;
            FileInputStream f = new FileInputStream(fileName);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] b = new byte[4096];
            while ((len = f.read(b, 0, b.length)) >= 0) {
                baos.write(b, 0, len);
            }
            f.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException("Could not load class " + name + " from file \"" + fileName + "\"", ioe);
        }
    }
}

