/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.awk;

import java.text.ParseException;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.sentrysoftware.jawk.intermediate.AwkTuples;
import org.sentrysoftware.metricshub.engine.awk.Awk;
import org.sentrysoftware.metricshub.engine.awk.AwkException;

public class AwkExecutor {
    static ConcurrentHashMap<String, AwkTuples> awkCodeMap = new ConcurrentHashMap();

    public static String executeAwk(String awkScript, String awkInput) throws AwkException {
        AwkTuples tuples;
        try {
            tuples = awkCodeMap.computeIfAbsent(awkScript, code -> {
                try {
                    return Awk.getIntermediateCode(code);
                }
                catch (ParseException e) {
                    throw new RuntimeException(e.getMessage());
                }
            });
        }
        catch (Exception e) {
            throw new AwkException("Failed to get intermediate code.", e);
        }
        if (tuples == null) {
            throw new AwkException("Failed to interpret the AWK script below:\n" + awkScript);
        }
        String result = Awk.interpret(awkInput, tuples);
        if (result == null) {
            throw new AwkException(String.format("Null result for the script below on the specified input:\n%s\n\nInput:\n%s", awkScript, awkInput));
        }
        return result;
    }

    public static void resetCache() {
        awkCodeMap.clear();
    }

    @Generated
    private AwkExecutor() {
    }
}

