/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class LocalOsHandler {
    public static final ILocalOs WINDOWS = new Windows();
    public static final ILocalOs LINUX = new Linux();
    public static final ILocalOs SUN = new Sun();
    public static final ILocalOs HP = new Hp();
    public static final ILocalOs SOLARIS = new Solaris();
    public static final ILocalOs AIX = new Aix();
    public static final ILocalOs FREE_BSD = new FreeBsd();
    public static final ILocalOs OPEN_BSD = new OpenBsd();
    public static final ILocalOs NET_BSD = new NetBsd();
    public static final ILocalOs MAC_OS_X = new MacOsx();
    private static final List<ILocalOs> OS_LIST = List.of(WINDOWS, LINUX, AIX, SUN, HP, MAC_OS_X, SOLARIS, FREE_BSD, OPEN_BSD, NET_BSD);
    private static final Optional<ILocalOs> OS = LocalOsHandler.detectOs();
    private static final boolean IS_WINDOWS = OS.isPresent() && OS.get().equals(WINDOWS);

    static Optional<ILocalOs> detectOs() {
        return LocalOsHandler.getSystemOsName().map(String::toLowerCase).map(name -> OS_LIST.stream().filter(os -> name.startsWith(os.getOsTag())).findFirst().orElse(null));
    }

    public static boolean isWindows() {
        return IS_WINDOWS;
    }

    public static Optional<String> getSystemOsName() {
        return Optional.ofNullable(System.getProperty("os.name"));
    }

    public static Optional<String> getSystemOsVersion() {
        return Optional.ofNullable(System.getProperty("os.version"));
    }

    @Generated
    private LocalOsHandler() {
    }

    @Generated
    public static Optional<ILocalOs> getOS() {
        return OS;
    }

    public static abstract class ILocalOs {
        protected String osTag;
        protected boolean unix;

        public abstract void accept(ILocalOsVisitor var1);

        @Generated
        public String getOsTag() {
            return this.osTag;
        }

        @Generated
        public boolean isUnix() {
            return this.unix;
        }
    }

    public static class Windows
    extends ILocalOs {
        Windows() {
            this.osTag = "windows";
            this.unix = false;
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Linux
    extends ILocalOs {
        Linux() {
            this.osTag = "linux";
            this.unix = true;
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Sun
    extends ILocalOs {
        Sun() {
            this.osTag = "sunos";
            this.unix = true;
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Hp
    extends ILocalOs {
        Hp() {
            this.osTag = "hp-ux";
            this.unix = true;
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Solaris
    extends ILocalOs {
        Solaris() {
            this.osTag = "solaris";
            this.unix = true;
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class Aix
    extends ILocalOs {
        Aix() {
            this.osTag = "aix";
            this.unix = true;
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class FreeBsd
    extends BsdOs {
        FreeBsd() {
            this.osTag = "freebsd";
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class OpenBsd
    extends BsdOs {
        OpenBsd() {
            this.osTag = "openbsd";
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class NetBsd
    extends BsdOs {
        NetBsd() {
            this.osTag = "netbsd";
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    public static class MacOsx
    extends ILocalOs {
        MacOsx() {
            this.osTag = "mac os x";
            this.unix = true;
        }

        @Override
        public void accept(ILocalOsVisitor visitor) {
            visitor.visit(this);
        }
    }

    private static abstract class BsdOs
    extends ILocalOs {
        private final boolean bsd;

        BsdOs() {
            this.bsd = true;
            this.unix = true;
        }

        @Generated
        public boolean isBsd() {
            return this.bsd;
        }
    }

    public static interface ILocalOsVisitor {
        public void visit(Windows var1);

        public void visit(Linux var1);

        public void visit(Sun var1);

        public void visit(Hp var1);

        public void visit(Solaris var1);

        public void visit(Aix var1);

        public void visit(FreeBsd var1);

        public void visit(OpenBsd var1);

        public void visit(NetBsd var1);

        public void visit(MacOsx var1);
    }
}

