/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NetworkHelper.class);
    private static final Pattern IPV6_ENCLOSED_IN_SQUARE_BRACKETS_PATTERN = Pattern.compile("^\\[.*\\]$");
    private static final Set<String> TYPICAL_LOCALHOST_HOSTNAMES = Set.of("localhost", "127.0.0.1", "::1", "0:0:0:0:0:0:0:1", "0000:0000:0000:0000:0000:0000:0000:0001");

    private NetworkHelper() {
    }

    public static boolean isLocalhost(String hostname) {
        if (hostname == null || hostname.isBlank()) {
            return true;
        }
        if (TYPICAL_LOCALHOST_HOSTNAMES.contains(hostname.toLowerCase())) {
            return true;
        }
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            log.warn("Hostname {} - Could not resolve the hostname to a valid IP address. The host is considered remote.", (Object)hostname);
            return false;
        }
        if (inetAddress == null) {
            log.warn("Hostname {} - Could not resolve the hostname to a valid IP address. The host is considered remote.", (Object)hostname);
            return false;
        }
        if (inetAddress.isAnyLocalAddress() || inetAddress.isLoopbackAddress()) {
            return true;
        }
        try {
            return NetworkInterface.getByInetAddress(inetAddress) != null;
        }
        catch (SocketException e) {
            log.warn("Hostname {} - Could not find a network interface associated to this IP address. The network interface is considered remote.", (Object)hostname);
            log.debug("Hostname {} - Exception while checking network interfaces: ", (Object)hostname, (Object)e);
            return false;
        }
    }

    public static String resolveDns(String hostname) {
        String ipAddress = null;
        InetAddress inetAddress = null;
        if (hostname != null && !hostname.isBlank()) {
            try {
                inetAddress = InetAddress.getByName(hostname);
                if (inetAddress != null) {
                    ipAddress = inetAddress.getHostAddress();
                }
            }
            catch (UnknownHostException e) {
                log.warn("Could not resolve {} into an IP address.", (Object)hostname);
                log.debug("UnknownHostException: ", (Throwable)e);
            }
        }
        return ipAddress;
    }

    public static String getFqdn(String hostname) {
        if (hostname != null && !hostname.isBlank()) {
            try {
                InetAddress inetAddress = InetAddress.getByName(hostname);
                if (inetAddress != null) {
                    return inetAddress.getCanonicalHostName();
                }
            }
            catch (UnknownHostException e) {
                log.error("Hostname {} - Could not resolve the hostname to a valid IP address. Cannot retrieve FQDN. Using hostname as FQDN.", (Object)hostname);
                return hostname;
            }
        }
        return hostname;
    }

    public static URL createUrl(@NonNull String protocol, @NonNull String hostnameOrIp, @NonNull Integer portNumber) throws MalformedURLException, UnknownHostException, URISyntaxException {
        if (protocol == null) {
            throw new IllegalArgumentException("protocol is marked non-null but is null");
        }
        if (hostnameOrIp == null) {
            throw new IllegalArgumentException("hostnameOrIp is marked non-null but is null");
        }
        if (portNumber == null) {
            throw new IllegalArgumentException("portNumber is marked non-null but is null");
        }
        InetAddress address = InetAddress.getByName(hostnameOrIp);
        Object uriHost = address instanceof Inet6Address && !IPV6_ENCLOSED_IN_SQUARE_BRACKETS_PATTERN.matcher(hostnameOrIp).matches() ? "[" + hostnameOrIp + "]" : hostnameOrIp;
        return new URI(String.format("%s://%s:%d", protocol, uriHost, portNumber)).toURL();
    }
}

