/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.util.Assert;

public class ResourceHelper {
    public static String getResourceAsString(String path, @NonNull Class<?> clazz) {
        String string;
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is marked non-null but is null");
        }
        Assert.isTrue(path != null && !path.isEmpty(), "path cannot be null or empty");
        BufferedReader reader = new BufferedReader(new InputStreamReader(clazz.getResourceAsStream(path)));
        try {
            string = reader.lines().collect(Collectors.joining("\n"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Assert.state(false, () -> String.format("Cannot load resource file '%s' for class '%s'. Message: %s", path, clazz.getName(), e.getMessage()));
                return "";
            }
        }
        reader.close();
        return string;
    }

    public static File findSourceDirectory(@NonNull Class<?> sourceClass) throws IOException, URISyntaxException {
        File source;
        if (sourceClass == null) {
            throw new IllegalArgumentException("sourceClass is marked non-null but is null");
        }
        ProtectionDomain domain = sourceClass.getProtectionDomain();
        CodeSource codeSource = domain != null ? domain.getCodeSource() : null;
        URL location = codeSource != null ? codeSource.getLocation() : null;
        File file = source = location != null ? ResourceHelper.findSourceDirectory(location) : null;
        if (source != null && source.exists()) {
            return source.getAbsoluteFile();
        }
        return null;
    }

    static File findSourceDirectory(@NonNull URL location) throws IOException, URISyntaxException {
        if (location == null) {
            throw new IllegalArgumentException("location is marked non-null but is null");
        }
        URLConnection connection = location.openConnection();
        if (connection instanceof JarURLConnection) {
            JarURLConnection jarUrlConnection = (JarURLConnection)connection;
            return ResourceHelper.getRootJarFile(jarUrlConnection.getJarFile());
        }
        return new File(location.toURI());
    }

    static File getRootJarFile(@NonNull JarFile jarFile) {
        if (jarFile == null) {
            throw new IllegalArgumentException("jarFile is marked non-null but is null");
        }
        String name = jarFile.getName();
        int separator = name.indexOf("!/");
        if (separator > 0) {
            name = name.substring(0, separator);
        }
        return new File(name);
    }

    @Generated
    private ResourceHelper() {
    }
}

