/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.exception.InvalidConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StringHelper.class);

    public static String getValue(Callable<Object> call, String defaultValue) {
        String value;
        Object result = StringHelper.callIfPossible(call);
        String string = value = result != null ? result.toString() : null;
        if (value == null || value.isBlank()) {
            return defaultValue;
        }
        return value;
    }

    private static Object callIfPossible(Callable<Object> call) {
        try {
            return call.call();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static String getStackMessages(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        return throwable.getClass().getSimpleName() + ": " + throwable.getMessage() + "\n" + Stream.iterate(throwable, Objects::nonNull, Throwable::getCause).filter(th -> th != throwable).map(th -> String.format("Caused by %s: %s", th.getClass().getSimpleName(), th.getMessage())).collect(Collectors.joining("\n"));
    }

    public static String prettyHttpHeaders(Map<String, String> headers) {
        if (headers == null) {
            return "";
        }
        return headers.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).sorted().collect(Collectors.joining("\n"));
    }

    public static <T> void addNonNull(@NonNull StringJoiner stringJoiner, @NonNull String prefix, T value) {
        if (stringJoiner == null) {
            throw new IllegalArgumentException("stringJoiner is marked non-null but is null");
        }
        if (prefix == null) {
            throw new IllegalArgumentException("prefix is marked non-null but is null");
        }
        if (value != null) {
            stringJoiner.add(new StringBuilder(prefix).append(value));
        }
    }

    public static String replace(@NonNull String macro, @NonNull Supplier<String> replacementSupplier, @NonNull String template) {
        if (macro == null) {
            throw new IllegalArgumentException("macro is marked non-null but is null");
        }
        if (replacementSupplier == null) {
            throw new IllegalArgumentException("replacementSupplier is marked non-null but is null");
        }
        if (template == null) {
            throw new IllegalArgumentException("template is marked non-null but is null");
        }
        if (template.contains(macro)) {
            return template.replace(macro, StringHelper.getValue(replacementSupplier::get, macro));
        }
        return template;
    }

    public static String replace(@NonNull String macro, String replacement, @NonNull String template) {
        if (macro == null) {
            throw new IllegalArgumentException("macro is marked non-null but is null");
        }
        if (template == null) {
            throw new IllegalArgumentException("template is marked non-null but is null");
        }
        if (template.contains(macro) && replacement != null) {
            return template.replace(macro, replacement);
        }
        return template;
    }

    public static String stringify(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            return collection.stream().map(item -> item != null ? item.toString() : "").collect(Collectors.joining(","));
        }
        if (value.getClass().isArray()) {
            Object[] array = (Object[])value;
            return Arrays.stream(array).map(item -> item != null ? item.toString() : "").collect(Collectors.joining(","));
        }
        return value.toString();
    }

    public static boolean nonNullNonBlank(String value) {
        return value != null && !value.isBlank();
    }

    public static <T> void validateConfigurationAttribute(T attribute, Predicate<T> errorChecker, Supplier<String> messageSupplier) throws InvalidConfigurationException {
        if (errorChecker.test(attribute)) {
            log.error(messageSupplier.get());
            throw new InvalidConfigurationException(messageSupplier.get());
        }
    }

    @Generated
    private StringHelper() {
    }
}

