/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.common.helpers.state;

import java.util.Map;
import java.util.Optional;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.NumberHelper;

public interface IState {
    public int getNumericValue();

    public static <T extends IState> Optional<T> interpret(String state, @NonNull Map<String, T> stateTranslations, @NonNull Class<T> type) {
        if (stateTranslations == null) {
            throw new IllegalArgumentException("stateTranslations is marked non-null but is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is marked non-null but is null");
        }
        if (state == null || state.isBlank()) {
            return Optional.empty();
        }
        IState status = (IState)stateTranslations.get(NumberHelper.cleanUpEnumInput(state));
        return Optional.ofNullable(status).map(type::cast);
    }
}

