/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.configuration;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.alert.AlertInfo;
import org.sentrysoftware.metricshub.engine.configuration.ConnectorVariables;
import org.sentrysoftware.metricshub.engine.configuration.IConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.CommandLineSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.IpmiSource;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.WmiSource;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;

public class HostConfiguration {
    private String hostname;
    private String hostId;
    private DeviceKind hostType;
    private boolean resolveHostnameToFqdn;
    private long strategyTimeout;
    private Set<String> connectors;
    private boolean sequential;
    private Consumer<AlertInfo> alertTrigger;
    private long retryDelay;
    private Set<String> includedMonitors;
    private Set<String> excludedMonitors;
    private Map<String, ConnectorVariables> connectorVariables;
    private Map<Class<? extends IConfiguration>, IConfiguration> configurations;
    private String configuredConnectorId;

    public Set<Class<? extends Source>> determineAcceptedSources(boolean isLocalhost, ExtensionManager extensionManager) {
        Map<Class<? extends IConfiguration>, Set<Class<? extends Source>>> configurationToSourceMappingFromExtensions = extensionManager.findConfigurationToSourceMapping();
        HashMap<Class<? extends IConfiguration>, Set<Class<? extends Source>>> configurationToSourceMapping = new HashMap<Class<? extends IConfiguration>, Set<Class<? extends Source>>>();
        configurationToSourceMapping.putAll(configurationToSourceMappingFromExtensions);
        Set<Class<? extends IConfiguration>> protocolTypes = this.configurations.keySet();
        Set<Class<? extends Source>> sources = configurationToSourceMapping.entrySet().stream().filter(protocolEntry -> protocolTypes.contains(protocolEntry.getKey())).flatMap(v -> ((Set)v.getValue()).stream()).collect(Collectors.toSet());
        if (!DeviceKind.WINDOWS.equals((Object)this.hostType)) {
            sources.remove(WmiSource.class);
        }
        if (DeviceKind.WINDOWS.equals((Object)this.hostType) && sources.contains(WmiSource.class)) {
            sources.add(IpmiSource.class);
            if (!isLocalhost) {
                sources.add(CommandLineSource.class);
            }
        }
        if ((DeviceKind.LINUX.equals((Object)this.hostType) || DeviceKind.SOLARIS.equals((Object)this.hostType)) && !isLocalhost) {
            sources.add(IpmiSource.class);
        }
        if (isLocalhost) {
            sources.add(CommandLineSource.class);
            if (DeviceKind.LINUX.equals((Object)this.hostType) || DeviceKind.SOLARIS.equals((Object)this.hostType)) {
                sources.add(IpmiSource.class);
            }
        }
        return sources;
    }

    @Generated
    private static long $default$strategyTimeout() {
        return 300L;
    }

    @Generated
    private static Map<Class<? extends IConfiguration>, IConfiguration> $default$configurations() {
        return new HashMap<Class<? extends IConfiguration>, IConfiguration>();
    }

    @Generated
    public static HostConfigurationBuilder builder() {
        return new HostConfigurationBuilder();
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getHostId() {
        return this.hostId;
    }

    @Generated
    public DeviceKind getHostType() {
        return this.hostType;
    }

    @Generated
    public boolean isResolveHostnameToFqdn() {
        return this.resolveHostnameToFqdn;
    }

    @Generated
    public long getStrategyTimeout() {
        return this.strategyTimeout;
    }

    @Generated
    public Set<String> getConnectors() {
        return this.connectors;
    }

    @Generated
    public boolean isSequential() {
        return this.sequential;
    }

    @Generated
    public Consumer<AlertInfo> getAlertTrigger() {
        return this.alertTrigger;
    }

    @Generated
    public long getRetryDelay() {
        return this.retryDelay;
    }

    @Generated
    public Set<String> getIncludedMonitors() {
        return this.includedMonitors;
    }

    @Generated
    public Set<String> getExcludedMonitors() {
        return this.excludedMonitors;
    }

    @Generated
    public Map<String, ConnectorVariables> getConnectorVariables() {
        return this.connectorVariables;
    }

    @Generated
    public Map<Class<? extends IConfiguration>, IConfiguration> getConfigurations() {
        return this.configurations;
    }

    @Generated
    public String getConfiguredConnectorId() {
        return this.configuredConnectorId;
    }

    @Generated
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Generated
    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    @Generated
    public void setHostType(DeviceKind hostType) {
        this.hostType = hostType;
    }

    @Generated
    public void setResolveHostnameToFqdn(boolean resolveHostnameToFqdn) {
        this.resolveHostnameToFqdn = resolveHostnameToFqdn;
    }

    @Generated
    public void setStrategyTimeout(long strategyTimeout) {
        this.strategyTimeout = strategyTimeout;
    }

    @Generated
    public void setConnectors(Set<String> connectors) {
        this.connectors = connectors;
    }

    @Generated
    public void setSequential(boolean sequential) {
        this.sequential = sequential;
    }

    @Generated
    public void setAlertTrigger(Consumer<AlertInfo> alertTrigger) {
        this.alertTrigger = alertTrigger;
    }

    @Generated
    public void setRetryDelay(long retryDelay) {
        this.retryDelay = retryDelay;
    }

    @Generated
    public void setIncludedMonitors(Set<String> includedMonitors) {
        this.includedMonitors = includedMonitors;
    }

    @Generated
    public void setExcludedMonitors(Set<String> excludedMonitors) {
        this.excludedMonitors = excludedMonitors;
    }

    @Generated
    public void setConnectorVariables(Map<String, ConnectorVariables> connectorVariables) {
        this.connectorVariables = connectorVariables;
    }

    @Generated
    public void setConfigurations(Map<Class<? extends IConfiguration>, IConfiguration> configurations) {
        this.configurations = configurations;
    }

    @Generated
    public void setConfiguredConnectorId(String configuredConnectorId) {
        this.configuredConnectorId = configuredConnectorId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HostConfiguration)) {
            return false;
        }
        HostConfiguration other = (HostConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isResolveHostnameToFqdn() != other.isResolveHostnameToFqdn()) {
            return false;
        }
        if (this.getStrategyTimeout() != other.getStrategyTimeout()) {
            return false;
        }
        if (this.isSequential() != other.isSequential()) {
            return false;
        }
        if (this.getRetryDelay() != other.getRetryDelay()) {
            return false;
        }
        String this$hostname = this.getHostname();
        String other$hostname = other.getHostname();
        if (this$hostname == null ? other$hostname != null : !this$hostname.equals(other$hostname)) {
            return false;
        }
        String this$hostId = this.getHostId();
        String other$hostId = other.getHostId();
        if (this$hostId == null ? other$hostId != null : !this$hostId.equals(other$hostId)) {
            return false;
        }
        DeviceKind this$hostType = this.getHostType();
        DeviceKind other$hostType = other.getHostType();
        if (this$hostType == null ? other$hostType != null : !((Object)((Object)this$hostType)).equals((Object)other$hostType)) {
            return false;
        }
        Set<String> this$connectors = this.getConnectors();
        Set<String> other$connectors = other.getConnectors();
        if (this$connectors == null ? other$connectors != null : !((Object)this$connectors).equals(other$connectors)) {
            return false;
        }
        Consumer<AlertInfo> this$alertTrigger = this.getAlertTrigger();
        Consumer<AlertInfo> other$alertTrigger = other.getAlertTrigger();
        if (this$alertTrigger == null ? other$alertTrigger != null : !this$alertTrigger.equals(other$alertTrigger)) {
            return false;
        }
        Set<String> this$includedMonitors = this.getIncludedMonitors();
        Set<String> other$includedMonitors = other.getIncludedMonitors();
        if (this$includedMonitors == null ? other$includedMonitors != null : !((Object)this$includedMonitors).equals(other$includedMonitors)) {
            return false;
        }
        Set<String> this$excludedMonitors = this.getExcludedMonitors();
        Set<String> other$excludedMonitors = other.getExcludedMonitors();
        if (this$excludedMonitors == null ? other$excludedMonitors != null : !((Object)this$excludedMonitors).equals(other$excludedMonitors)) {
            return false;
        }
        Map<String, ConnectorVariables> this$connectorVariables = this.getConnectorVariables();
        Map<String, ConnectorVariables> other$connectorVariables = other.getConnectorVariables();
        if (this$connectorVariables == null ? other$connectorVariables != null : !((Object)this$connectorVariables).equals(other$connectorVariables)) {
            return false;
        }
        Map<Class<? extends IConfiguration>, IConfiguration> this$configurations = this.getConfigurations();
        Map<Class<? extends IConfiguration>, IConfiguration> other$configurations = other.getConfigurations();
        if (this$configurations == null ? other$configurations != null : !((Object)this$configurations).equals(other$configurations)) {
            return false;
        }
        String this$configuredConnectorId = this.getConfiguredConnectorId();
        String other$configuredConnectorId = other.getConfiguredConnectorId();
        return !(this$configuredConnectorId == null ? other$configuredConnectorId != null : !this$configuredConnectorId.equals(other$configuredConnectorId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HostConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isResolveHostnameToFqdn() ? 79 : 97);
        long $strategyTimeout = this.getStrategyTimeout();
        result = result * 59 + (int)($strategyTimeout >>> 32 ^ $strategyTimeout);
        result = result * 59 + (this.isSequential() ? 79 : 97);
        long $retryDelay = this.getRetryDelay();
        result = result * 59 + (int)($retryDelay >>> 32 ^ $retryDelay);
        String $hostname = this.getHostname();
        result = result * 59 + ($hostname == null ? 43 : $hostname.hashCode());
        String $hostId = this.getHostId();
        result = result * 59 + ($hostId == null ? 43 : $hostId.hashCode());
        DeviceKind $hostType = this.getHostType();
        result = result * 59 + ($hostType == null ? 43 : ((Object)((Object)$hostType)).hashCode());
        Set<String> $connectors = this.getConnectors();
        result = result * 59 + ($connectors == null ? 43 : ((Object)$connectors).hashCode());
        Consumer<AlertInfo> $alertTrigger = this.getAlertTrigger();
        result = result * 59 + ($alertTrigger == null ? 43 : $alertTrigger.hashCode());
        Set<String> $includedMonitors = this.getIncludedMonitors();
        result = result * 59 + ($includedMonitors == null ? 43 : ((Object)$includedMonitors).hashCode());
        Set<String> $excludedMonitors = this.getExcludedMonitors();
        result = result * 59 + ($excludedMonitors == null ? 43 : ((Object)$excludedMonitors).hashCode());
        Map<String, ConnectorVariables> $connectorVariables = this.getConnectorVariables();
        result = result * 59 + ($connectorVariables == null ? 43 : ((Object)$connectorVariables).hashCode());
        Map<Class<? extends IConfiguration>, IConfiguration> $configurations = this.getConfigurations();
        result = result * 59 + ($configurations == null ? 43 : ((Object)$configurations).hashCode());
        String $configuredConnectorId = this.getConfiguredConnectorId();
        result = result * 59 + ($configuredConnectorId == null ? 43 : $configuredConnectorId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "HostConfiguration(hostname=" + this.getHostname() + ", hostId=" + this.getHostId() + ", hostType=" + String.valueOf((Object)this.getHostType()) + ", resolveHostnameToFqdn=" + this.isResolveHostnameToFqdn() + ", strategyTimeout=" + this.getStrategyTimeout() + ", connectors=" + String.valueOf(this.getConnectors()) + ", sequential=" + this.isSequential() + ", alertTrigger=" + String.valueOf(this.getAlertTrigger()) + ", retryDelay=" + this.getRetryDelay() + ", includedMonitors=" + String.valueOf(this.getIncludedMonitors()) + ", excludedMonitors=" + String.valueOf(this.getExcludedMonitors()) + ", connectorVariables=" + String.valueOf(this.getConnectorVariables()) + ", configurations=" + String.valueOf(this.getConfigurations()) + ", configuredConnectorId=" + this.getConfiguredConnectorId() + ")";
    }

    @Generated
    public HostConfiguration(String hostname, String hostId, DeviceKind hostType, boolean resolveHostnameToFqdn, long strategyTimeout, Set<String> connectors, boolean sequential, Consumer<AlertInfo> alertTrigger, long retryDelay, Set<String> includedMonitors, Set<String> excludedMonitors, Map<String, ConnectorVariables> connectorVariables, Map<Class<? extends IConfiguration>, IConfiguration> configurations, String configuredConnectorId) {
        this.hostname = hostname;
        this.hostId = hostId;
        this.hostType = hostType;
        this.resolveHostnameToFqdn = resolveHostnameToFqdn;
        this.strategyTimeout = strategyTimeout;
        this.connectors = connectors;
        this.sequential = sequential;
        this.alertTrigger = alertTrigger;
        this.retryDelay = retryDelay;
        this.includedMonitors = includedMonitors;
        this.excludedMonitors = excludedMonitors;
        this.connectorVariables = connectorVariables;
        this.configurations = configurations;
        this.configuredConnectorId = configuredConnectorId;
    }

    @Generated
    public HostConfiguration() {
        this.strategyTimeout = HostConfiguration.$default$strategyTimeout();
        this.configurations = HostConfiguration.$default$configurations();
    }

    @Generated
    public static class HostConfigurationBuilder {
        @Generated
        private String hostname;
        @Generated
        private String hostId;
        @Generated
        private DeviceKind hostType;
        @Generated
        private boolean resolveHostnameToFqdn;
        @Generated
        private boolean strategyTimeout$set;
        @Generated
        private long strategyTimeout$value;
        @Generated
        private Set<String> connectors;
        @Generated
        private boolean sequential;
        @Generated
        private Consumer<AlertInfo> alertTrigger;
        @Generated
        private long retryDelay;
        @Generated
        private Set<String> includedMonitors;
        @Generated
        private Set<String> excludedMonitors;
        @Generated
        private Map<String, ConnectorVariables> connectorVariables;
        @Generated
        private boolean configurations$set;
        @Generated
        private Map<Class<? extends IConfiguration>, IConfiguration> configurations$value;
        @Generated
        private String configuredConnectorId;

        @Generated
        HostConfigurationBuilder() {
        }

        @Generated
        public HostConfigurationBuilder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        @Generated
        public HostConfigurationBuilder hostId(String hostId) {
            this.hostId = hostId;
            return this;
        }

        @Generated
        public HostConfigurationBuilder hostType(DeviceKind hostType) {
            this.hostType = hostType;
            return this;
        }

        @Generated
        public HostConfigurationBuilder resolveHostnameToFqdn(boolean resolveHostnameToFqdn) {
            this.resolveHostnameToFqdn = resolveHostnameToFqdn;
            return this;
        }

        @Generated
        public HostConfigurationBuilder strategyTimeout(long strategyTimeout) {
            this.strategyTimeout$value = strategyTimeout;
            this.strategyTimeout$set = true;
            return this;
        }

        @Generated
        public HostConfigurationBuilder connectors(Set<String> connectors) {
            this.connectors = connectors;
            return this;
        }

        @Generated
        public HostConfigurationBuilder sequential(boolean sequential) {
            this.sequential = sequential;
            return this;
        }

        @Generated
        public HostConfigurationBuilder alertTrigger(Consumer<AlertInfo> alertTrigger) {
            this.alertTrigger = alertTrigger;
            return this;
        }

        @Generated
        public HostConfigurationBuilder retryDelay(long retryDelay) {
            this.retryDelay = retryDelay;
            return this;
        }

        @Generated
        public HostConfigurationBuilder includedMonitors(Set<String> includedMonitors) {
            this.includedMonitors = includedMonitors;
            return this;
        }

        @Generated
        public HostConfigurationBuilder excludedMonitors(Set<String> excludedMonitors) {
            this.excludedMonitors = excludedMonitors;
            return this;
        }

        @Generated
        public HostConfigurationBuilder connectorVariables(Map<String, ConnectorVariables> connectorVariables) {
            this.connectorVariables = connectorVariables;
            return this;
        }

        @Generated
        public HostConfigurationBuilder configurations(Map<Class<? extends IConfiguration>, IConfiguration> configurations) {
            this.configurations$value = configurations;
            this.configurations$set = true;
            return this;
        }

        @Generated
        public HostConfigurationBuilder configuredConnectorId(String configuredConnectorId) {
            this.configuredConnectorId = configuredConnectorId;
            return this;
        }

        @Generated
        public HostConfiguration build() {
            long strategyTimeout$value = this.strategyTimeout$value;
            if (!this.strategyTimeout$set) {
                strategyTimeout$value = HostConfiguration.$default$strategyTimeout();
            }
            Map<Class<? extends IConfiguration>, IConfiguration> configurations$value = this.configurations$value;
            if (!this.configurations$set) {
                configurations$value = HostConfiguration.$default$configurations();
            }
            return new HostConfiguration(this.hostname, this.hostId, this.hostType, this.resolveHostnameToFqdn, strategyTimeout$value, this.connectors, this.sequential, this.alertTrigger, this.retryDelay, this.includedMonitors, this.excludedMonitors, this.connectorVariables, configurations$value, this.configuredConnectorId);
        }

        @Generated
        public String toString() {
            return "HostConfiguration.HostConfigurationBuilder(hostname=" + this.hostname + ", hostId=" + this.hostId + ", hostType=" + String.valueOf((Object)this.hostType) + ", resolveHostnameToFqdn=" + this.resolveHostnameToFqdn + ", strategyTimeout$value=" + this.strategyTimeout$value + ", connectors=" + String.valueOf(this.connectors) + ", sequential=" + this.sequential + ", alertTrigger=" + String.valueOf(this.alertTrigger) + ", retryDelay=" + this.retryDelay + ", includedMonitors=" + String.valueOf(this.includedMonitors) + ", excludedMonitors=" + String.valueOf(this.excludedMonitors) + ", connectorVariables=" + String.valueOf(this.connectorVariables) + ", configurations$value=" + String.valueOf(this.configurations$value) + ", configuredConnectorId=" + this.configuredConnectorId + ")";
        }
    }
}

