/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.deserializer.custom;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;

public class NonBlankDeserializer
extends JsonDeserializer<String> {
    @Override
    public String deserialize(JsonParser parser, DeserializationContext ctxt) throws IOException {
        if (parser == null) {
            return null;
        }
        String key = parser.getCurrentName();
        String value = parser.getValueAsString();
        if (value == null || !value.isBlank()) {
            return value;
        }
        throw new InvalidFormatException(parser, String.format("Invalid blank value encountered for property '%s'.", key), (Object)value, String.class);
    }
}

