/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.common;

import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.MetricsHubConstants;
import org.sentrysoftware.metricshub.engine.connector.model.common.ITranslationTable;

public class ReferenceTranslationTable
implements ITranslationTable {
    private static final long serialVersionUID = 1L;
    private String reference;
    private String tableId;

    public ReferenceTranslationTable(String reference) {
        this.reference = reference;
        Matcher matcher = MetricsHubConstants.TRANSLATION_REF_PATTERN.matcher(reference);
        this.tableId = matcher.find() ? matcher.group(1) : reference;
    }

    @Override
    public ReferenceTranslationTable copy() {
        return new ReferenceTranslationTable(this.reference);
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.reference = (String)updater.apply(this.reference);
        this.tableId = (String)updater.apply(this.tableId);
    }

    @Generated
    public String getReference() {
        return this.reference;
    }

    @Generated
    public String getTableId() {
        return this.tableId;
    }

    @Generated
    public void setReference(String reference) {
        this.reference = reference;
    }

    @Generated
    public void setTableId(String tableId) {
        this.tableId = tableId;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferenceTranslationTable)) {
            return false;
        }
        ReferenceTranslationTable other = (ReferenceTranslationTable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$reference = this.getReference();
        String other$reference = other.getReference();
        if (this$reference == null ? other$reference != null : !this$reference.equals(other$reference)) {
            return false;
        }
        String this$tableId = this.getTableId();
        String other$tableId = other.getTableId();
        return !(this$tableId == null ? other$tableId != null : !this$tableId.equals(other$tableId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReferenceTranslationTable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $reference = this.getReference();
        result = result * 59 + ($reference == null ? 43 : $reference.hashCode());
        String $tableId = this.getTableId();
        result = result * 59 + ($tableId == null ? 43 : $tableId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ReferenceTranslationTable(reference=" + this.getReference() + ", tableId=" + this.getTableId() + ")";
    }

    @Generated
    public ReferenceTranslationTable(String reference, String tableId) {
        this.reference = reference;
        this.tableId = tableId;
    }

    @Generated
    public ReferenceTranslationTable() {
    }
}

