/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.identity;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.ConnectionTypeSetDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.DeviceKindSetDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.SupersedesDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.DeviceKind;
import org.sentrysoftware.metricshub.engine.connector.model.identity.ConnectionType;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;

public class Detection
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonDeserialize(using=ConnectionTypeSetDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    private Set<ConnectionType> connectionTypes = new HashSet<ConnectionType>();
    private boolean disableAutoDetection;
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private String onLastResort;
    @JsonDeserialize(using=DeviceKindSetDeserializer.class)
    @JsonSetter(nulls=Nulls.FAIL)
    @NonNull
    private Set<DeviceKind> appliesTo;
    @JsonDeserialize(using=SupersedesDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    private Set<String> supersedes = new HashSet<String>();
    private List<Criterion> criteria = new ArrayList<Criterion>();
    @JsonSetter(nulls=Nulls.SKIP)
    private Set<String> tags = new HashSet<String>();

    @JsonCreator
    public Detection(@JsonProperty(value="connectionTypes") Set<ConnectionType> connectionTypes, @JsonProperty(value="disableAutoDetection") boolean disableAutoDetection, @JsonProperty(value="onLastResort") String onLastResort, @JsonProperty(value="appliesTo", required=true) @NonNull Set<DeviceKind> appliesTo, @JsonProperty(value="supersedes") Set<String> supersedes, @JsonProperty(value="criteria") List<Criterion> criteria, @JsonProperty(value="tags") Set<String> tags) {
        if (appliesTo == null) {
            throw new IllegalArgumentException("appliesTo is marked non-null but is null");
        }
        this.connectionTypes = connectionTypes == null ? new HashSet<ConnectionType>(Set.of(ConnectionType.LOCAL, ConnectionType.REMOTE)) : connectionTypes;
        this.disableAutoDetection = disableAutoDetection;
        this.onLastResort = onLastResort;
        this.appliesTo = appliesTo;
        this.supersedes = supersedes == null ? new HashSet() : supersedes;
        this.criteria = criteria == null ? new ArrayList() : criteria;
        this.tags = tags == null ? new HashSet() : tags;
    }

    @Generated
    public static DetectionBuilder builder() {
        return new DetectionBuilder();
    }

    @Generated
    public Set<ConnectionType> getConnectionTypes() {
        return this.connectionTypes;
    }

    @Generated
    public boolean isDisableAutoDetection() {
        return this.disableAutoDetection;
    }

    @Generated
    public String getOnLastResort() {
        return this.onLastResort;
    }

    @NonNull
    @Generated
    public Set<DeviceKind> getAppliesTo() {
        return this.appliesTo;
    }

    @Generated
    public Set<String> getSupersedes() {
        return this.supersedes;
    }

    @Generated
    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    @Generated
    public Set<String> getTags() {
        return this.tags;
    }

    @JsonDeserialize(using=ConnectionTypeSetDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setConnectionTypes(Set<ConnectionType> connectionTypes) {
        this.connectionTypes = connectionTypes;
    }

    @Generated
    public void setDisableAutoDetection(boolean disableAutoDetection) {
        this.disableAutoDetection = disableAutoDetection;
    }

    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setOnLastResort(String onLastResort) {
        this.onLastResort = onLastResort;
    }

    @JsonDeserialize(using=DeviceKindSetDeserializer.class)
    @JsonSetter(nulls=Nulls.FAIL)
    @Generated
    public void setAppliesTo(@NonNull Set<DeviceKind> appliesTo) {
        if (appliesTo == null) {
            throw new IllegalArgumentException("appliesTo is marked non-null but is null");
        }
        this.appliesTo = appliesTo;
    }

    @JsonDeserialize(using=SupersedesDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setSupersedes(Set<String> supersedes) {
        this.supersedes = supersedes;
    }

    @Generated
    public void setCriteria(List<Criterion> criteria) {
        this.criteria = criteria;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Detection)) {
            return false;
        }
        Detection other = (Detection)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isDisableAutoDetection() != other.isDisableAutoDetection()) {
            return false;
        }
        Set<ConnectionType> this$connectionTypes = this.getConnectionTypes();
        Set<ConnectionType> other$connectionTypes = other.getConnectionTypes();
        if (this$connectionTypes == null ? other$connectionTypes != null : !((Object)this$connectionTypes).equals(other$connectionTypes)) {
            return false;
        }
        String this$onLastResort = this.getOnLastResort();
        String other$onLastResort = other.getOnLastResort();
        if (this$onLastResort == null ? other$onLastResort != null : !this$onLastResort.equals(other$onLastResort)) {
            return false;
        }
        Set<DeviceKind> this$appliesTo = this.getAppliesTo();
        Set<DeviceKind> other$appliesTo = other.getAppliesTo();
        if (this$appliesTo == null ? other$appliesTo != null : !((Object)this$appliesTo).equals(other$appliesTo)) {
            return false;
        }
        Set<String> this$supersedes = this.getSupersedes();
        Set<String> other$supersedes = other.getSupersedes();
        if (this$supersedes == null ? other$supersedes != null : !((Object)this$supersedes).equals(other$supersedes)) {
            return false;
        }
        List<Criterion> this$criteria = this.getCriteria();
        List<Criterion> other$criteria = other.getCriteria();
        if (this$criteria == null ? other$criteria != null : !((Object)this$criteria).equals(other$criteria)) {
            return false;
        }
        Set<String> this$tags = this.getTags();
        Set<String> other$tags = other.getTags();
        return !(this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Detection;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isDisableAutoDetection() ? 79 : 97);
        Set<ConnectionType> $connectionTypes = this.getConnectionTypes();
        result = result * 59 + ($connectionTypes == null ? 43 : ((Object)$connectionTypes).hashCode());
        String $onLastResort = this.getOnLastResort();
        result = result * 59 + ($onLastResort == null ? 43 : $onLastResort.hashCode());
        Set<DeviceKind> $appliesTo = this.getAppliesTo();
        result = result * 59 + ($appliesTo == null ? 43 : ((Object)$appliesTo).hashCode());
        Set<String> $supersedes = this.getSupersedes();
        result = result * 59 + ($supersedes == null ? 43 : ((Object)$supersedes).hashCode());
        List<Criterion> $criteria = this.getCriteria();
        result = result * 59 + ($criteria == null ? 43 : ((Object)$criteria).hashCode());
        Set<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Detection(connectionTypes=" + String.valueOf(this.getConnectionTypes()) + ", disableAutoDetection=" + this.isDisableAutoDetection() + ", onLastResort=" + this.getOnLastResort() + ", appliesTo=" + String.valueOf(this.getAppliesTo()) + ", supersedes=" + String.valueOf(this.getSupersedes()) + ", criteria=" + String.valueOf(this.getCriteria()) + ", tags=" + String.valueOf(this.getTags()) + ")";
    }

    @Generated
    public Detection() {
    }

    @Generated
    public static class DetectionBuilder {
        @Generated
        private Set<ConnectionType> connectionTypes;
        @Generated
        private boolean disableAutoDetection;
        @Generated
        private String onLastResort;
        @Generated
        private Set<DeviceKind> appliesTo;
        @Generated
        private Set<String> supersedes;
        @Generated
        private List<Criterion> criteria;
        @Generated
        private Set<String> tags;

        @Generated
        DetectionBuilder() {
        }

        @JsonProperty(value="connectionTypes")
        @Generated
        public DetectionBuilder connectionTypes(Set<ConnectionType> connectionTypes) {
            this.connectionTypes = connectionTypes;
            return this;
        }

        @JsonProperty(value="disableAutoDetection")
        @Generated
        public DetectionBuilder disableAutoDetection(boolean disableAutoDetection) {
            this.disableAutoDetection = disableAutoDetection;
            return this;
        }

        @JsonProperty(value="onLastResort")
        @Generated
        public DetectionBuilder onLastResort(String onLastResort) {
            this.onLastResort = onLastResort;
            return this;
        }

        @JsonProperty(value="appliesTo", required=true)
        @Generated
        public DetectionBuilder appliesTo(@NonNull Set<DeviceKind> appliesTo) {
            if (appliesTo == null) {
                throw new IllegalArgumentException("appliesTo is marked non-null but is null");
            }
            this.appliesTo = appliesTo;
            return this;
        }

        @JsonProperty(value="supersedes")
        @Generated
        public DetectionBuilder supersedes(Set<String> supersedes) {
            this.supersedes = supersedes;
            return this;
        }

        @JsonProperty(value="criteria")
        @Generated
        public DetectionBuilder criteria(List<Criterion> criteria) {
            this.criteria = criteria;
            return this;
        }

        @JsonProperty(value="tags")
        @Generated
        public DetectionBuilder tags(Set<String> tags) {
            this.tags = tags;
            return this;
        }

        @Generated
        public Detection build() {
            return new Detection(this.connectionTypes, this.disableAutoDetection, this.onLastResort, this.appliesTo, this.supersedes, this.criteria, this.tags);
        }

        @Generated
        public String toString() {
            return "Detection.DetectionBuilder(connectionTypes=" + String.valueOf(this.connectionTypes) + ", disableAutoDetection=" + this.disableAutoDetection + ", onLastResort=" + this.onLastResort + ", appliesTo=" + String.valueOf(this.appliesTo) + ", supersedes=" + String.valueOf(this.supersedes) + ", criteria=" + String.valueOf(this.criteria) + ", tags=" + String.valueOf(this.tags) + ")";
        }
    }
}

