/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.identity.criterion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.StringJoiner;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.BooleanDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.TimeoutDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;

public class CommandLineCriterion
extends Criterion {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @NonNull
    private String commandLine;
    private String errorMessage;
    private String expectedResult;
    @JsonDeserialize(using=BooleanDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean executeLocally = false;
    @JsonDeserialize(using=TimeoutDeserializer.class)
    private Long timeout;

    @JsonCreator
    public CommandLineCriterion(@JsonProperty(value="type") String type, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="commandLine", required=true) @NonNull String commandLine, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="expectedResult") String expectedResult, @JsonProperty(value="executeLocally") Boolean executeLocally, @JsonProperty(value="timeout") Long timeout) {
        super(type, forceSerialization);
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        this.commandLine = commandLine;
        this.errorMessage = errorMessage;
        this.expectedResult = expectedResult;
        this.executeLocally = executeLocally != null && executeLocally != false;
        this.timeout = timeout;
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        if (this.commandLine != null && !this.commandLine.isBlank()) {
            stringJoiner.add(new StringBuilder("- CommandLine: ").append(this.commandLine));
        }
        stringJoiner.add(new StringBuilder("- ExecuteLocally: ").append(this.executeLocally));
        if (this.expectedResult != null) {
            stringJoiner.add(new StringBuilder("- ExpectedResult: ").append(this.expectedResult));
        }
        if (this.timeout != null) {
            stringJoiner.add(new StringBuilder("- Timeout: ").append(this.timeout));
        }
        return stringJoiner.toString();
    }

    @Generated
    public static CommandLineCriterionBuilder builder() {
        return new CommandLineCriterionBuilder();
    }

    @NonNull
    @Generated
    public String getCommandLine() {
        return this.commandLine;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public String getExpectedResult() {
        return this.expectedResult;
    }

    @Generated
    public Boolean getExecuteLocally() {
        return this.executeLocally;
    }

    @Generated
    public Long getTimeout() {
        return this.timeout;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setCommandLine(@NonNull String commandLine) {
        if (commandLine == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        this.commandLine = commandLine;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    @JsonDeserialize(using=BooleanDeserializer.class)
    @JsonSetter(nulls=Nulls.SKIP)
    @Generated
    public void setExecuteLocally(Boolean executeLocally) {
        this.executeLocally = executeLocally;
    }

    @JsonDeserialize(using=TimeoutDeserializer.class)
    @Generated
    public void setTimeout(Long timeout) {
        this.timeout = timeout;
    }

    @Generated
    public CommandLineCriterion() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandLineCriterion)) {
            return false;
        }
        CommandLineCriterion other = (CommandLineCriterion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$executeLocally = this.getExecuteLocally();
        Boolean other$executeLocally = other.getExecuteLocally();
        if (this$executeLocally == null ? other$executeLocally != null : !((Object)this$executeLocally).equals(other$executeLocally)) {
            return false;
        }
        Long this$timeout = this.getTimeout();
        Long other$timeout = other.getTimeout();
        if (this$timeout == null ? other$timeout != null : !((Object)this$timeout).equals(other$timeout)) {
            return false;
        }
        String this$commandLine = this.getCommandLine();
        String other$commandLine = other.getCommandLine();
        if (this$commandLine == null ? other$commandLine != null : !this$commandLine.equals(other$commandLine)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) {
            return false;
        }
        String this$expectedResult = this.getExpectedResult();
        String other$expectedResult = other.getExpectedResult();
        return !(this$expectedResult == null ? other$expectedResult != null : !this$expectedResult.equals(other$expectedResult));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommandLineCriterion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $executeLocally = this.getExecuteLocally();
        result = result * 59 + ($executeLocally == null ? 43 : ((Object)$executeLocally).hashCode());
        Long $timeout = this.getTimeout();
        result = result * 59 + ($timeout == null ? 43 : ((Object)$timeout).hashCode());
        String $commandLine = this.getCommandLine();
        result = result * 59 + ($commandLine == null ? 43 : $commandLine.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        String $expectedResult = this.getExpectedResult();
        result = result * 59 + ($expectedResult == null ? 43 : $expectedResult.hashCode());
        return result;
    }

    @Generated
    public static class CommandLineCriterionBuilder {
        @Generated
        private String type;
        @Generated
        private boolean forceSerialization;
        @Generated
        private String commandLine;
        @Generated
        private String errorMessage;
        @Generated
        private String expectedResult;
        @Generated
        private Boolean executeLocally;
        @Generated
        private Long timeout;

        @Generated
        CommandLineCriterionBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public CommandLineCriterionBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public CommandLineCriterionBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="commandLine", required=true)
        @Generated
        public CommandLineCriterionBuilder commandLine(@NonNull String commandLine) {
            if (commandLine == null) {
                throw new IllegalArgumentException("commandLine is marked non-null but is null");
            }
            this.commandLine = commandLine;
            return this;
        }

        @JsonProperty(value="errorMessage")
        @Generated
        public CommandLineCriterionBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        @JsonProperty(value="expectedResult")
        @Generated
        public CommandLineCriterionBuilder expectedResult(String expectedResult) {
            this.expectedResult = expectedResult;
            return this;
        }

        @JsonProperty(value="executeLocally")
        @Generated
        public CommandLineCriterionBuilder executeLocally(Boolean executeLocally) {
            this.executeLocally = executeLocally;
            return this;
        }

        @JsonProperty(value="timeout")
        @Generated
        public CommandLineCriterionBuilder timeout(Long timeout) {
            this.timeout = timeout;
            return this;
        }

        @Generated
        public CommandLineCriterion build() {
            return new CommandLineCriterion(this.type, this.forceSerialization, this.commandLine, this.errorMessage, this.expectedResult, this.executeLocally, this.timeout);
        }

        @Generated
        public String toString() {
            return "CommandLineCriterion.CommandLineCriterionBuilder(type=" + this.type + ", forceSerialization=" + this.forceSerialization + ", commandLine=" + this.commandLine + ", errorMessage=" + this.errorMessage + ", expectedResult=" + this.expectedResult + ", executeLocally=" + this.executeLocally + ", timeout=" + this.timeout + ")";
        }
    }
}

