/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.identity.criterion;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;

public abstract class WqlCriterion
extends Criterion {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @NonNull
    private String query;
    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    private String namespace = "root/cimv2";
    private String expectedResult;
    private String errorMessage;

    protected WqlCriterion(String type, boolean forceSerialization, @NonNull String query, String namespace, String expectedResult, String errorMessage) {
        super(type, forceSerialization);
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        this.query = query;
        this.namespace = namespace == null ? "root/cimv2" : namespace;
        this.expectedResult = expectedResult;
        this.errorMessage = errorMessage;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("- WQL Query: ").append(this.query).append("\n- Namespace: ").append(this.namespace);
        if (this.expectedResult != null && !this.expectedResult.isBlank()) {
            sb.append("\n- Expected Result: ").append(this.expectedResult);
        }
        return sb.toString();
    }

    public abstract WqlCriterion copy();

    @NonNull
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getExpectedResult() {
        return this.expectedResult;
    }

    @Generated
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setQuery(@NonNull String query) {
        if (query == null) {
            throw new IllegalArgumentException("query is marked non-null but is null");
        }
        this.query = query;
    }

    @JsonSetter(nulls=Nulls.SKIP)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setExpectedResult(String expectedResult) {
        this.expectedResult = expectedResult;
    }

    @Generated
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public WqlCriterion() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WqlCriterion)) {
            return false;
        }
        WqlCriterion other = (WqlCriterion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        String this$expectedResult = this.getExpectedResult();
        String other$expectedResult = other.getExpectedResult();
        if (this$expectedResult == null ? other$expectedResult != null : !this$expectedResult.equals(other$expectedResult)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WqlCriterion;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        String $expectedResult = this.getExpectedResult();
        result = result * 59 + ($expectedResult == null ? 43 : $expectedResult.hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }
}

