/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

public class JawkSource
extends Source {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @NonNull
    private String script;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @NonNull
    private String input;
    private String separators;

    @JsonCreator
    public JawkSource(@JsonProperty(value="type") String type, @JsonProperty(value="computes") List<Compute> computes, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="key") String key, @JsonProperty(value="executeForEachEntryOf") ExecuteForEachEntryOf executeForEachEntryOf, @JsonProperty(value="script") String script, @JsonProperty(value="input") String input, @JsonProperty(value="separators") String separators) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        this.script = script;
        this.input = input;
        this.separators = separators;
    }

    @Override
    public Source copy() {
        return JawkSource.builder().type(this.type).key(this.key).forceSerialization(this.forceSerialization).computes((List<Compute>)(this.getComputes() != null ? new ArrayList<Compute>(this.getComputes()) : null)).executeForEachEntryOf(this.executeForEachEntryOf != null ? this.executeForEachEntryOf.copy() : null).script(this.script).input(this.input).separators(this.separators).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
    }

    @Override
    public SourceTable accept(ISourceProcessor sourceProcessor) {
        return sourceProcessor.process(this);
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- script=", this.script);
        StringHelper.addNonNull(stringJoiner, "- input=", this.input);
        StringHelper.addNonNull(stringJoiner, "- separators=", this.separators);
        return stringJoiner.toString();
    }

    @Generated
    public static JawkSourceBuilder builder() {
        return new JawkSourceBuilder();
    }

    @NonNull
    @Generated
    public String getScript() {
        return this.script;
    }

    @NonNull
    @Generated
    public String getInput() {
        return this.input;
    }

    @Generated
    public String getSeparators() {
        return this.separators;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @Generated
    public void setScript(@NonNull String script) {
        if (script == null) {
            throw new IllegalArgumentException("script is marked non-null but is null");
        }
        this.script = script;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setInput(@NonNull String input) {
        if (input == null) {
            throw new IllegalArgumentException("input is marked non-null but is null");
        }
        this.input = input;
    }

    @Generated
    public void setSeparators(String separators) {
        this.separators = separators;
    }

    @Generated
    public JawkSource() {
    }

    @Generated
    public JawkSource(@NonNull String script, @NonNull String input, String separators) {
        if (script == null) {
            throw new IllegalArgumentException("script is marked non-null but is null");
        }
        if (input == null) {
            throw new IllegalArgumentException("input is marked non-null but is null");
        }
        this.script = script;
        this.input = input;
        this.separators = separators;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JawkSource)) {
            return false;
        }
        JawkSource other = (JawkSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$script = this.getScript();
        String other$script = other.getScript();
        if (this$script == null ? other$script != null : !this$script.equals(other$script)) {
            return false;
        }
        String this$input = this.getInput();
        String other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        String this$separators = this.getSeparators();
        String other$separators = other.getSeparators();
        return !(this$separators == null ? other$separators != null : !this$separators.equals(other$separators));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JawkSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $script = this.getScript();
        result = result * 59 + ($script == null ? 43 : $script.hashCode());
        String $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        String $separators = this.getSeparators();
        result = result * 59 + ($separators == null ? 43 : $separators.hashCode());
        return result;
    }

    @Generated
    public static class JawkSourceBuilder {
        @Generated
        private String script;
        @Generated
        private String input;
        @Generated
        private String separators;
        @Generated
        private String type;
        @Generated
        private List<Compute> computes;
        @Generated
        private boolean forceSerialization;
        @Generated
        private String key;
        @Generated
        private ExecuteForEachEntryOf executeForEachEntryOf;

        @Generated
        JawkSourceBuilder() {
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @Generated
        public JawkSourceBuilder script(@NonNull String script) {
            if (script == null) {
                throw new IllegalArgumentException("script is marked non-null but is null");
            }
            this.script = script;
            return this;
        }

        @JsonSetter(nulls=Nulls.FAIL)
        @JsonDeserialize(using=NonBlankDeserializer.class)
        @Generated
        public JawkSourceBuilder input(@NonNull String input) {
            if (input == null) {
                throw new IllegalArgumentException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        @Generated
        public JawkSourceBuilder separators(String separators) {
            this.separators = separators;
            return this;
        }

        @Generated
        public JawkSource build() {
            return new JawkSource(this.script, this.input, this.separators);
        }

        @Generated
        public String toString() {
            return "JawkSource.JawkSourceBuilder(script=" + this.script + ", input=" + this.input + ", separators=" + this.separators + ")";
        }

        @JsonProperty(value="type")
        @Generated
        public JawkSourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="computes")
        @Generated
        public JawkSourceBuilder computes(List<Compute> computes) {
            this.computes = computes;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public JawkSourceBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="key")
        @Generated
        public JawkSourceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="executeForEachEntryOf")
        @Generated
        public JawkSourceBuilder executeForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
            this.executeForEachEntryOf = executeForEachEntryOf;
            return this;
        }
    }
}

