/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.NonBlankDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;

public abstract class SnmpSource
extends Source {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @NonNull
    protected String oid;

    protected SnmpSource(String type, List<Compute> computes, boolean forceSerialization, @NonNull String oid, String key, ExecuteForEachEntryOf executeForEachEntryOf) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        this.oid = oid;
    }

    @Override
    public void update(UnaryOperator<String> updater) {
        this.oid = (String)updater.apply(this.oid);
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- oid=", this.oid);
        return stringJoiner.toString();
    }

    @NonNull
    @Generated
    public String getOid() {
        return this.oid;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=NonBlankDeserializer.class)
    @Generated
    public void setOid(@NonNull String oid) {
        if (oid == null) {
            throw new IllegalArgumentException("oid is marked non-null but is null");
        }
        this.oid = oid;
    }

    @Generated
    public SnmpSource() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SnmpSource)) {
            return false;
        }
        SnmpSource other = (SnmpSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$oid = this.getOid();
        String other$oid = other.getOid();
        return !(this$oid == null ? other$oid != null : !this$oid.equals(other$oid));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SnmpSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $oid = this.getOid();
        result = result * 59 + ($oid == null ? 43 : $oid.hashCode());
        return result;
    }
}

