/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.UnaryOperator;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.common.helpers.StringHelper;
import org.sentrysoftware.metricshub.engine.connector.deserializer.custom.TablesDeserializer;
import org.sentrysoftware.metricshub.engine.connector.model.common.ExecuteForEachEntryOf;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.strategy.source.ISourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;

public class TableUnionSource
extends Source {
    private static final long serialVersionUID = 1L;
    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=TablesDeserializer.class)
    @NonNull
    private List<String> tables = new ArrayList<String>();

    @JsonCreator
    public TableUnionSource(@JsonProperty(value="type") String type, @JsonProperty(value="computes") List<Compute> computes, @JsonProperty(value="forceSerialization") boolean forceSerialization, @JsonProperty(value="tables", required=true) @NonNull List<String> tables, @JsonProperty(value="key") String key, @JsonProperty(value="executeForEachEntryOf") ExecuteForEachEntryOf executeForEachEntryOf) {
        super(type, computes, forceSerialization, key, executeForEachEntryOf);
        if (tables == null) {
            throw new IllegalArgumentException("tables is marked non-null but is null");
        }
        this.tables = tables;
    }

    @Override
    public TableUnionSource copy() {
        return TableUnionSource.builder().type(this.type).key(this.key).forceSerialization(this.forceSerialization).computes((List<Compute>)(this.getComputes() != null ? new ArrayList<Compute>(this.getComputes()) : null)).executeForEachEntryOf(this.executeForEachEntryOf != null ? this.executeForEachEntryOf.copy() : null).tables((List<String>)(this.tables != null ? new ArrayList<String>(this.tables) : null)).build();
    }

    @Override
    public void update(UnaryOperator<String> updater) {
    }

    @Override
    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("\n");
        stringJoiner.add(super.toString());
        StringHelper.addNonNull(stringJoiner, "- tables=", this.tables);
        return stringJoiner.toString();
    }

    @Override
    public SourceTable accept(ISourceProcessor sourceProcessor) {
        return sourceProcessor.process(this);
    }

    @Generated
    public static TableUnionSourceBuilder builder() {
        return new TableUnionSourceBuilder();
    }

    @NonNull
    @Generated
    public List<String> getTables() {
        return this.tables;
    }

    @JsonSetter(nulls=Nulls.FAIL)
    @JsonDeserialize(using=TablesDeserializer.class)
    @Generated
    public void setTables(@NonNull List<String> tables) {
        if (tables == null) {
            throw new IllegalArgumentException("tables is marked non-null but is null");
        }
        this.tables = tables;
    }

    @Generated
    public TableUnionSource() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TableUnionSource)) {
            return false;
        }
        TableUnionSource other = (TableUnionSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<String> this$tables = this.getTables();
        List<String> other$tables = other.getTables();
        return !(this$tables == null ? other$tables != null : !((Object)this$tables).equals(other$tables));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TableUnionSource;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<String> $tables = this.getTables();
        result = result * 59 + ($tables == null ? 43 : ((Object)$tables).hashCode());
        return result;
    }

    @Generated
    public static class TableUnionSourceBuilder {
        @Generated
        private String type;
        @Generated
        private List<Compute> computes;
        @Generated
        private boolean forceSerialization;
        @Generated
        private List<String> tables;
        @Generated
        private String key;
        @Generated
        private ExecuteForEachEntryOf executeForEachEntryOf;

        @Generated
        TableUnionSourceBuilder() {
        }

        @JsonProperty(value="type")
        @Generated
        public TableUnionSourceBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="computes")
        @Generated
        public TableUnionSourceBuilder computes(List<Compute> computes) {
            this.computes = computes;
            return this;
        }

        @JsonProperty(value="forceSerialization")
        @Generated
        public TableUnionSourceBuilder forceSerialization(boolean forceSerialization) {
            this.forceSerialization = forceSerialization;
            return this;
        }

        @JsonProperty(value="tables", required=true)
        @Generated
        public TableUnionSourceBuilder tables(@NonNull List<String> tables) {
            if (tables == null) {
                throw new IllegalArgumentException("tables is marked non-null but is null");
            }
            this.tables = tables;
            return this;
        }

        @JsonProperty(value="key")
        @Generated
        public TableUnionSourceBuilder key(String key) {
            this.key = key;
            return this;
        }

        @JsonProperty(value="executeForEachEntryOf")
        @Generated
        public TableUnionSourceBuilder executeForEachEntryOf(ExecuteForEachEntryOf executeForEachEntryOf) {
            this.executeForEachEntryOf = executeForEachEntryOf;
            return this;
        }

        @Generated
        public TableUnionSource build() {
            return new TableUnionSource(this.type, this.computes, this.forceSerialization, this.tables, this.key, this.executeForEachEntryOf);
        }

        @Generated
        public String toString() {
            return "TableUnionSource.TableUnionSourceBuilder(type=" + this.type + ", computes=" + String.valueOf(this.computes) + ", forceSerialization=" + this.forceSerialization + ", tables=" + String.valueOf(this.tables) + ", key=" + this.key + ", executeForEachEntryOf=" + String.valueOf(this.executeForEachEntryOf) + ")";
        }
    }
}

