/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.common.helpers.FileHelper;
import org.sentrysoftware.metricshub.engine.common.helpers.JsonHelper;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.parser.ConnectorParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectorLibraryParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectorLibraryParser.class);
    public static final String CONNECTOR_PARSING_ERROR = "Error while parsing connector {}: {}";
    public static final ObjectMapper OBJECT_MAPPER = JsonHelper.buildYamlMapper();

    public Map<String, Connector> parseConnectorsFromAllYamlFiles(Path yamlParentDirectory) throws IOException {
        long startTime = System.currentTimeMillis();
        ConnectorFileVisitor fileVisitor = new ConnectorFileVisitor();
        Files.walkFileTree(yamlParentDirectory, fileVisitor);
        log.info("Connectors parsing duration: {} seconds", (Object)((System.currentTimeMillis() - startTime) / 1000L));
        return fileVisitor.getConnectorsMap();
    }

    private class ConnectorFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Map<String, Connector> connectorsMap = new TreeMap<String, Connector>(String.CASE_INSENSITIVE_ORDER);

        private ConnectorFileVisitor() {
        }

        public Map<String, Connector> getConnectorsMap() {
            return this.connectorsMap;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String filename = file.getFileName().toString();
            if (this.isZipFile(filename)) {
                this.readZipFile(file);
                return FileVisitResult.CONTINUE;
            }
            if (Files.isDirectory(file, new LinkOption[0]) || !this.isYamlFile(file.toFile().getName())) {
                return FileVisitResult.CONTINUE;
            }
            JsonNode connectorNode = OBJECT_MAPPER.readTree(file.toFile());
            if (!this.isConnector(connectorNode)) {
                return FileVisitResult.CONTINUE;
            }
            ConnectorParser connectorParser = ConnectorParser.withNodeProcessorAndUpdateChain(file.getParent());
            try {
                Connector connector = connectorParser.parse(file.toFile());
                this.connectorsMap.put(filename.substring(0, filename.lastIndexOf(46)), connector);
            }
            catch (Exception e) {
                log.error(ConnectorLibraryParser.CONNECTOR_PARSING_ERROR, (Object)filename, (Object)e.getMessage());
                log.debug("Exception: ", (Throwable)e);
            }
            return FileVisitResult.CONTINUE;
        }

        private void readZipFile(Path zipPath) throws IOException {
            try (FileSystem zipFileSystem = FileSystems.newFileSystem(zipPath);){
                Path root = zipFileSystem.getPath("/", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
                        String strPath = path.toString();
                        if (!ConnectorFileVisitor.this.isYamlFile(strPath)) {
                            return FileVisitResult.CONTINUE;
                        }
                        JsonNode connectorNode = OBJECT_MAPPER.readTree(Files.newInputStream(path, new OpenOption[0]));
                        if (!ConnectorFileVisitor.this.isConnector(connectorNode)) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path connectorFolder = path.getParent();
                        URI connectorFolderUri = connectorFolder.toUri();
                        ConnectorParser connectorParser = ConnectorParser.withNodeProcessorAndUpdateChain(connectorFolder);
                        String fileName = strPath.substring(strPath.lastIndexOf(47) + 1);
                        FileHelper.fileSystemTask(connectorFolderUri, Collections.emptyMap(), () -> {
                            try {
                                Connector connector = connectorParser.parse(Files.newInputStream(path, new OpenOption[0]), connectorFolderUri, fileName);
                                ConnectorFileVisitor.this.connectorsMap.put(fileName.substring(0, fileName.lastIndexOf(46)), connector);
                            }
                            catch (Exception e) {
                                log.error(ConnectorLibraryParser.CONNECTOR_PARSING_ERROR, (Object)fileName, (Object)e.getMessage());
                                log.debug("Exception: ", (Throwable)e);
                            }
                        });
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException exception) {
                log.error("Error while reading zip file {}: {}", (Object)zipPath.getFileName().toString(), (Object)exception.getMessage());
                throw exception;
            }
        }

        private boolean isConnector(JsonNode connector) {
            JsonNode connectorNode = connector.get("connector");
            if (connectorNode != null && !connectorNode.isNull()) {
                JsonNode displayName = connectorNode.get("displayName");
                return displayName != null && !displayName.isNull();
            }
            return false;
        }

        private boolean isYamlFile(String name) {
            return name.toLowerCase().endsWith(".yaml");
        }

        private boolean isZipFile(String name) {
            return name.toLowerCase().endsWith(".zip");
        }
    }
}

