/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractNodeProcessor;
import org.sentrysoftware.metricshub.engine.connector.parser.JsonNodeUpdater;

public class EnvironmentProcessor
extends AbstractNodeProcessor {
    private static final Pattern ENV_PATTERN = Pattern.compile("\\$\\{env::([\\w-]+)\\}");

    public EnvironmentProcessor() {
        super(null);
    }

    @Override
    protected JsonNode processNode(JsonNode node) {
        UnaryOperator updater = this::performEnvReplacements;
        Predicate<String> replacementPredicate = Objects::nonNull;
        JsonNodeUpdater.jsonNodeUpdaterBuilder().withJsonNode(node).withPredicate(replacementPredicate).withUpdater(updater).build().update();
        return node;
    }

    private String performEnvReplacements(String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        return ENV_PATTERN.matcher(value).replaceAll(match -> {
            String variableValue = System.getenv(match.group(1));
            if (variableValue != null) {
                return Matcher.quoteReplacement(variableValue);
            }
            return Matcher.quoteReplacement(match.group());
        });
    }

    @Override
    @Generated
    public String toString() {
        return "EnvironmentProcessor()";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EnvironmentProcessor)) {
            return false;
        }
        EnvironmentProcessor other = (EnvironmentProcessor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EnvironmentProcessor;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

