/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.connector.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.function.BinaryOperator;
import java.util.function.Predicate;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.connector.parser.AbstractJsonNodeUpdater;

public class JsonNodeContextUpdater
extends AbstractJsonNodeUpdater {
    @NonNull
    private final BinaryOperator<String> updater;

    public JsonNodeContextUpdater(@NonNull JsonNode jsonNode, @NonNull Predicate<String> predicate, @NonNull BinaryOperator<String> updater) {
        super(jsonNode, predicate);
        if (jsonNode == null) {
            throw new IllegalArgumentException("jsonNode is marked non-null but is null");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("predicate is marked non-null but is null");
        }
        if (updater == null) {
            throw new IllegalArgumentException("updater is marked non-null but is null");
        }
        this.updater = updater;
    }

    @Override
    public void update() {
        this.update(this.jsonNode, "");
    }

    private void update(JsonNode node, String currentPath) {
        block6: {
            block5: {
                if (node == null) {
                    return;
                }
                if (!node.isObject()) break block5;
                ArrayList fieldNames = new ArrayList(node.size());
                node.fieldNames().forEachRemaining(fieldNames::add);
                for (String fieldName : fieldNames) {
                    String newPath;
                    JsonNode child = node.get(fieldName);
                    String string = newPath = currentPath.isEmpty() ? fieldName : currentPath + "." + fieldName;
                    if (child.isContainerNode()) {
                        this.update(child, newPath);
                        continue;
                    }
                    if (child.isNull()) continue;
                    String oldValue = child.asText();
                    this.runUpdate(() -> ((ObjectNode)node).set(fieldName, new TextNode((String)this.updater.apply(oldValue, newPath))), oldValue);
                }
                break block6;
            }
            if (!node.isArray()) break block6;
            for (int i = 0; i < node.size(); ++i) {
                JsonNode child = node.get(i);
                String newPath = currentPath + "[" + i + "]";
                if (child.isContainerNode()) {
                    this.update(child, newPath);
                    continue;
                }
                if (child.isNull()) continue;
                String oldValue = child.asText();
                int index = i;
                this.runUpdate(() -> ((ArrayNode)node).set(index, new TextNode((String)this.updater.apply(oldValue, newPath))), oldValue);
            }
        }
    }

    @Generated
    public static JsonNodeContextUpdaterBuilder jsonNodeContextUpdaterBuilder() {
        return new JsonNodeContextUpdaterBuilder();
    }

    @NonNull
    @Generated
    public BinaryOperator<String> getUpdater() {
        return this.updater;
    }

    @Override
    @Generated
    public String toString() {
        return "JsonNodeContextUpdater(updater=" + String.valueOf(this.getUpdater()) + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonNodeContextUpdater)) {
            return false;
        }
        JsonNodeContextUpdater other = (JsonNodeContextUpdater)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BinaryOperator<String> this$updater = this.getUpdater();
        BinaryOperator<String> other$updater = other.getUpdater();
        return !(this$updater == null ? other$updater != null : !this$updater.equals(other$updater));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonNodeContextUpdater;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        BinaryOperator<String> $updater = this.getUpdater();
        result = result * 59 + ($updater == null ? 43 : $updater.hashCode());
        return result;
    }

    @Generated
    public static class JsonNodeContextUpdaterBuilder {
        @Generated
        private JsonNode jsonNode;
        @Generated
        private Predicate<String> predicate;
        @Generated
        private BinaryOperator<String> updater;

        @Generated
        JsonNodeContextUpdaterBuilder() {
        }

        @Generated
        public JsonNodeContextUpdaterBuilder withJsonNode(@NonNull JsonNode jsonNode) {
            if (jsonNode == null) {
                throw new IllegalArgumentException("jsonNode is marked non-null but is null");
            }
            this.jsonNode = jsonNode;
            return this;
        }

        @Generated
        public JsonNodeContextUpdaterBuilder withPredicate(@NonNull Predicate<String> predicate) {
            if (predicate == null) {
                throw new IllegalArgumentException("predicate is marked non-null but is null");
            }
            this.predicate = predicate;
            return this;
        }

        @Generated
        public JsonNodeContextUpdaterBuilder withUpdater(@NonNull BinaryOperator<String> updater) {
            if (updater == null) {
                throw new IllegalArgumentException("updater is marked non-null but is null");
            }
            this.updater = updater;
            return this;
        }

        @Generated
        public JsonNodeContextUpdater build() {
            return new JsonNodeContextUpdater(this.jsonNode, this.predicate, this.updater);
        }

        @Generated
        public String toString() {
            return "JsonNodeContextUpdater.JsonNodeContextUpdaterBuilder(jsonNode=" + String.valueOf(this.jsonNode) + ", predicate=" + String.valueOf(this.predicate) + ", updater=" + String.valueOf(this.updater) + ")";
        }
    }
}

