/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.common.JobInfo;
import org.sentrysoftware.metricshub.engine.common.exception.RetryableException;
import org.sentrysoftware.metricshub.engine.common.helpers.KnownMonitorType;
import org.sentrysoftware.metricshub.engine.common.helpers.TextTableHelper;
import org.sentrysoftware.metricshub.engine.configuration.HostConfiguration;
import org.sentrysoftware.metricshub.engine.connector.model.Connector;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.Source;
import org.sentrysoftware.metricshub.engine.connector.model.monitor.task.source.compute.Compute;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.strategy.IStrategy;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorSelection;
import org.sentrysoftware.metricshub.engine.strategy.detection.ConnectorTestResult;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceTable;
import org.sentrysoftware.metricshub.engine.strategy.source.SourceUpdaterProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.compute.ComputeProcessor;
import org.sentrysoftware.metricshub.engine.strategy.source.compute.ComputeUpdaterProcessor;
import org.sentrysoftware.metricshub.engine.strategy.utils.ForceSerializationHelper;
import org.sentrysoftware.metricshub.engine.strategy.utils.RetryOperation;
import org.sentrysoftware.metricshub.engine.telemetry.ConnectorNamespace;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStrategy
implements IStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractStrategy.class);
    @NonNull
    protected TelemetryManager telemetryManager;
    @NonNull
    protected Long strategyTime;
    @NonNull
    protected ClientsExecutor clientsExecutor;
    @NonNull
    protected ExtensionManager extensionManager;
    private static final String COMPUTE = "compute";
    private static final String SOURCE = "source";
    public static final String CONNECTOR_ID_FORMAT = "%s_%s";

    protected void processSourcesAndComputes(List<Source> sources, JobInfo jobInfo) {
        this.processSourcesAndComputes(sources, null, jobInfo);
    }

    protected void processSourcesAndComputes(List<Source> sources, Map<String, String> attributes, JobInfo jobInfo) {
        String connectorId = jobInfo.getConnectorId();
        String monitorType = jobInfo.getMonitorType();
        String hostname = jobInfo.getHostname();
        if (sources == null || sources.isEmpty()) {
            log.debug("Hostname {} - No sources found from connector {} with monitor {}.", new Object[]{hostname, connectorId, monitorType});
            return;
        }
        for (Source source : sources) {
            boolean isNullSourceTable;
            String sourceKey = source.getKey();
            AbstractStrategy.logBeginOperation(SOURCE, source, sourceKey, connectorId, hostname);
            SourceTable previousSourceTable = this.telemetryManager.getHostProperties().getConnectorNamespace(connectorId).getSourceTable(sourceKey);
            SourceTable sourceTable = RetryOperation.builder().withDefaultValue(SourceTable.empty()).withMaxRetries(1).withWaitStrategy(this.telemetryManager.getHostConfiguration().getRetryDelay()).withDescription(String.format("%s [%s]", SOURCE, sourceKey)).withHostname(hostname).build().run(() -> this.runSource(connectorId, attributes, source, previousSourceTable));
            boolean bl = isNullSourceTable = sourceTable == null;
            if (isNullSourceTable || sourceTable.isEmpty()) {
                log.warn("Hostname {} - Received {} source table for Source key {} - Connector {} - Monitor {}. The source table is set to empty.", new Object[]{hostname, isNullSourceTable ? "null" : "empty", sourceKey, connectorId, monitorType});
                sourceTable = SourceTable.builder().rawData(sourceTable.getRawData()).table(new ArrayList<List<String>>()).build();
            }
            AbstractStrategy.logSourceTable(SOURCE, source.getClass().getSimpleName(), sourceKey, connectorId, sourceTable, hostname);
            List<Compute> computes = source.getComputes();
            if (computes == null || computes.isEmpty()) {
                this.telemetryManager.getHostProperties().getConnectorNamespace(connectorId).addSourceTable(sourceKey, sourceTable);
                continue;
            }
            ComputeProcessor computeProcessor = ComputeProcessor.builder().sourceKey(sourceKey).sourceTable(sourceTable).connectorId(connectorId).hostname(hostname).clientsExecutor(this.clientsExecutor).telemetryManager(this.telemetryManager).build();
            ComputeUpdaterProcessor computeUpdaterProcessor = ComputeUpdaterProcessor.builder().computeProcessor(computeProcessor).attributes(attributes).connectorId(connectorId).telemetryManager(this.telemetryManager).build();
            for (int index = 0; index < computes.size(); ++index) {
                Compute compute = computes.get(index);
                computeProcessor.setIndex(index);
                String computeKey = String.format("%s -> computes[%d]", sourceKey, index);
                AbstractStrategy.logBeginOperation(COMPUTE, compute, computeKey, connectorId, hostname);
                compute.accept(computeUpdaterProcessor);
                AbstractStrategy.logSourceTable(COMPUTE, compute.getClass().getSimpleName(), computeKey, connectorId, computeProcessor.getSourceTable(), hostname);
            }
            this.telemetryManager.getHostProperties().getConnectorNamespace(connectorId).addSourceTable(sourceKey, computeProcessor.getSourceTable());
        }
    }

    private boolean isNullOrEmptySourceTable(SourceTable sourceTable) {
        return sourceTable == null || sourceTable.isEmpty();
    }

    private SourceTable runSource(String connectorId, Map<String, String> attributes, Source source, SourceTable previousSourceTable) {
        SourceProcessor sourceProcessor = SourceProcessor.builder().connectorId(connectorId).clientsExecutor(this.clientsExecutor).telemetryManager(this.telemetryManager).extensionManager(this.extensionManager).build();
        Supplier<SourceTable> executable = () -> source.accept(SourceUpdaterProcessor.builder().connectorId(connectorId).sourceProcessor(sourceProcessor).telemetryManager(this.telemetryManager).attributes(attributes).build());
        SourceTable sourceTable = source.isForceSerialization() ? ForceSerializationHelper.forceSerialization(executable, this.telemetryManager, connectorId, source, SOURCE, SourceTable.empty()) : executable.get();
        if (!this.isNullOrEmptySourceTable(previousSourceTable) && this.isNullOrEmptySourceTable(sourceTable)) {
            throw new RetryableException();
        }
        return sourceTable;
    }

    private static <T> void logBeginOperation(String operationTag, T execution, String executionKey, String connectorId, String hostname) {
        if (!log.isInfoEnabled()) {
            return;
        }
        log.info("Hostname {} - Begin {} [{} {}] for connector [{}]:\n{}\n", new Object[]{hostname, operationTag, execution.getClass().getSimpleName(), executionKey, connectorId, execution.toString()});
    }

    static void logSourceTable(String operationTag, String executionClassName, String executionKey, String connectorId, SourceTable sourceTable, String hostname) {
        if (!log.isInfoEnabled()) {
            return;
        }
        if (sourceTable.getRawData() != null && (sourceTable.getTable() == null || sourceTable.getTable().isEmpty())) {
            log.info("Hostname {} - End of {} [{} {}] for connector [{}].\nRaw result:\n{}\n", new Object[]{hostname, operationTag, executionClassName, executionKey, connectorId, sourceTable.getRawData()});
            return;
        }
        if (sourceTable.getRawData() == null) {
            log.info("Hostname {} - End of {} [{} {}] for connector [{}].\nTable result:\n{}\n", new Object[]{hostname, operationTag, executionClassName, executionKey, connectorId, TextTableHelper.generateTextTable(sourceTable.getHeaders(), sourceTable.getTable())});
            return;
        }
        log.info("Hostname {} - End of {} [{} {}] for connector [{}].\nRaw result:\n{}\nTable result:\n{}\n", new Object[]{hostname, operationTag, executionClassName, executionKey, connectorId, sourceTable.getRawData(), TextTableHelper.generateTextTable(sourceTable.getHeaders(), sourceTable.getTable())});
    }

    @Override
    public long getStrategyTimeout() {
        return this.telemetryManager.getHostConfiguration().getStrategyTimeout();
    }

    protected boolean validateConnectorDetectionCriteria(Connector currentConnector, String hostname) {
        if (currentConnector.getConnectorIdentity().getDetection() == null) {
            return true;
        }
        ConnectorTestResult connectorTestResult = new ConnectorSelection(this.telemetryManager, this.clientsExecutor, Collections.emptySet(), this.extensionManager).runConnectorDetectionCriteria(currentConnector, hostname);
        String connectorId = currentConnector.getCompiledFilename();
        Monitor monitor = this.telemetryManager.findMonitorByTypeAndId(KnownMonitorType.CONNECTOR.getKey(), String.format(CONNECTOR_ID_FORMAT, KnownMonitorType.CONNECTOR.getKey(), connectorId));
        String statusInformation = this.buildStatusInformation(hostname, connectorTestResult);
        Map<String, String> legacyTextParameters = monitor.getLegacyTextParameters();
        legacyTextParameters.put("StatusInformation", statusInformation);
        this.collectConnectorStatus(connectorTestResult.isSuccess(), connectorId, monitor);
        return connectorTestResult.isSuccess();
    }

    protected String buildStatusInformation(String hostname, ConnectorTestResult testResult) {
        StringBuilder value = new StringBuilder();
        String builtTestResult = testResult.getCriterionTestResults().stream().filter(criterionTestResult -> criterionTestResult.getResult() != null || criterionTestResult.getMessage() != null).map(criterionResult -> {
            String result = criterionResult.getResult();
            String message = criterionResult.getMessage();
            return String.format("Received Result: %s. %s", result != null ? result : "N/A", message != null ? message : "N/A");
        }).collect(Collectors.joining("\n"));
        value.append(builtTestResult).append("\nConclusion: ").append("Test on ").append(hostname).append(" ").append(testResult.isSuccess() ? "SUCCEEDED" : "FAILED");
        return value.toString();
    }

    protected void collectConnectorStatus(boolean isSuccessCriteria, String connectorId, Monitor monitor) {
        MetricFactory metricFactory = new MetricFactory(this.telemetryManager.getHostname());
        ConnectorNamespace connectorNamespace = this.telemetryManager.getHostProperties().getConnectorNamespace(connectorId);
        metricFactory.collectStateSetMetric(monitor, "metricshub.connector.status", isSuccessCriteria ? "ok" : "failed", new String[]{"ok", "failed"}, this.strategyTime);
        connectorNamespace.setStatusOk(isSuccessCriteria);
    }

    public boolean isMonitorFiltered(String monitorType) {
        HostConfiguration hostConfiguration = this.telemetryManager.getHostConfiguration();
        Set<String> includedMonitors = hostConfiguration.getIncludedMonitors();
        Set<String> excludedMonitors = hostConfiguration.getExcludedMonitors();
        return includedMonitors != null && !includedMonitors.contains(monitorType) || excludedMonitors != null && excludedMonitors.contains(monitorType);
    }

    @NonNull
    @Generated
    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    @Override
    @NonNull
    @Generated
    public Long getStrategyTime() {
        return this.strategyTime;
    }

    @NonNull
    @Generated
    public ClientsExecutor getClientsExecutor() {
        return this.clientsExecutor;
    }

    @NonNull
    @Generated
    public ExtensionManager getExtensionManager() {
        return this.extensionManager;
    }

    @Generated
    public void setTelemetryManager(@NonNull TelemetryManager telemetryManager) {
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        this.telemetryManager = telemetryManager;
    }

    @Generated
    public void setStrategyTime(@NonNull Long strategyTime) {
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        this.strategyTime = strategyTime;
    }

    @Generated
    public void setClientsExecutor(@NonNull ClientsExecutor clientsExecutor) {
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        this.clientsExecutor = clientsExecutor;
    }

    @Generated
    public void setExtensionManager(@NonNull ExtensionManager extensionManager) {
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
        this.extensionManager = extensionManager;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractStrategy)) {
            return false;
        }
        AbstractStrategy other = (AbstractStrategy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$strategyTime = this.getStrategyTime();
        Long other$strategyTime = other.getStrategyTime();
        if (this$strategyTime == null ? other$strategyTime != null : !((Object)this$strategyTime).equals(other$strategyTime)) {
            return false;
        }
        TelemetryManager this$telemetryManager = this.getTelemetryManager();
        TelemetryManager other$telemetryManager = other.getTelemetryManager();
        if (this$telemetryManager == null ? other$telemetryManager != null : !((Object)this$telemetryManager).equals(other$telemetryManager)) {
            return false;
        }
        ClientsExecutor this$clientsExecutor = this.getClientsExecutor();
        ClientsExecutor other$clientsExecutor = other.getClientsExecutor();
        if (this$clientsExecutor == null ? other$clientsExecutor != null : !((Object)this$clientsExecutor).equals(other$clientsExecutor)) {
            return false;
        }
        ExtensionManager this$extensionManager = this.getExtensionManager();
        ExtensionManager other$extensionManager = other.getExtensionManager();
        return !(this$extensionManager == null ? other$extensionManager != null : !((Object)this$extensionManager).equals(other$extensionManager));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractStrategy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $strategyTime = this.getStrategyTime();
        result = result * 59 + ($strategyTime == null ? 43 : ((Object)$strategyTime).hashCode());
        TelemetryManager $telemetryManager = this.getTelemetryManager();
        result = result * 59 + ($telemetryManager == null ? 43 : ((Object)$telemetryManager).hashCode());
        ClientsExecutor $clientsExecutor = this.getClientsExecutor();
        result = result * 59 + ($clientsExecutor == null ? 43 : ((Object)$clientsExecutor).hashCode());
        ExtensionManager $extensionManager = this.getExtensionManager();
        result = result * 59 + ($extensionManager == null ? 43 : ((Object)$extensionManager).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractStrategy(telemetryManager=" + String.valueOf(this.getTelemetryManager()) + ", strategyTime=" + this.getStrategyTime() + ", clientsExecutor=" + String.valueOf(this.getClientsExecutor()) + ", extensionManager=" + String.valueOf(this.getExtensionManager()) + ")";
    }

    @Generated
    public AbstractStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull ExtensionManager extensionManager) {
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
        this.telemetryManager = telemetryManager;
        this.strategyTime = strategyTime;
        this.clientsExecutor = clientsExecutor;
        this.extensionManager = extensionManager;
    }

    @Generated
    public AbstractStrategy() {
    }
}

