/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.collect;

import java.util.List;
import lombok.Generated;
import lombok.NonNull;
import org.sentrysoftware.metricshub.engine.client.ClientsExecutor;
import org.sentrysoftware.metricshub.engine.extension.ExtensionManager;
import org.sentrysoftware.metricshub.engine.extension.IProtocolExtension;
import org.sentrysoftware.metricshub.engine.strategy.AbstractStrategy;
import org.sentrysoftware.metricshub.engine.telemetry.MetricFactory;
import org.sentrysoftware.metricshub.engine.telemetry.Monitor;
import org.sentrysoftware.metricshub.engine.telemetry.TelemetryManager;

public class ProtocolHealthCheckStrategy
extends AbstractStrategy {
    public static final Double UP = 1.0;
    public static final Double DOWN = 0.0;

    public ProtocolHealthCheckStrategy(@NonNull TelemetryManager telemetryManager, @NonNull Long strategyTime, @NonNull ClientsExecutor clientsExecutor, @NonNull ExtensionManager extensionManager) {
        super(telemetryManager, strategyTime, clientsExecutor, extensionManager);
        if (telemetryManager == null) {
            throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
        }
        if (strategyTime == null) {
            throw new IllegalArgumentException("strategyTime is marked non-null but is null");
        }
        if (clientsExecutor == null) {
            throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
        }
        if (extensionManager == null) {
            throw new IllegalArgumentException("extensionManager is marked non-null but is null");
        }
    }

    @Override
    public void run() {
        List<IProtocolExtension> protocolExtensions = this.extensionManager.findProtocolCheckExtensions(this.telemetryManager);
        protocolExtensions.forEach(protocolExtension -> {
            long startTime = System.currentTimeMillis();
            protocolExtension.checkProtocol(this.telemetryManager).ifPresent(isUp -> {
                Double responseTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                Monitor endpointHostMonitor = this.telemetryManager.getEndpointHostMonitor();
                Long strategyTime = this.telemetryManager.getStrategyTime();
                MetricFactory metricFactory = new MetricFactory();
                metricFactory.collectNumberMetric(endpointHostMonitor, "metricshub.host.up{protocol=\"" + protocolExtension.getIdentifier() + "\"}", isUp != false ? UP : DOWN, strategyTime);
                metricFactory.collectNumberMetric(endpointHostMonitor, "metricshub.host.up.response_time{protocol=\"" + protocolExtension.getIdentifier() + "\"}", responseTime, strategyTime);
            });
        });
    }

    @Override
    public long getStrategyTimeout() {
        return this.telemetryManager.getHostConfiguration().getStrategyTimeout();
    }

    @Override
    public Long getStrategyTime() {
        return this.telemetryManager.getStrategyTime();
    }

    @Generated
    public static ProtocolHealthCheckStrategyBuilder builder() {
        return new ProtocolHealthCheckStrategyBuilder();
    }

    @Generated
    public static class ProtocolHealthCheckStrategyBuilder {
        @Generated
        private TelemetryManager telemetryManager;
        @Generated
        private Long strategyTime;
        @Generated
        private ClientsExecutor clientsExecutor;
        @Generated
        private ExtensionManager extensionManager;

        @Generated
        ProtocolHealthCheckStrategyBuilder() {
        }

        @Generated
        public ProtocolHealthCheckStrategyBuilder telemetryManager(@NonNull TelemetryManager telemetryManager) {
            if (telemetryManager == null) {
                throw new IllegalArgumentException("telemetryManager is marked non-null but is null");
            }
            this.telemetryManager = telemetryManager;
            return this;
        }

        @Generated
        public ProtocolHealthCheckStrategyBuilder strategyTime(@NonNull Long strategyTime) {
            if (strategyTime == null) {
                throw new IllegalArgumentException("strategyTime is marked non-null but is null");
            }
            this.strategyTime = strategyTime;
            return this;
        }

        @Generated
        public ProtocolHealthCheckStrategyBuilder clientsExecutor(@NonNull ClientsExecutor clientsExecutor) {
            if (clientsExecutor == null) {
                throw new IllegalArgumentException("clientsExecutor is marked non-null but is null");
            }
            this.clientsExecutor = clientsExecutor;
            return this;
        }

        @Generated
        public ProtocolHealthCheckStrategyBuilder extensionManager(@NonNull ExtensionManager extensionManager) {
            if (extensionManager == null) {
                throw new IllegalArgumentException("extensionManager is marked non-null but is null");
            }
            this.extensionManager = extensionManager;
            return this;
        }

        @Generated
        public ProtocolHealthCheckStrategy build() {
            return new ProtocolHealthCheckStrategy(this.telemetryManager, this.strategyTime, this.clientsExecutor, this.extensionManager);
        }

        @Generated
        public String toString() {
            return "ProtocolHealthCheckStrategy.ProtocolHealthCheckStrategyBuilder(telemetryManager=" + String.valueOf(this.telemetryManager) + ", strategyTime=" + this.strategyTime + ", clientsExecutor=" + String.valueOf(this.clientsExecutor) + ", extensionManager=" + String.valueOf(this.extensionManager) + ")";
        }
    }
}

