/*
 * Decompiled with CFR 0.152.
 */
package org.sentrysoftware.metricshub.engine.strategy.detection;

import lombok.Generated;
import org.sentrysoftware.metricshub.engine.connector.model.identity.criterion.Criterion;

public class CriterionTestResult {
    private String result;
    private boolean success;
    private String message;
    private Throwable exception;

    public static CriterionTestResult empty() {
        return CriterionTestResult.builder().build();
    }

    public static CriterionTestResult failure(Criterion criterion, String result) {
        String message = String.format("%s test ran but failed:\n%s\n\nActual result:\n%s", criterion.getClass().getSimpleName(), criterion.toString(), result);
        return CriterionTestResult.builder().success(false).message(message).result(result).build();
    }

    public static CriterionTestResult error(Criterion criterion, String reason, Throwable t) {
        Object message = criterion == null ? "Error with a <null> Criterion: " + reason : String.format("Error in %s test:\n%s\n\n%s", criterion.getClass().getSimpleName(), criterion.toString(), reason);
        return CriterionTestResult.builder().success(false).message((String)message).exception(t).build();
    }

    public static CriterionTestResult error(Criterion criterion, String reason) {
        return CriterionTestResult.error(criterion, reason, null);
    }

    public static CriterionTestResult error(Criterion criterion, Throwable t) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(t.getClass().getSimpleName()).append(": ").append(t.getMessage());
        Throwable cause = t.getCause();
        if (cause != null) {
            messageBuilder.append("\nCaused by ").append(cause.getClass().getSimpleName()).append(": ").append(cause.getMessage());
        } else {
            cause = t;
        }
        return CriterionTestResult.error(criterion, messageBuilder.toString(), cause);
    }

    public static CriterionTestResult success(Criterion criterion, String result) {
        String message = String.format("%s test succeeded:\n%s\n\nResult: %s", criterion.getClass().getSimpleName(), criterion.toString(), result);
        return CriterionTestResult.builder().success(true).message(message).result(result).build();
    }

    @Generated
    public static CriterionTestResultBuilder builder() {
        return new CriterionTestResultBuilder();
    }

    @Generated
    public String getResult() {
        return this.result;
    }

    @Generated
    public boolean isSuccess() {
        return this.success;
    }

    @Generated
    public String getMessage() {
        return this.message;
    }

    @Generated
    public Throwable getException() {
        return this.exception;
    }

    @Generated
    public void setResult(String result) {
        this.result = result;
    }

    @Generated
    public void setSuccess(boolean success) {
        this.success = success;
    }

    @Generated
    public void setMessage(String message) {
        this.message = message;
    }

    @Generated
    public void setException(Throwable exception) {
        this.exception = exception;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CriterionTestResult)) {
            return false;
        }
        CriterionTestResult other = (CriterionTestResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$result = this.getResult();
        String other$result = other.getResult();
        if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        Throwable this$exception = this.getException();
        Throwable other$exception = other.getException();
        return !(this$exception == null ? other$exception != null : !this$exception.equals(other$exception));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CriterionTestResult;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $result = this.getResult();
        result = result * 59 + ($result == null ? 43 : $result.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        Throwable $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : $exception.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CriterionTestResult(result=" + this.getResult() + ", success=" + this.isSuccess() + ", message=" + this.getMessage() + ", exception=" + String.valueOf(this.getException()) + ")";
    }

    @Generated
    public CriterionTestResult(String result, boolean success, String message, Throwable exception) {
        this.result = result;
        this.success = success;
        this.message = message;
        this.exception = exception;
    }

    @Generated
    public CriterionTestResult() {
    }

    @Generated
    public static class CriterionTestResultBuilder {
        @Generated
        private String result;
        @Generated
        private boolean success;
        @Generated
        private String message;
        @Generated
        private Throwable exception;

        @Generated
        CriterionTestResultBuilder() {
        }

        @Generated
        public CriterionTestResultBuilder result(String result) {
            this.result = result;
            return this;
        }

        @Generated
        public CriterionTestResultBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        @Generated
        public CriterionTestResultBuilder message(String message) {
            this.message = message;
            return this;
        }

        @Generated
        public CriterionTestResultBuilder exception(Throwable exception) {
            this.exception = exception;
            return this;
        }

        @Generated
        public CriterionTestResult build() {
            return new CriterionTestResult(this.result, this.success, this.message, this.exception);
        }

        @Generated
        public String toString() {
            return "CriterionTestResult.CriterionTestResultBuilder(result=" + this.result + ", success=" + this.success + ", message=" + this.message + ", exception=" + String.valueOf(this.exception) + ")";
        }
    }
}

